/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Settlement reports detail order-level and item-level credits and debits between you and Google.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SettlementReport extends com.google.api.client.json.GenericJson {

  /**
   * The end date on which all transactions are included in the report, in ISO 8601 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String endDate;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#settlementReport`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The residual amount from the previous invoice. This is set only if the previous invoices are
   * not paid because of negative balance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price previousBalance;

  /**
   * The ID of the settlement report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String settlementId;

  /**
   * The start date on which all transactions are included in the report, in ISO 8601 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String startDate;

  /**
   * The money due to the merchant.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price transferAmount;

  /**
   * Date on which transfer for this payment was initiated by Google, in ISO 8601 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String transferDate;

  /**
   * The list of bank identifiers used for the transfer. For example, Trace ID for Federal Automated
   * Clearing House (ACH). This may also be known as the Wire ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> transferIds;

  /**
   * The end date on which all transactions are included in the report, in ISO 8601 format.
   * @return value or {@code null} for none
   */
  public java.lang.String getEndDate() {
    return endDate;
  }

  /**
   * The end date on which all transactions are included in the report, in ISO 8601 format.
   * @param endDate endDate or {@code null} for none
   */
  public SettlementReport setEndDate(java.lang.String endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#settlementReport`"
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#settlementReport`"
   * @param kind kind or {@code null} for none
   */
  public SettlementReport setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The residual amount from the previous invoice. This is set only if the previous invoices are
   * not paid because of negative balance.
   * @return value or {@code null} for none
   */
  public Price getPreviousBalance() {
    return previousBalance;
  }

  /**
   * The residual amount from the previous invoice. This is set only if the previous invoices are
   * not paid because of negative balance.
   * @param previousBalance previousBalance or {@code null} for none
   */
  public SettlementReport setPreviousBalance(Price previousBalance) {
    this.previousBalance = previousBalance;
    return this;
  }

  /**
   * The ID of the settlement report.
   * @return value or {@code null} for none
   */
  public java.lang.String getSettlementId() {
    return settlementId;
  }

  /**
   * The ID of the settlement report.
   * @param settlementId settlementId or {@code null} for none
   */
  public SettlementReport setSettlementId(java.lang.String settlementId) {
    this.settlementId = settlementId;
    return this;
  }

  /**
   * The start date on which all transactions are included in the report, in ISO 8601 format.
   * @return value or {@code null} for none
   */
  public java.lang.String getStartDate() {
    return startDate;
  }

  /**
   * The start date on which all transactions are included in the report, in ISO 8601 format.
   * @param startDate startDate or {@code null} for none
   */
  public SettlementReport setStartDate(java.lang.String startDate) {
    this.startDate = startDate;
    return this;
  }

  /**
   * The money due to the merchant.
   * @return value or {@code null} for none
   */
  public Price getTransferAmount() {
    return transferAmount;
  }

  /**
   * The money due to the merchant.
   * @param transferAmount transferAmount or {@code null} for none
   */
  public SettlementReport setTransferAmount(Price transferAmount) {
    this.transferAmount = transferAmount;
    return this;
  }

  /**
   * Date on which transfer for this payment was initiated by Google, in ISO 8601 format.
   * @return value or {@code null} for none
   */
  public java.lang.String getTransferDate() {
    return transferDate;
  }

  /**
   * Date on which transfer for this payment was initiated by Google, in ISO 8601 format.
   * @param transferDate transferDate or {@code null} for none
   */
  public SettlementReport setTransferDate(java.lang.String transferDate) {
    this.transferDate = transferDate;
    return this;
  }

  /**
   * The list of bank identifiers used for the transfer. For example, Trace ID for Federal Automated
   * Clearing House (ACH). This may also be known as the Wire ID.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTransferIds() {
    return transferIds;
  }

  /**
   * The list of bank identifiers used for the transfer. For example, Trace ID for Federal Automated
   * Clearing House (ACH). This may also be known as the Wire ID.
   * @param transferIds transferIds or {@code null} for none
   */
  public SettlementReport setTransferIds(java.util.List<java.lang.String> transferIds) {
    this.transferIds = transferIds;
    return this;
  }

  @Override
  public SettlementReport set(String fieldName, Object value) {
    return (SettlementReport) super.set(fieldName, value);
  }

  @Override
  public SettlementReport clone() {
    return (SettlementReport) super.clone();
  }

}
