/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Specifications related to the `Checkout` URL. The `UriTemplate` is of the form
 * `https://www.mystore.com/checkout?item_id={id}` where `{id}` will be automatically replaced with
 * data from the merchant account with this attribute [offer_id](https://developers.google.com
 * /shopping-content/reference/rest/v2.1/products#Product.FIELDS.offer_id)
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UrlSettings extends com.google.api.client.json.GenericJson {

  /**
   * URL template when the placeholders are expanded will redirect the buyer to the cart page on the
   * merchant website with the selected item in cart.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cartUriTemplate;

  /**
   * URL template when the placeholders are expanded will redirect the buyer to the merchant
   * checkout page with the item in the cart.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String checkoutUriTemplate;

  /**
   * URL template when the placeholders are expanded will redirect the buyer to the cart page on the
   * merchant website with the selected item in cart.
   * @return value or {@code null} for none
   */
  public java.lang.String getCartUriTemplate() {
    return cartUriTemplate;
  }

  /**
   * URL template when the placeholders are expanded will redirect the buyer to the cart page on the
   * merchant website with the selected item in cart.
   * @param cartUriTemplate cartUriTemplate or {@code null} for none
   */
  public UrlSettings setCartUriTemplate(java.lang.String cartUriTemplate) {
    this.cartUriTemplate = cartUriTemplate;
    return this;
  }

  /**
   * URL template when the placeholders are expanded will redirect the buyer to the merchant
   * checkout page with the item in the cart.
   * @return value or {@code null} for none
   */
  public java.lang.String getCheckoutUriTemplate() {
    return checkoutUriTemplate;
  }

  /**
   * URL template when the placeholders are expanded will redirect the buyer to the merchant
   * checkout page with the item in the cart.
   * @param checkoutUriTemplate checkoutUriTemplate or {@code null} for none
   */
  public UrlSettings setCheckoutUriTemplate(java.lang.String checkoutUriTemplate) {
    this.checkoutUriTemplate = checkoutUriTemplate;
    return this;
  }

  @Override
  public UrlSettings set(String fieldName, Object value) {
    return (UrlSettings) super.set(fieldName, value);
  }

  @Override
  public UrlSettings clone() {
    return (UrlSettings) super.clone();
  }

}
