/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.content;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.content.ShoppingContentRequest;
import com.google.api.services.content.ShoppingContentRequestInitializer;
import com.google.api.services.content.model.Account;
import com.google.api.services.content.model.AccountCredentials;
import com.google.api.services.content.model.AccountLabel;
import com.google.api.services.content.model.AccountReturnCarrier;
import com.google.api.services.content.model.AccountStatus;
import com.google.api.services.content.model.AccountTax;
import com.google.api.services.content.model.AccountsAuthInfoResponse;
import com.google.api.services.content.model.AccountsClaimWebsiteResponse;
import com.google.api.services.content.model.AccountsCustomBatchRequest;
import com.google.api.services.content.model.AccountsCustomBatchResponse;
import com.google.api.services.content.model.AccountsLinkRequest;
import com.google.api.services.content.model.AccountsLinkResponse;
import com.google.api.services.content.model.AccountsListLinksResponse;
import com.google.api.services.content.model.AccountsListResponse;
import com.google.api.services.content.model.AccountsUpdateLabelsRequest;
import com.google.api.services.content.model.AccountsUpdateLabelsResponse;
import com.google.api.services.content.model.AccountstatusesCustomBatchRequest;
import com.google.api.services.content.model.AccountstatusesCustomBatchResponse;
import com.google.api.services.content.model.AccountstatusesListResponse;
import com.google.api.services.content.model.AccounttaxCustomBatchRequest;
import com.google.api.services.content.model.AccounttaxCustomBatchResponse;
import com.google.api.services.content.model.AccounttaxListResponse;
import com.google.api.services.content.model.CheckoutSettings;
import com.google.api.services.content.model.Collection;
import com.google.api.services.content.model.CollectionStatus;
import com.google.api.services.content.model.ConversionSource;
import com.google.api.services.content.model.Css;
import com.google.api.services.content.model.Datafeed;
import com.google.api.services.content.model.DatafeedStatus;
import com.google.api.services.content.model.DatafeedsCustomBatchRequest;
import com.google.api.services.content.model.DatafeedsCustomBatchResponse;
import com.google.api.services.content.model.DatafeedsFetchNowResponse;
import com.google.api.services.content.model.DatafeedsListResponse;
import com.google.api.services.content.model.DatafeedstatusesCustomBatchRequest;
import com.google.api.services.content.model.DatafeedstatusesCustomBatchResponse;
import com.google.api.services.content.model.DatafeedstatusesListResponse;
import com.google.api.services.content.model.FreeListingsProgramStatus;
import com.google.api.services.content.model.GenerateRecommendationsResponse;
import com.google.api.services.content.model.InsertCheckoutSettingsRequest;
import com.google.api.services.content.model.LabelIds;
import com.google.api.services.content.model.LiaOmnichannelExperience;
import com.google.api.services.content.model.LiaSettings;
import com.google.api.services.content.model.LiasettingsCustomBatchRequest;
import com.google.api.services.content.model.LiasettingsCustomBatchResponse;
import com.google.api.services.content.model.LiasettingsGetAccessibleGmbAccountsResponse;
import com.google.api.services.content.model.LiasettingsListPosDataProvidersResponse;
import com.google.api.services.content.model.LiasettingsListResponse;
import com.google.api.services.content.model.LiasettingsRequestGmbAccessResponse;
import com.google.api.services.content.model.LiasettingsRequestInventoryVerificationResponse;
import com.google.api.services.content.model.LiasettingsSetInventoryVerificationContactResponse;
import com.google.api.services.content.model.LiasettingsSetPosDataProviderResponse;
import com.google.api.services.content.model.ListAccountLabelsResponse;
import com.google.api.services.content.model.ListAccountReturnCarrierResponse;
import com.google.api.services.content.model.ListCollectionStatusesResponse;
import com.google.api.services.content.model.ListCollectionsResponse;
import com.google.api.services.content.model.ListConversionSourcesResponse;
import com.google.api.services.content.model.ListCssesResponse;
import com.google.api.services.content.model.ListMethodQuotasResponse;
import com.google.api.services.content.model.ListPromotionResponse;
import com.google.api.services.content.model.ListRegionsResponse;
import com.google.api.services.content.model.ListReturnPolicyOnlineResponse;
import com.google.api.services.content.model.LocalInventory;
import com.google.api.services.content.model.LocalinventoryCustomBatchRequest;
import com.google.api.services.content.model.LocalinventoryCustomBatchResponse;
import com.google.api.services.content.model.OrderTrackingSignal;
import com.google.api.services.content.model.PosCustomBatchRequest;
import com.google.api.services.content.model.PosCustomBatchResponse;
import com.google.api.services.content.model.PosInventoryRequest;
import com.google.api.services.content.model.PosInventoryResponse;
import com.google.api.services.content.model.PosListResponse;
import com.google.api.services.content.model.PosSaleRequest;
import com.google.api.services.content.model.PosSaleResponse;
import com.google.api.services.content.model.PosStore;
import com.google.api.services.content.model.Product;
import com.google.api.services.content.model.ProductDeliveryTime;
import com.google.api.services.content.model.ProductStatus;
import com.google.api.services.content.model.ProductsCustomBatchRequest;
import com.google.api.services.content.model.ProductsCustomBatchResponse;
import com.google.api.services.content.model.ProductsListResponse;
import com.google.api.services.content.model.ProductstatusesCustomBatchRequest;
import com.google.api.services.content.model.ProductstatusesCustomBatchResponse;
import com.google.api.services.content.model.ProductstatusesListResponse;
import com.google.api.services.content.model.Promotion;
import com.google.api.services.content.model.PubsubNotificationSettings;
import com.google.api.services.content.model.Region;
import com.google.api.services.content.model.RegionalInventory;
import com.google.api.services.content.model.RegionalinventoryCustomBatchRequest;
import com.google.api.services.content.model.RegionalinventoryCustomBatchResponse;
import com.google.api.services.content.model.RenderAccountIssuesRequestPayload;
import com.google.api.services.content.model.RenderAccountIssuesResponse;
import com.google.api.services.content.model.RenderProductIssuesRequestPayload;
import com.google.api.services.content.model.RenderProductIssuesResponse;
import com.google.api.services.content.model.ReportInteractionRequest;
import com.google.api.services.content.model.RequestPhoneVerificationRequest;
import com.google.api.services.content.model.RequestPhoneVerificationResponse;
import com.google.api.services.content.model.RequestReviewFreeListingsRequest;
import com.google.api.services.content.model.RequestReviewShoppingAdsRequest;
import com.google.api.services.content.model.ReturnAddress;
import com.google.api.services.content.model.ReturnPolicy;
import com.google.api.services.content.model.ReturnPolicyOnline;
import com.google.api.services.content.model.ReturnaddressCustomBatchRequest;
import com.google.api.services.content.model.ReturnaddressCustomBatchResponse;
import com.google.api.services.content.model.ReturnaddressListResponse;
import com.google.api.services.content.model.ReturnpolicyCustomBatchRequest;
import com.google.api.services.content.model.ReturnpolicyCustomBatchResponse;
import com.google.api.services.content.model.ReturnpolicyListResponse;
import com.google.api.services.content.model.SearchRequest;
import com.google.api.services.content.model.SearchResponse;
import com.google.api.services.content.model.SettlementReport;
import com.google.api.services.content.model.SettlementreportsListResponse;
import com.google.api.services.content.model.SettlementtransactionsListResponse;
import com.google.api.services.content.model.ShippingSettings;
import com.google.api.services.content.model.ShippingsettingsCustomBatchRequest;
import com.google.api.services.content.model.ShippingsettingsCustomBatchResponse;
import com.google.api.services.content.model.ShippingsettingsGetSupportedCarriersResponse;
import com.google.api.services.content.model.ShippingsettingsGetSupportedHolidaysResponse;
import com.google.api.services.content.model.ShippingsettingsGetSupportedPickupServicesResponse;
import com.google.api.services.content.model.ShippingsettingsListResponse;
import com.google.api.services.content.model.ShoppingAdsProgramStatus;
import com.google.api.services.content.model.TriggerActionPayload;
import com.google.api.services.content.model.TriggerActionResponse;
import com.google.api.services.content.model.UndeleteConversionSourceRequest;
import com.google.api.services.content.model.VerifyPhoneNumberRequest;
import com.google.api.services.content.model.VerifyPhoneNumberResponse;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;

public class ShoppingContent
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://shoppingcontent.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://shoppingcontent.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "content/v2.1/";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://shoppingcontent.googleapis.com/content/v2.1/";

    public ShoppingContent(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    ShoppingContent(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Accounts accounts() {
        return new Accounts();
    }

    public Accountstatuses accountstatuses() {
        return new Accountstatuses();
    }

    public Accounttax accounttax() {
        return new Accounttax();
    }

    public Collections collections() {
        return new Collections();
    }

    public Collectionstatuses collectionstatuses() {
        return new Collectionstatuses();
    }

    public Conversionsources conversionsources() {
        return new Conversionsources();
    }

    public Csses csses() {
        return new Csses();
    }

    public Datafeeds datafeeds() {
        return new Datafeeds();
    }

    public Datafeedstatuses datafeedstatuses() {
        return new Datafeedstatuses();
    }

    public Freelistingsprogram freelistingsprogram() {
        return new Freelistingsprogram();
    }

    public Liasettings liasettings() {
        return new Liasettings();
    }

    public Localinventory localinventory() {
        return new Localinventory();
    }

    public Merchantsupport merchantsupport() {
        return new Merchantsupport();
    }

    public Ordertrackingsignals ordertrackingsignals() {
        return new Ordertrackingsignals();
    }

    public Pos pos() {
        return new Pos();
    }

    public Productdeliverytime productdeliverytime() {
        return new Productdeliverytime();
    }

    public Products products() {
        return new Products();
    }

    public Productstatuses productstatuses() {
        return new Productstatuses();
    }

    public Promotions promotions() {
        return new Promotions();
    }

    public Pubsubnotificationsettings pubsubnotificationsettings() {
        return new Pubsubnotificationsettings();
    }

    public Quotas quotas() {
        return new Quotas();
    }

    public Recommendations recommendations() {
        return new Recommendations();
    }

    public Regionalinventory regionalinventory() {
        return new Regionalinventory();
    }

    public Regions regions() {
        return new Regions();
    }

    public Reports reports() {
        return new Reports();
    }

    public Returnaddress returnaddress() {
        return new Returnaddress();
    }

    public Returnpolicy returnpolicy() {
        return new Returnpolicy();
    }

    public Returnpolicyonline returnpolicyonline() {
        return new Returnpolicyonline();
    }

    public Settlementreports settlementreports() {
        return new Settlementreports();
    }

    public Settlementtransactions settlementtransactions() {
        return new Settlementtransactions();
    }

    public Shippingsettings shippingsettings() {
        return new Shippingsettings();
    }

    public Shoppingadsprogram shoppingadsprogram() {
        return new Shoppingadsprogram();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Content API for Shopping library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return ShoppingContent.DEFAULT_MTLS_ROOT_URL;
            }
            return ShoppingContent.DEFAULT_ROOT_URL;
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), ShoppingContent.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(ShoppingContent.DEFAULT_BATCH_PATH);
        }

        public ShoppingContent build() {
            return new ShoppingContent(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setShoppingContentRequestInitializer(ShoppingContentRequestInitializer shoppingcontentRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)shoppingcontentRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }

        public Builder setUniverseDomain(String universeDomain) {
            return (Builder)super.setUniverseDomain(universeDomain);
        }
    }

    public class Shoppingadsprogram {
        public Get get(Long merchantId) throws IOException {
            Get result = new Get(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Requestreview requestreview(Long merchantId, RequestReviewShoppingAdsRequest content) throws IOException {
            Requestreview result = new Requestreview(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Requestreview
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/shoppingadsprogram/requestreview";
            @Key
            private Long merchantId;

            protected Requestreview(Long merchantId, RequestReviewShoppingAdsRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Void.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Requestreview set$Xgafv(String $Xgafv) {
                return (Requestreview)super.set$Xgafv($Xgafv);
            }

            public Requestreview setAccessToken(String accessToken) {
                return (Requestreview)super.setAccessToken(accessToken);
            }

            public Requestreview setAlt(String alt) {
                return (Requestreview)super.setAlt(alt);
            }

            public Requestreview setCallback(String callback) {
                return (Requestreview)super.setCallback(callback);
            }

            public Requestreview setFields(String fields) {
                return (Requestreview)super.setFields(fields);
            }

            public Requestreview setKey(String key) {
                return (Requestreview)super.setKey(key);
            }

            public Requestreview setOauthToken(String oauthToken) {
                return (Requestreview)super.setOauthToken(oauthToken);
            }

            public Requestreview setPrettyPrint(Boolean prettyPrint) {
                return (Requestreview)super.setPrettyPrint(prettyPrint);
            }

            public Requestreview setQuotaUser(String quotaUser) {
                return (Requestreview)super.setQuotaUser(quotaUser);
            }

            public Requestreview setUploadType(String uploadType) {
                return (Requestreview)super.setUploadType(uploadType);
            }

            public Requestreview setUploadProtocol(String uploadProtocol) {
                return (Requestreview)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Requestreview setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Requestreview set(String parameterName, Object value) {
                return (Requestreview)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<ShoppingAdsProgramStatus> {
            private static final String REST_PATH = "{merchantId}/shoppingadsprogram";
            @Key
            private Long merchantId;

            protected Get(Long merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ShoppingAdsProgramStatus.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Shippingsettings {
        public Custombatch custombatch(ShippingsettingsCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, BigInteger accountId) throws IOException {
            Get result = new Get(merchantId, accountId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Getsupportedcarriers getsupportedcarriers(BigInteger merchantId) throws IOException {
            Getsupportedcarriers result = new Getsupportedcarriers(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Getsupportedholidays getsupportedholidays(BigInteger merchantId) throws IOException {
            Getsupportedholidays result = new Getsupportedholidays(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Getsupportedpickupservices getsupportedpickupservices(BigInteger merchantId) throws IOException {
            Getsupportedpickupservices result = new Getsupportedpickupservices(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(BigInteger merchantId, BigInteger accountId, ShippingSettings content) throws IOException {
            Update result = new Update(merchantId, accountId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends ShoppingContentRequest<ShippingSettings> {
            private static final String REST_PATH = "{merchantId}/shippingsettings/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Update(BigInteger merchantId, BigInteger accountId, ShippingSettings content) {
                super(ShoppingContent.this, "PUT", REST_PATH, (Object)content, ShippingSettings.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Update setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Update setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<ShippingsettingsListResponse> {
            private static final String REST_PATH = "{merchantId}/shippingsettings";
            @Key
            private BigInteger merchantId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ShippingsettingsListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Getsupportedpickupservices
        extends ShoppingContentRequest<ShippingsettingsGetSupportedPickupServicesResponse> {
            private static final String REST_PATH = "{merchantId}/supportedPickupServices";
            @Key
            private BigInteger merchantId;

            protected Getsupportedpickupservices(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ShippingsettingsGetSupportedPickupServicesResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Getsupportedpickupservices set$Xgafv(String $Xgafv) {
                return (Getsupportedpickupservices)super.set$Xgafv($Xgafv);
            }

            public Getsupportedpickupservices setAccessToken(String accessToken) {
                return (Getsupportedpickupservices)super.setAccessToken(accessToken);
            }

            public Getsupportedpickupservices setAlt(String alt) {
                return (Getsupportedpickupservices)super.setAlt(alt);
            }

            public Getsupportedpickupservices setCallback(String callback) {
                return (Getsupportedpickupservices)super.setCallback(callback);
            }

            public Getsupportedpickupservices setFields(String fields) {
                return (Getsupportedpickupservices)super.setFields(fields);
            }

            public Getsupportedpickupservices setKey(String key) {
                return (Getsupportedpickupservices)super.setKey(key);
            }

            public Getsupportedpickupservices setOauthToken(String oauthToken) {
                return (Getsupportedpickupservices)super.setOauthToken(oauthToken);
            }

            public Getsupportedpickupservices setPrettyPrint(Boolean prettyPrint) {
                return (Getsupportedpickupservices)super.setPrettyPrint(prettyPrint);
            }

            public Getsupportedpickupservices setQuotaUser(String quotaUser) {
                return (Getsupportedpickupservices)super.setQuotaUser(quotaUser);
            }

            public Getsupportedpickupservices setUploadType(String uploadType) {
                return (Getsupportedpickupservices)super.setUploadType(uploadType);
            }

            public Getsupportedpickupservices setUploadProtocol(String uploadProtocol) {
                return (Getsupportedpickupservices)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Getsupportedpickupservices setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Getsupportedpickupservices set(String parameterName, Object value) {
                return (Getsupportedpickupservices)super.set(parameterName, value);
            }
        }

        public class Getsupportedholidays
        extends ShoppingContentRequest<ShippingsettingsGetSupportedHolidaysResponse> {
            private static final String REST_PATH = "{merchantId}/supportedHolidays";
            @Key
            private BigInteger merchantId;

            protected Getsupportedholidays(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ShippingsettingsGetSupportedHolidaysResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Getsupportedholidays set$Xgafv(String $Xgafv) {
                return (Getsupportedholidays)super.set$Xgafv($Xgafv);
            }

            public Getsupportedholidays setAccessToken(String accessToken) {
                return (Getsupportedholidays)super.setAccessToken(accessToken);
            }

            public Getsupportedholidays setAlt(String alt) {
                return (Getsupportedholidays)super.setAlt(alt);
            }

            public Getsupportedholidays setCallback(String callback) {
                return (Getsupportedholidays)super.setCallback(callback);
            }

            public Getsupportedholidays setFields(String fields) {
                return (Getsupportedholidays)super.setFields(fields);
            }

            public Getsupportedholidays setKey(String key) {
                return (Getsupportedholidays)super.setKey(key);
            }

            public Getsupportedholidays setOauthToken(String oauthToken) {
                return (Getsupportedholidays)super.setOauthToken(oauthToken);
            }

            public Getsupportedholidays setPrettyPrint(Boolean prettyPrint) {
                return (Getsupportedholidays)super.setPrettyPrint(prettyPrint);
            }

            public Getsupportedholidays setQuotaUser(String quotaUser) {
                return (Getsupportedholidays)super.setQuotaUser(quotaUser);
            }

            public Getsupportedholidays setUploadType(String uploadType) {
                return (Getsupportedholidays)super.setUploadType(uploadType);
            }

            public Getsupportedholidays setUploadProtocol(String uploadProtocol) {
                return (Getsupportedholidays)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Getsupportedholidays setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Getsupportedholidays set(String parameterName, Object value) {
                return (Getsupportedholidays)super.set(parameterName, value);
            }
        }

        public class Getsupportedcarriers
        extends ShoppingContentRequest<ShippingsettingsGetSupportedCarriersResponse> {
            private static final String REST_PATH = "{merchantId}/supportedCarriers";
            @Key
            private BigInteger merchantId;

            protected Getsupportedcarriers(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ShippingsettingsGetSupportedCarriersResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Getsupportedcarriers set$Xgafv(String $Xgafv) {
                return (Getsupportedcarriers)super.set$Xgafv($Xgafv);
            }

            public Getsupportedcarriers setAccessToken(String accessToken) {
                return (Getsupportedcarriers)super.setAccessToken(accessToken);
            }

            public Getsupportedcarriers setAlt(String alt) {
                return (Getsupportedcarriers)super.setAlt(alt);
            }

            public Getsupportedcarriers setCallback(String callback) {
                return (Getsupportedcarriers)super.setCallback(callback);
            }

            public Getsupportedcarriers setFields(String fields) {
                return (Getsupportedcarriers)super.setFields(fields);
            }

            public Getsupportedcarriers setKey(String key) {
                return (Getsupportedcarriers)super.setKey(key);
            }

            public Getsupportedcarriers setOauthToken(String oauthToken) {
                return (Getsupportedcarriers)super.setOauthToken(oauthToken);
            }

            public Getsupportedcarriers setPrettyPrint(Boolean prettyPrint) {
                return (Getsupportedcarriers)super.setPrettyPrint(prettyPrint);
            }

            public Getsupportedcarriers setQuotaUser(String quotaUser) {
                return (Getsupportedcarriers)super.setQuotaUser(quotaUser);
            }

            public Getsupportedcarriers setUploadType(String uploadType) {
                return (Getsupportedcarriers)super.setUploadType(uploadType);
            }

            public Getsupportedcarriers setUploadProtocol(String uploadProtocol) {
                return (Getsupportedcarriers)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Getsupportedcarriers setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Getsupportedcarriers set(String parameterName, Object value) {
                return (Getsupportedcarriers)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<ShippingSettings> {
            private static final String REST_PATH = "{merchantId}/shippingsettings/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Get(BigInteger merchantId, BigInteger accountId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ShippingSettings.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Get setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<ShippingsettingsCustomBatchResponse> {
            private static final String REST_PATH = "shippingsettings/batch";

            protected Custombatch(ShippingsettingsCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, ShippingsettingsCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Settlementtransactions {
        public List list(BigInteger merchantId, String settlementId) throws IOException {
            List result = new List(merchantId, settlementId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ShoppingContentRequest<SettlementtransactionsListResponse> {
            private static final String REST_PATH = "{merchantId}/settlementreports/{settlementId}/transactions";
            @Key
            private BigInteger merchantId;
            @Key
            private String settlementId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private java.util.List<String> transactionIds;

            protected List(BigInteger merchantId, String settlementId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, SettlementtransactionsListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.settlementId = (String)Preconditions.checkNotNull((Object)settlementId, (Object)"Required parameter settlementId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getSettlementId() {
                return this.settlementId;
            }

            public List setSettlementId(String settlementId) {
                this.settlementId = settlementId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public java.util.List<String> getTransactionIds() {
                return this.transactionIds;
            }

            public List setTransactionIds(java.util.List<String> transactionIds) {
                this.transactionIds = transactionIds;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Settlementreports {
        public Get get(BigInteger merchantId, String settlementId) throws IOException {
            Get result = new Get(merchantId, settlementId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ShoppingContentRequest<SettlementreportsListResponse> {
            private static final String REST_PATH = "{merchantId}/settlementreports";
            @Key
            private BigInteger merchantId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String transferEndDate;
            @Key
            private String transferStartDate;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, SettlementreportsListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getTransferEndDate() {
                return this.transferEndDate;
            }

            public List setTransferEndDate(String transferEndDate) {
                this.transferEndDate = transferEndDate;
                return this;
            }

            public String getTransferStartDate() {
                return this.transferStartDate;
            }

            public List setTransferStartDate(String transferStartDate) {
                this.transferStartDate = transferStartDate;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<SettlementReport> {
            private static final String REST_PATH = "{merchantId}/settlementreports/{settlementId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String settlementId;

            protected Get(BigInteger merchantId, String settlementId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, SettlementReport.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.settlementId = (String)Preconditions.checkNotNull((Object)settlementId, (Object)"Required parameter settlementId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getSettlementId() {
                return this.settlementId;
            }

            public Get setSettlementId(String settlementId) {
                this.settlementId = settlementId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Returnpolicyonline {
        public Create create(Long merchantId, ReturnPolicyOnline content) throws IOException {
            Create result = new Create(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(Long merchantId, String returnPolicyId) throws IOException {
            Delete result = new Delete(merchantId, returnPolicyId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long merchantId, String returnPolicyId) throws IOException {
            Get result = new Get(merchantId, returnPolicyId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(Long merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(Long merchantId, String returnPolicyId, ReturnPolicyOnline content) throws IOException {
            Patch result = new Patch(merchantId, returnPolicyId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Patch
        extends ShoppingContentRequest<ReturnPolicyOnline> {
            private static final String REST_PATH = "{merchantId}/returnpolicyonline/{returnPolicyId}";
            @Key
            private Long merchantId;
            @Key
            private String returnPolicyId;

            protected Patch(Long merchantId, String returnPolicyId, ReturnPolicyOnline content) {
                super(ShoppingContent.this, "PATCH", REST_PATH, (Object)content, ReturnPolicyOnline.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.returnPolicyId = (String)Preconditions.checkNotNull((Object)returnPolicyId, (Object)"Required parameter returnPolicyId must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Patch setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getReturnPolicyId() {
                return this.returnPolicyId;
            }

            public Patch setReturnPolicyId(String returnPolicyId) {
                this.returnPolicyId = returnPolicyId;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<ListReturnPolicyOnlineResponse> {
            private static final String REST_PATH = "{merchantId}/returnpolicyonline";
            @Key
            private Long merchantId;

            protected List(Long merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ListReturnPolicyOnlineResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<ReturnPolicyOnline> {
            private static final String REST_PATH = "{merchantId}/returnpolicyonline/{returnPolicyId}";
            @Key
            private Long merchantId;
            @Key
            private String returnPolicyId;

            protected Get(Long merchantId, String returnPolicyId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ReturnPolicyOnline.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.returnPolicyId = (String)Preconditions.checkNotNull((Object)returnPolicyId, (Object)"Required parameter returnPolicyId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getReturnPolicyId() {
                return this.returnPolicyId;
            }

            public Get setReturnPolicyId(String returnPolicyId) {
                this.returnPolicyId = returnPolicyId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/returnpolicyonline/{returnPolicyId}";
            @Key
            private Long merchantId;
            @Key
            private String returnPolicyId;

            protected Delete(Long merchantId, String returnPolicyId) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.returnPolicyId = (String)Preconditions.checkNotNull((Object)returnPolicyId, (Object)"Required parameter returnPolicyId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getReturnPolicyId() {
                return this.returnPolicyId;
            }

            public Delete setReturnPolicyId(String returnPolicyId) {
                this.returnPolicyId = returnPolicyId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends ShoppingContentRequest<ReturnPolicyOnline> {
            private static final String REST_PATH = "{merchantId}/returnpolicyonline";
            @Key
            private Long merchantId;

            protected Create(Long merchantId, ReturnPolicyOnline content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, ReturnPolicyOnline.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Create setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Returnpolicy {
        public Custombatch custombatch(ReturnpolicyCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(BigInteger merchantId, String returnPolicyId) throws IOException {
            Delete result = new Delete(merchantId, returnPolicyId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, String returnPolicyId) throws IOException {
            Get result = new Get(merchantId, returnPolicyId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(BigInteger merchantId, ReturnPolicy content) throws IOException {
            Insert result = new Insert(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ShoppingContentRequest<ReturnpolicyListResponse> {
            private static final String REST_PATH = "{merchantId}/returnpolicy";
            @Key
            private BigInteger merchantId;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ReturnpolicyListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ShoppingContentRequest<ReturnPolicy> {
            private static final String REST_PATH = "{merchantId}/returnpolicy";
            @Key
            private BigInteger merchantId;

            protected Insert(BigInteger merchantId, ReturnPolicy content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, ReturnPolicy.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Insert setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<ReturnPolicy> {
            private static final String REST_PATH = "{merchantId}/returnpolicy/{returnPolicyId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String returnPolicyId;

            protected Get(BigInteger merchantId, String returnPolicyId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ReturnPolicy.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.returnPolicyId = (String)Preconditions.checkNotNull((Object)returnPolicyId, (Object)"Required parameter returnPolicyId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getReturnPolicyId() {
                return this.returnPolicyId;
            }

            public Get setReturnPolicyId(String returnPolicyId) {
                this.returnPolicyId = returnPolicyId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/returnpolicy/{returnPolicyId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String returnPolicyId;

            protected Delete(BigInteger merchantId, String returnPolicyId) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.returnPolicyId = (String)Preconditions.checkNotNull((Object)returnPolicyId, (Object)"Required parameter returnPolicyId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getReturnPolicyId() {
                return this.returnPolicyId;
            }

            public Delete setReturnPolicyId(String returnPolicyId) {
                this.returnPolicyId = returnPolicyId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<ReturnpolicyCustomBatchResponse> {
            private static final String REST_PATH = "returnpolicy/batch";

            protected Custombatch(ReturnpolicyCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, ReturnpolicyCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Returnaddress {
        public Custombatch custombatch(ReturnaddressCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(BigInteger merchantId, String returnAddressId) throws IOException {
            Delete result = new Delete(merchantId, returnAddressId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, String returnAddressId) throws IOException {
            Get result = new Get(merchantId, returnAddressId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(BigInteger merchantId, ReturnAddress content) throws IOException {
            Insert result = new Insert(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ShoppingContentRequest<ReturnaddressListResponse> {
            private static final String REST_PATH = "{merchantId}/returnaddress";
            @Key
            private BigInteger merchantId;
            @Key
            private String country;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ReturnaddressListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public List setCountry(String country) {
                this.country = country;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ShoppingContentRequest<ReturnAddress> {
            private static final String REST_PATH = "{merchantId}/returnaddress";
            @Key
            private BigInteger merchantId;

            protected Insert(BigInteger merchantId, ReturnAddress content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, ReturnAddress.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Insert setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<ReturnAddress> {
            private static final String REST_PATH = "{merchantId}/returnaddress/{returnAddressId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String returnAddressId;

            protected Get(BigInteger merchantId, String returnAddressId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ReturnAddress.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.returnAddressId = (String)Preconditions.checkNotNull((Object)returnAddressId, (Object)"Required parameter returnAddressId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getReturnAddressId() {
                return this.returnAddressId;
            }

            public Get setReturnAddressId(String returnAddressId) {
                this.returnAddressId = returnAddressId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/returnaddress/{returnAddressId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String returnAddressId;

            protected Delete(BigInteger merchantId, String returnAddressId) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.returnAddressId = (String)Preconditions.checkNotNull((Object)returnAddressId, (Object)"Required parameter returnAddressId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getReturnAddressId() {
                return this.returnAddressId;
            }

            public Delete setReturnAddressId(String returnAddressId) {
                this.returnAddressId = returnAddressId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<ReturnaddressCustomBatchResponse> {
            private static final String REST_PATH = "returnaddress/batch";

            protected Custombatch(ReturnaddressCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, ReturnaddressCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Reports {
        public Search search(Long merchantId, SearchRequest content) throws IOException {
            Search result = new Search(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Search
        extends ShoppingContentRequest<SearchResponse> {
            private static final String REST_PATH = "{merchantId}/reports/search";
            @Key
            private Long merchantId;

            protected Search(Long merchantId, SearchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, SearchResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Search set$Xgafv(String $Xgafv) {
                return (Search)super.set$Xgafv($Xgafv);
            }

            public Search setAccessToken(String accessToken) {
                return (Search)super.setAccessToken(accessToken);
            }

            public Search setAlt(String alt) {
                return (Search)super.setAlt(alt);
            }

            public Search setCallback(String callback) {
                return (Search)super.setCallback(callback);
            }

            public Search setFields(String fields) {
                return (Search)super.setFields(fields);
            }

            public Search setKey(String key) {
                return (Search)super.setKey(key);
            }

            public Search setOauthToken(String oauthToken) {
                return (Search)super.setOauthToken(oauthToken);
            }

            public Search setPrettyPrint(Boolean prettyPrint) {
                return (Search)super.setPrettyPrint(prettyPrint);
            }

            public Search setQuotaUser(String quotaUser) {
                return (Search)super.setQuotaUser(quotaUser);
            }

            public Search setUploadType(String uploadType) {
                return (Search)super.setUploadType(uploadType);
            }

            public Search setUploadProtocol(String uploadProtocol) {
                return (Search)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Search setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Search set(String parameterName, Object value) {
                return (Search)super.set(parameterName, value);
            }
        }
    }

    public class Regions {
        public Create create(Long merchantId, Region content) throws IOException {
            Create result = new Create(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(Long merchantId, String regionId) throws IOException {
            Delete result = new Delete(merchantId, regionId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long merchantId, String regionId) throws IOException {
            Get result = new Get(merchantId, regionId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(Long merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(Long merchantId, String regionId, Region content) throws IOException {
            Patch result = new Patch(merchantId, regionId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Patch
        extends ShoppingContentRequest<Region> {
            private static final String REST_PATH = "{merchantId}/regions/{regionId}";
            @Key
            private Long merchantId;
            @Key
            private String regionId;
            @Key
            private String updateMask;

            protected Patch(Long merchantId, String regionId, Region content) {
                super(ShoppingContent.this, "PATCH", REST_PATH, (Object)content, Region.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.regionId = (String)Preconditions.checkNotNull((Object)regionId, (Object)"Required parameter regionId must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Patch setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getRegionId() {
                return this.regionId;
            }

            public Patch setRegionId(String regionId) {
                this.regionId = regionId;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<ListRegionsResponse> {
            private static final String REST_PATH = "{merchantId}/regions";
            @Key
            private Long merchantId;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(Long merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ListRegionsResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<Region> {
            private static final String REST_PATH = "{merchantId}/regions/{regionId}";
            @Key
            private Long merchantId;
            @Key
            private String regionId;

            protected Get(Long merchantId, String regionId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, Region.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.regionId = (String)Preconditions.checkNotNull((Object)regionId, (Object)"Required parameter regionId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getRegionId() {
                return this.regionId;
            }

            public Get setRegionId(String regionId) {
                this.regionId = regionId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/regions/{regionId}";
            @Key
            private Long merchantId;
            @Key
            private String regionId;

            protected Delete(Long merchantId, String regionId) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.regionId = (String)Preconditions.checkNotNull((Object)regionId, (Object)"Required parameter regionId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getRegionId() {
                return this.regionId;
            }

            public Delete setRegionId(String regionId) {
                this.regionId = regionId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends ShoppingContentRequest<Region> {
            private static final String REST_PATH = "{merchantId}/regions";
            @Key
            private Long merchantId;
            @Key
            private String regionId;

            protected Create(Long merchantId, Region content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Region.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Create setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getRegionId() {
                return this.regionId;
            }

            public Create setRegionId(String regionId) {
                this.regionId = regionId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Regionalinventory {
        public Custombatch custombatch(RegionalinventoryCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(BigInteger merchantId, String productId, RegionalInventory content) throws IOException {
            Insert result = new Insert(merchantId, productId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Insert
        extends ShoppingContentRequest<RegionalInventory> {
            private static final String REST_PATH = "{merchantId}/products/{productId}/regionalinventory";
            @Key
            private BigInteger merchantId;
            @Key
            private String productId;

            protected Insert(BigInteger merchantId, String productId, RegionalInventory content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, RegionalInventory.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Insert setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Insert setProductId(String productId) {
                this.productId = productId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<RegionalinventoryCustomBatchResponse> {
            private static final String REST_PATH = "regionalinventory/batch";

            protected Custombatch(RegionalinventoryCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, RegionalinventoryCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Recommendations {
        public Generate generate(Long merchantId) throws IOException {
            Generate result = new Generate(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ReportInteraction reportInteraction(Long merchantId, ReportInteractionRequest content) throws IOException {
            ReportInteraction result = new ReportInteraction(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class ReportInteraction
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/recommendations/reportInteraction";
            @Key
            private Long merchantId;

            protected ReportInteraction(Long merchantId, ReportInteractionRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Void.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public ReportInteraction set$Xgafv(String $Xgafv) {
                return (ReportInteraction)super.set$Xgafv($Xgafv);
            }

            public ReportInteraction setAccessToken(String accessToken) {
                return (ReportInteraction)super.setAccessToken(accessToken);
            }

            public ReportInteraction setAlt(String alt) {
                return (ReportInteraction)super.setAlt(alt);
            }

            public ReportInteraction setCallback(String callback) {
                return (ReportInteraction)super.setCallback(callback);
            }

            public ReportInteraction setFields(String fields) {
                return (ReportInteraction)super.setFields(fields);
            }

            public ReportInteraction setKey(String key) {
                return (ReportInteraction)super.setKey(key);
            }

            public ReportInteraction setOauthToken(String oauthToken) {
                return (ReportInteraction)super.setOauthToken(oauthToken);
            }

            public ReportInteraction setPrettyPrint(Boolean prettyPrint) {
                return (ReportInteraction)super.setPrettyPrint(prettyPrint);
            }

            public ReportInteraction setQuotaUser(String quotaUser) {
                return (ReportInteraction)super.setQuotaUser(quotaUser);
            }

            public ReportInteraction setUploadType(String uploadType) {
                return (ReportInteraction)super.setUploadType(uploadType);
            }

            public ReportInteraction setUploadProtocol(String uploadProtocol) {
                return (ReportInteraction)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public ReportInteraction setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public ReportInteraction set(String parameterName, Object value) {
                return (ReportInteraction)super.set(parameterName, value);
            }
        }

        public class Generate
        extends ShoppingContentRequest<GenerateRecommendationsResponse> {
            private static final String REST_PATH = "{merchantId}/recommendations/generate";
            @Key
            private Long merchantId;
            @Key
            private List<String> allowedTag;
            @Key
            private String languageCode;

            protected Generate(Long merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, GenerateRecommendationsResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Generate set$Xgafv(String $Xgafv) {
                return (Generate)super.set$Xgafv($Xgafv);
            }

            public Generate setAccessToken(String accessToken) {
                return (Generate)super.setAccessToken(accessToken);
            }

            public Generate setAlt(String alt) {
                return (Generate)super.setAlt(alt);
            }

            public Generate setCallback(String callback) {
                return (Generate)super.setCallback(callback);
            }

            public Generate setFields(String fields) {
                return (Generate)super.setFields(fields);
            }

            public Generate setKey(String key) {
                return (Generate)super.setKey(key);
            }

            public Generate setOauthToken(String oauthToken) {
                return (Generate)super.setOauthToken(oauthToken);
            }

            public Generate setPrettyPrint(Boolean prettyPrint) {
                return (Generate)super.setPrettyPrint(prettyPrint);
            }

            public Generate setQuotaUser(String quotaUser) {
                return (Generate)super.setQuotaUser(quotaUser);
            }

            public Generate setUploadType(String uploadType) {
                return (Generate)super.setUploadType(uploadType);
            }

            public Generate setUploadProtocol(String uploadProtocol) {
                return (Generate)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Generate setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public List<String> getAllowedTag() {
                return this.allowedTag;
            }

            public Generate setAllowedTag(List<String> allowedTag) {
                this.allowedTag = allowedTag;
                return this;
            }

            public String getLanguageCode() {
                return this.languageCode;
            }

            public Generate setLanguageCode(String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            @Override
            public Generate set(String parameterName, Object value) {
                return (Generate)super.set(parameterName, value);
            }
        }
    }

    public class Quotas {
        public List list(Long merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ShoppingContentRequest<ListMethodQuotasResponse> {
            private static final String REST_PATH = "{merchantId}/quotas";
            @Key
            private Long merchantId;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(Long merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ListMethodQuotasResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Pubsubnotificationsettings {
        public Get get(BigInteger merchantId) throws IOException {
            Get result = new Get(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(BigInteger merchantId, PubsubNotificationSettings content) throws IOException {
            Update result = new Update(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends ShoppingContentRequest<PubsubNotificationSettings> {
            private static final String REST_PATH = "{merchantId}/pubsubnotificationsettings";
            @Key
            private BigInteger merchantId;

            protected Update(BigInteger merchantId, PubsubNotificationSettings content) {
                super(ShoppingContent.this, "PUT", REST_PATH, (Object)content, PubsubNotificationSettings.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Update setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<PubsubNotificationSettings> {
            private static final String REST_PATH = "{merchantId}/pubsubnotificationsettings";
            @Key
            private BigInteger merchantId;

            protected Get(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, PubsubNotificationSettings.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Promotions {
        public Create create(Long merchantId, Promotion content) throws IOException {
            Create result = new Create(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long merchantId, String id) throws IOException {
            Get result = new Get(merchantId, id);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(Long merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ShoppingContentRequest<ListPromotionResponse> {
            private static final String REST_PATH = "{merchantId}/promotions";
            @Key
            private Long merchantId;
            @Key
            private String countryCode;
            @Key
            private String languageCode;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(Long merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ListPromotionResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getCountryCode() {
                return this.countryCode;
            }

            public List setCountryCode(String countryCode) {
                this.countryCode = countryCode;
                return this;
            }

            public String getLanguageCode() {
                return this.languageCode;
            }

            public List setLanguageCode(String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<Promotion> {
            private static final String REST_PATH = "{merchantId}/promotions/{id}";
            @Key
            private Long merchantId;
            @Key
            private String id;

            protected Get(Long merchantId, String id) {
                super(ShoppingContent.this, "GET", REST_PATH, null, Promotion.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String id) {
                this.id = id;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Create
        extends ShoppingContentRequest<Promotion> {
            private static final String REST_PATH = "{merchantId}/promotions";
            @Key
            private Long merchantId;

            protected Create(Long merchantId, Promotion content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Promotion.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Create setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Productstatuses {
        public Custombatch custombatch(ProductstatusesCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, String productId) throws IOException {
            Get result = new Get(merchantId, productId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ShoppingContentRequest<ProductstatusesListResponse> {
            private static final String REST_PATH = "{merchantId}/productstatuses";
            @Key
            private BigInteger merchantId;
            @Key
            private java.util.List<String> destinations;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ProductstatusesListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public java.util.List<String> getDestinations() {
                return this.destinations;
            }

            public List setDestinations(java.util.List<String> destinations) {
                this.destinations = destinations;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<ProductStatus> {
            private static final String REST_PATH = "{merchantId}/productstatuses/{productId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String productId;
            @Key
            private java.util.List<String> destinations;

            protected Get(BigInteger merchantId, String productId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ProductStatus.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Get setProductId(String productId) {
                this.productId = productId;
                return this;
            }

            public java.util.List<String> getDestinations() {
                return this.destinations;
            }

            public Get setDestinations(java.util.List<String> destinations) {
                this.destinations = destinations;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<ProductstatusesCustomBatchResponse> {
            private static final String REST_PATH = "productstatuses/batch";

            protected Custombatch(ProductstatusesCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, ProductstatusesCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Products {
        public Custombatch custombatch(ProductsCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(BigInteger merchantId, String productId) throws IOException {
            Delete result = new Delete(merchantId, productId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, String productId) throws IOException {
            Get result = new Get(merchantId, productId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(BigInteger merchantId, Product content) throws IOException {
            Insert result = new Insert(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(BigInteger merchantId, String productId, Product content) throws IOException {
            Update result = new Update(merchantId, productId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends ShoppingContentRequest<Product> {
            private static final String REST_PATH = "{merchantId}/products/{productId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String productId;
            @Key
            private String updateMask;

            protected Update(BigInteger merchantId, String productId, Product content) {
                super(ShoppingContent.this, "PATCH", REST_PATH, (Object)content, Product.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Update setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Update setProductId(String productId) {
                this.productId = productId;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Update setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<ProductsListResponse> {
            private static final String REST_PATH = "{merchantId}/products";
            @Key
            private BigInteger merchantId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ProductsListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ShoppingContentRequest<Product> {
            private static final String REST_PATH = "{merchantId}/products";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger feedId;

            protected Insert(BigInteger merchantId, Product content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Product.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Insert setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getFeedId() {
                return this.feedId;
            }

            public Insert setFeedId(BigInteger feedId) {
                this.feedId = feedId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<Product> {
            private static final String REST_PATH = "{merchantId}/products/{productId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String productId;

            protected Get(BigInteger merchantId, String productId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, Product.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Get setProductId(String productId) {
                this.productId = productId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/products/{productId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String productId;
            @Key
            private BigInteger feedId;

            protected Delete(BigInteger merchantId, String productId) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Delete setProductId(String productId) {
                this.productId = productId;
                return this;
            }

            public BigInteger getFeedId() {
                return this.feedId;
            }

            public Delete setFeedId(BigInteger feedId) {
                this.feedId = feedId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<ProductsCustomBatchResponse> {
            private static final String REST_PATH = "products/batch";

            protected Custombatch(ProductsCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, ProductsCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Productdeliverytime {
        public Create create(Long merchantId, ProductDeliveryTime content) throws IOException {
            Create result = new Create(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(Long merchantId, String productId) throws IOException {
            Delete result = new Delete(merchantId, productId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long merchantId, String productId) throws IOException {
            Get result = new Get(merchantId, productId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends ShoppingContentRequest<ProductDeliveryTime> {
            private static final String REST_PATH = "{merchantId}/productdeliverytime/{productId}";
            @Key
            private Long merchantId;
            @Key
            private String productId;

            protected Get(Long merchantId, String productId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ProductDeliveryTime.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Get setProductId(String productId) {
                this.productId = productId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/productdeliverytime/{productId}";
            @Key
            private Long merchantId;
            @Key
            private String productId;

            protected Delete(Long merchantId, String productId) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Delete setProductId(String productId) {
                this.productId = productId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends ShoppingContentRequest<ProductDeliveryTime> {
            private static final String REST_PATH = "{merchantId}/productdeliverytime";
            @Key
            private Long merchantId;

            protected Create(Long merchantId, ProductDeliveryTime content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, ProductDeliveryTime.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Create setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Pos {
        public Custombatch custombatch(PosCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(BigInteger merchantId, BigInteger targetMerchantId, String storeCode) throws IOException {
            Delete result = new Delete(merchantId, targetMerchantId, storeCode);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, BigInteger targetMerchantId, String storeCode) throws IOException {
            Get result = new Get(merchantId, targetMerchantId, storeCode);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(BigInteger merchantId, BigInteger targetMerchantId, PosStore content) throws IOException {
            Insert result = new Insert(merchantId, targetMerchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Inventory inventory(BigInteger merchantId, BigInteger targetMerchantId, PosInventoryRequest content) throws IOException {
            Inventory result = new Inventory(merchantId, targetMerchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId, BigInteger targetMerchantId) throws IOException {
            List result = new List(merchantId, targetMerchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Sale sale(BigInteger merchantId, BigInteger targetMerchantId, PosSaleRequest content) throws IOException {
            Sale result = new Sale(merchantId, targetMerchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Sale
        extends ShoppingContentRequest<PosSaleResponse> {
            private static final String REST_PATH = "{merchantId}/pos/{targetMerchantId}/sale";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger targetMerchantId;

            protected Sale(BigInteger merchantId, BigInteger targetMerchantId, PosSaleRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, PosSaleResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.targetMerchantId = (BigInteger)Preconditions.checkNotNull((Object)targetMerchantId, (Object)"Required parameter targetMerchantId must be specified.");
            }

            public Sale set$Xgafv(String $Xgafv) {
                return (Sale)super.set$Xgafv($Xgafv);
            }

            public Sale setAccessToken(String accessToken) {
                return (Sale)super.setAccessToken(accessToken);
            }

            public Sale setAlt(String alt) {
                return (Sale)super.setAlt(alt);
            }

            public Sale setCallback(String callback) {
                return (Sale)super.setCallback(callback);
            }

            public Sale setFields(String fields) {
                return (Sale)super.setFields(fields);
            }

            public Sale setKey(String key) {
                return (Sale)super.setKey(key);
            }

            public Sale setOauthToken(String oauthToken) {
                return (Sale)super.setOauthToken(oauthToken);
            }

            public Sale setPrettyPrint(Boolean prettyPrint) {
                return (Sale)super.setPrettyPrint(prettyPrint);
            }

            public Sale setQuotaUser(String quotaUser) {
                return (Sale)super.setQuotaUser(quotaUser);
            }

            public Sale setUploadType(String uploadType) {
                return (Sale)super.setUploadType(uploadType);
            }

            public Sale setUploadProtocol(String uploadProtocol) {
                return (Sale)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Sale setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getTargetMerchantId() {
                return this.targetMerchantId;
            }

            public Sale setTargetMerchantId(BigInteger targetMerchantId) {
                this.targetMerchantId = targetMerchantId;
                return this;
            }

            @Override
            public Sale set(String parameterName, Object value) {
                return (Sale)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<PosListResponse> {
            private static final String REST_PATH = "{merchantId}/pos/{targetMerchantId}/store";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger targetMerchantId;

            protected List(BigInteger merchantId, BigInteger targetMerchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, PosListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.targetMerchantId = (BigInteger)Preconditions.checkNotNull((Object)targetMerchantId, (Object)"Required parameter targetMerchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getTargetMerchantId() {
                return this.targetMerchantId;
            }

            public List setTargetMerchantId(BigInteger targetMerchantId) {
                this.targetMerchantId = targetMerchantId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Inventory
        extends ShoppingContentRequest<PosInventoryResponse> {
            private static final String REST_PATH = "{merchantId}/pos/{targetMerchantId}/inventory";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger targetMerchantId;

            protected Inventory(BigInteger merchantId, BigInteger targetMerchantId, PosInventoryRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, PosInventoryResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.targetMerchantId = (BigInteger)Preconditions.checkNotNull((Object)targetMerchantId, (Object)"Required parameter targetMerchantId must be specified.");
            }

            public Inventory set$Xgafv(String $Xgafv) {
                return (Inventory)super.set$Xgafv($Xgafv);
            }

            public Inventory setAccessToken(String accessToken) {
                return (Inventory)super.setAccessToken(accessToken);
            }

            public Inventory setAlt(String alt) {
                return (Inventory)super.setAlt(alt);
            }

            public Inventory setCallback(String callback) {
                return (Inventory)super.setCallback(callback);
            }

            public Inventory setFields(String fields) {
                return (Inventory)super.setFields(fields);
            }

            public Inventory setKey(String key) {
                return (Inventory)super.setKey(key);
            }

            public Inventory setOauthToken(String oauthToken) {
                return (Inventory)super.setOauthToken(oauthToken);
            }

            public Inventory setPrettyPrint(Boolean prettyPrint) {
                return (Inventory)super.setPrettyPrint(prettyPrint);
            }

            public Inventory setQuotaUser(String quotaUser) {
                return (Inventory)super.setQuotaUser(quotaUser);
            }

            public Inventory setUploadType(String uploadType) {
                return (Inventory)super.setUploadType(uploadType);
            }

            public Inventory setUploadProtocol(String uploadProtocol) {
                return (Inventory)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Inventory setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getTargetMerchantId() {
                return this.targetMerchantId;
            }

            public Inventory setTargetMerchantId(BigInteger targetMerchantId) {
                this.targetMerchantId = targetMerchantId;
                return this;
            }

            @Override
            public Inventory set(String parameterName, Object value) {
                return (Inventory)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ShoppingContentRequest<PosStore> {
            private static final String REST_PATH = "{merchantId}/pos/{targetMerchantId}/store";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger targetMerchantId;

            protected Insert(BigInteger merchantId, BigInteger targetMerchantId, PosStore content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, PosStore.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.targetMerchantId = (BigInteger)Preconditions.checkNotNull((Object)targetMerchantId, (Object)"Required parameter targetMerchantId must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Insert setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getTargetMerchantId() {
                return this.targetMerchantId;
            }

            public Insert setTargetMerchantId(BigInteger targetMerchantId) {
                this.targetMerchantId = targetMerchantId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<PosStore> {
            private static final String REST_PATH = "{merchantId}/pos/{targetMerchantId}/store/{storeCode}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger targetMerchantId;
            @Key
            private String storeCode;

            protected Get(BigInteger merchantId, BigInteger targetMerchantId, String storeCode) {
                super(ShoppingContent.this, "GET", REST_PATH, null, PosStore.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.targetMerchantId = (BigInteger)Preconditions.checkNotNull((Object)targetMerchantId, (Object)"Required parameter targetMerchantId must be specified.");
                this.storeCode = (String)Preconditions.checkNotNull((Object)storeCode, (Object)"Required parameter storeCode must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getTargetMerchantId() {
                return this.targetMerchantId;
            }

            public Get setTargetMerchantId(BigInteger targetMerchantId) {
                this.targetMerchantId = targetMerchantId;
                return this;
            }

            public String getStoreCode() {
                return this.storeCode;
            }

            public Get setStoreCode(String storeCode) {
                this.storeCode = storeCode;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/pos/{targetMerchantId}/store/{storeCode}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger targetMerchantId;
            @Key
            private String storeCode;

            protected Delete(BigInteger merchantId, BigInteger targetMerchantId, String storeCode) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.targetMerchantId = (BigInteger)Preconditions.checkNotNull((Object)targetMerchantId, (Object)"Required parameter targetMerchantId must be specified.");
                this.storeCode = (String)Preconditions.checkNotNull((Object)storeCode, (Object)"Required parameter storeCode must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getTargetMerchantId() {
                return this.targetMerchantId;
            }

            public Delete setTargetMerchantId(BigInteger targetMerchantId) {
                this.targetMerchantId = targetMerchantId;
                return this;
            }

            public String getStoreCode() {
                return this.storeCode;
            }

            public Delete setStoreCode(String storeCode) {
                this.storeCode = storeCode;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<PosCustomBatchResponse> {
            private static final String REST_PATH = "pos/batch";

            protected Custombatch(PosCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, PosCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Ordertrackingsignals {
        public Create create(Long merchantId, OrderTrackingSignal content) throws IOException {
            Create result = new Create(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Create
        extends ShoppingContentRequest<OrderTrackingSignal> {
            private static final String REST_PATH = "{merchantId}/ordertrackingsignals";
            @Key
            private Long merchantId;

            protected Create(Long merchantId, OrderTrackingSignal content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrderTrackingSignal.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Create setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Merchantsupport {
        public Renderaccountissues renderaccountissues(Long merchantId, RenderAccountIssuesRequestPayload content) throws IOException {
            Renderaccountissues result = new Renderaccountissues(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Renderproductissues renderproductissues(Long merchantId, String productId, RenderProductIssuesRequestPayload content) throws IOException {
            Renderproductissues result = new Renderproductissues(merchantId, productId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Triggeraction triggeraction(Long merchantId, TriggerActionPayload content) throws IOException {
            Triggeraction result = new Triggeraction(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Triggeraction
        extends ShoppingContentRequest<TriggerActionResponse> {
            private static final String REST_PATH = "{merchantId}/merchantsupport/triggeraction";
            @Key
            private Long merchantId;
            @Key
            private String languageCode;

            protected Triggeraction(Long merchantId, TriggerActionPayload content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, TriggerActionResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Triggeraction set$Xgafv(String $Xgafv) {
                return (Triggeraction)super.set$Xgafv($Xgafv);
            }

            public Triggeraction setAccessToken(String accessToken) {
                return (Triggeraction)super.setAccessToken(accessToken);
            }

            public Triggeraction setAlt(String alt) {
                return (Triggeraction)super.setAlt(alt);
            }

            public Triggeraction setCallback(String callback) {
                return (Triggeraction)super.setCallback(callback);
            }

            public Triggeraction setFields(String fields) {
                return (Triggeraction)super.setFields(fields);
            }

            public Triggeraction setKey(String key) {
                return (Triggeraction)super.setKey(key);
            }

            public Triggeraction setOauthToken(String oauthToken) {
                return (Triggeraction)super.setOauthToken(oauthToken);
            }

            public Triggeraction setPrettyPrint(Boolean prettyPrint) {
                return (Triggeraction)super.setPrettyPrint(prettyPrint);
            }

            public Triggeraction setQuotaUser(String quotaUser) {
                return (Triggeraction)super.setQuotaUser(quotaUser);
            }

            public Triggeraction setUploadType(String uploadType) {
                return (Triggeraction)super.setUploadType(uploadType);
            }

            public Triggeraction setUploadProtocol(String uploadProtocol) {
                return (Triggeraction)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Triggeraction setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getLanguageCode() {
                return this.languageCode;
            }

            public Triggeraction setLanguageCode(String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            @Override
            public Triggeraction set(String parameterName, Object value) {
                return (Triggeraction)super.set(parameterName, value);
            }
        }

        public class Renderproductissues
        extends ShoppingContentRequest<RenderProductIssuesResponse> {
            private static final String REST_PATH = "{merchantId}/merchantsupport/renderproductissues/{productId}";
            @Key
            private Long merchantId;
            @Key
            private String productId;
            @Key
            private String languageCode;
            @Key
            private String timeZone;

            protected Renderproductissues(Long merchantId, String productId, RenderProductIssuesRequestPayload content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, RenderProductIssuesResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
            }

            public Renderproductissues set$Xgafv(String $Xgafv) {
                return (Renderproductissues)super.set$Xgafv($Xgafv);
            }

            public Renderproductissues setAccessToken(String accessToken) {
                return (Renderproductissues)super.setAccessToken(accessToken);
            }

            public Renderproductissues setAlt(String alt) {
                return (Renderproductissues)super.setAlt(alt);
            }

            public Renderproductissues setCallback(String callback) {
                return (Renderproductissues)super.setCallback(callback);
            }

            public Renderproductissues setFields(String fields) {
                return (Renderproductissues)super.setFields(fields);
            }

            public Renderproductissues setKey(String key) {
                return (Renderproductissues)super.setKey(key);
            }

            public Renderproductissues setOauthToken(String oauthToken) {
                return (Renderproductissues)super.setOauthToken(oauthToken);
            }

            public Renderproductissues setPrettyPrint(Boolean prettyPrint) {
                return (Renderproductissues)super.setPrettyPrint(prettyPrint);
            }

            public Renderproductissues setQuotaUser(String quotaUser) {
                return (Renderproductissues)super.setQuotaUser(quotaUser);
            }

            public Renderproductissues setUploadType(String uploadType) {
                return (Renderproductissues)super.setUploadType(uploadType);
            }

            public Renderproductissues setUploadProtocol(String uploadProtocol) {
                return (Renderproductissues)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Renderproductissues setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Renderproductissues setProductId(String productId) {
                this.productId = productId;
                return this;
            }

            public String getLanguageCode() {
                return this.languageCode;
            }

            public Renderproductissues setLanguageCode(String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            public String getTimeZone() {
                return this.timeZone;
            }

            public Renderproductissues setTimeZone(String timeZone) {
                this.timeZone = timeZone;
                return this;
            }

            @Override
            public Renderproductissues set(String parameterName, Object value) {
                return (Renderproductissues)super.set(parameterName, value);
            }
        }

        public class Renderaccountissues
        extends ShoppingContentRequest<RenderAccountIssuesResponse> {
            private static final String REST_PATH = "{merchantId}/merchantsupport/renderaccountissues";
            @Key
            private Long merchantId;
            @Key
            private String languageCode;
            @Key
            private String timeZone;

            protected Renderaccountissues(Long merchantId, RenderAccountIssuesRequestPayload content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, RenderAccountIssuesResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Renderaccountissues set$Xgafv(String $Xgafv) {
                return (Renderaccountissues)super.set$Xgafv($Xgafv);
            }

            public Renderaccountissues setAccessToken(String accessToken) {
                return (Renderaccountissues)super.setAccessToken(accessToken);
            }

            public Renderaccountissues setAlt(String alt) {
                return (Renderaccountissues)super.setAlt(alt);
            }

            public Renderaccountissues setCallback(String callback) {
                return (Renderaccountissues)super.setCallback(callback);
            }

            public Renderaccountissues setFields(String fields) {
                return (Renderaccountissues)super.setFields(fields);
            }

            public Renderaccountissues setKey(String key) {
                return (Renderaccountissues)super.setKey(key);
            }

            public Renderaccountissues setOauthToken(String oauthToken) {
                return (Renderaccountissues)super.setOauthToken(oauthToken);
            }

            public Renderaccountissues setPrettyPrint(Boolean prettyPrint) {
                return (Renderaccountissues)super.setPrettyPrint(prettyPrint);
            }

            public Renderaccountissues setQuotaUser(String quotaUser) {
                return (Renderaccountissues)super.setQuotaUser(quotaUser);
            }

            public Renderaccountissues setUploadType(String uploadType) {
                return (Renderaccountissues)super.setUploadType(uploadType);
            }

            public Renderaccountissues setUploadProtocol(String uploadProtocol) {
                return (Renderaccountissues)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Renderaccountissues setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getLanguageCode() {
                return this.languageCode;
            }

            public Renderaccountissues setLanguageCode(String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            public String getTimeZone() {
                return this.timeZone;
            }

            public Renderaccountissues setTimeZone(String timeZone) {
                this.timeZone = timeZone;
                return this;
            }

            @Override
            public Renderaccountissues set(String parameterName, Object value) {
                return (Renderaccountissues)super.set(parameterName, value);
            }
        }
    }

    public class Localinventory {
        public Custombatch custombatch(LocalinventoryCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(BigInteger merchantId, String productId, LocalInventory content) throws IOException {
            Insert result = new Insert(merchantId, productId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Insert
        extends ShoppingContentRequest<LocalInventory> {
            private static final String REST_PATH = "{merchantId}/products/{productId}/localinventory";
            @Key
            private BigInteger merchantId;
            @Key
            private String productId;

            protected Insert(BigInteger merchantId, String productId, LocalInventory content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, LocalInventory.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Insert setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Insert setProductId(String productId) {
                this.productId = productId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<LocalinventoryCustomBatchResponse> {
            private static final String REST_PATH = "localinventory/batch";

            protected Custombatch(LocalinventoryCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, LocalinventoryCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Liasettings {
        public Custombatch custombatch(LiasettingsCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, BigInteger accountId) throws IOException {
            Get result = new Get(merchantId, accountId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Getaccessiblegmbaccounts getaccessiblegmbaccounts(BigInteger merchantId, BigInteger accountId) throws IOException {
            Getaccessiblegmbaccounts result = new Getaccessiblegmbaccounts(merchantId, accountId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Listposdataproviders listposdataproviders() throws IOException {
            Listposdataproviders result = new Listposdataproviders();
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Requestgmbaccess requestgmbaccess(BigInteger merchantId, BigInteger accountId, String gmbEmail) throws IOException {
            Requestgmbaccess result = new Requestgmbaccess(merchantId, accountId, gmbEmail);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Requestinventoryverification requestinventoryverification(BigInteger merchantId, BigInteger accountId, String country) throws IOException {
            Requestinventoryverification result = new Requestinventoryverification(merchantId, accountId, country);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Setinventoryverificationcontact setinventoryverificationcontact(BigInteger merchantId, BigInteger accountId, String country, String language, String contactName, String contactEmail) throws IOException {
            Setinventoryverificationcontact result = new Setinventoryverificationcontact(merchantId, accountId, country, language, contactName, contactEmail);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Setomnichannelexperience setomnichannelexperience(BigInteger merchantId, BigInteger accountId) throws IOException {
            Setomnichannelexperience result = new Setomnichannelexperience(merchantId, accountId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Setposdataprovider setposdataprovider(BigInteger merchantId, BigInteger accountId, String country) throws IOException {
            Setposdataprovider result = new Setposdataprovider(merchantId, accountId, country);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(BigInteger merchantId, BigInteger accountId, LiaSettings content) throws IOException {
            Update result = new Update(merchantId, accountId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends ShoppingContentRequest<LiaSettings> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Update(BigInteger merchantId, BigInteger accountId, LiaSettings content) {
                super(ShoppingContent.this, "PUT", REST_PATH, (Object)content, LiaSettings.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Update setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Update setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Setposdataprovider
        extends ShoppingContentRequest<LiasettingsSetPosDataProviderResponse> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}/setposdataprovider";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private String country;
            @Key
            private BigInteger posDataProviderId;
            @Key
            private String posExternalAccountId;

            protected Setposdataprovider(BigInteger merchantId, BigInteger accountId, String country) {
                super(ShoppingContent.this, "POST", REST_PATH, null, LiasettingsSetPosDataProviderResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                this.country = (String)Preconditions.checkNotNull((Object)country, (Object)"Required parameter country must be specified.");
            }

            public Setposdataprovider set$Xgafv(String $Xgafv) {
                return (Setposdataprovider)super.set$Xgafv($Xgafv);
            }

            public Setposdataprovider setAccessToken(String accessToken) {
                return (Setposdataprovider)super.setAccessToken(accessToken);
            }

            public Setposdataprovider setAlt(String alt) {
                return (Setposdataprovider)super.setAlt(alt);
            }

            public Setposdataprovider setCallback(String callback) {
                return (Setposdataprovider)super.setCallback(callback);
            }

            public Setposdataprovider setFields(String fields) {
                return (Setposdataprovider)super.setFields(fields);
            }

            public Setposdataprovider setKey(String key) {
                return (Setposdataprovider)super.setKey(key);
            }

            public Setposdataprovider setOauthToken(String oauthToken) {
                return (Setposdataprovider)super.setOauthToken(oauthToken);
            }

            public Setposdataprovider setPrettyPrint(Boolean prettyPrint) {
                return (Setposdataprovider)super.setPrettyPrint(prettyPrint);
            }

            public Setposdataprovider setQuotaUser(String quotaUser) {
                return (Setposdataprovider)super.setQuotaUser(quotaUser);
            }

            public Setposdataprovider setUploadType(String uploadType) {
                return (Setposdataprovider)super.setUploadType(uploadType);
            }

            public Setposdataprovider setUploadProtocol(String uploadProtocol) {
                return (Setposdataprovider)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Setposdataprovider setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Setposdataprovider setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public Setposdataprovider setCountry(String country) {
                this.country = country;
                return this;
            }

            public BigInteger getPosDataProviderId() {
                return this.posDataProviderId;
            }

            public Setposdataprovider setPosDataProviderId(BigInteger posDataProviderId) {
                this.posDataProviderId = posDataProviderId;
                return this;
            }

            public String getPosExternalAccountId() {
                return this.posExternalAccountId;
            }

            public Setposdataprovider setPosExternalAccountId(String posExternalAccountId) {
                this.posExternalAccountId = posExternalAccountId;
                return this;
            }

            @Override
            public Setposdataprovider set(String parameterName, Object value) {
                return (Setposdataprovider)super.set(parameterName, value);
            }
        }

        public class Setomnichannelexperience
        extends ShoppingContentRequest<LiaOmnichannelExperience> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}/setomnichannelexperience";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private String country;
            @Key
            private String lsfType;
            @Key
            private java.util.List<String> pickupTypes;

            protected Setomnichannelexperience(BigInteger merchantId, BigInteger accountId) {
                super(ShoppingContent.this, "POST", REST_PATH, null, LiaOmnichannelExperience.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public Setomnichannelexperience set$Xgafv(String $Xgafv) {
                return (Setomnichannelexperience)super.set$Xgafv($Xgafv);
            }

            public Setomnichannelexperience setAccessToken(String accessToken) {
                return (Setomnichannelexperience)super.setAccessToken(accessToken);
            }

            public Setomnichannelexperience setAlt(String alt) {
                return (Setomnichannelexperience)super.setAlt(alt);
            }

            public Setomnichannelexperience setCallback(String callback) {
                return (Setomnichannelexperience)super.setCallback(callback);
            }

            public Setomnichannelexperience setFields(String fields) {
                return (Setomnichannelexperience)super.setFields(fields);
            }

            public Setomnichannelexperience setKey(String key) {
                return (Setomnichannelexperience)super.setKey(key);
            }

            public Setomnichannelexperience setOauthToken(String oauthToken) {
                return (Setomnichannelexperience)super.setOauthToken(oauthToken);
            }

            public Setomnichannelexperience setPrettyPrint(Boolean prettyPrint) {
                return (Setomnichannelexperience)super.setPrettyPrint(prettyPrint);
            }

            public Setomnichannelexperience setQuotaUser(String quotaUser) {
                return (Setomnichannelexperience)super.setQuotaUser(quotaUser);
            }

            public Setomnichannelexperience setUploadType(String uploadType) {
                return (Setomnichannelexperience)super.setUploadType(uploadType);
            }

            public Setomnichannelexperience setUploadProtocol(String uploadProtocol) {
                return (Setomnichannelexperience)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Setomnichannelexperience setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Setomnichannelexperience setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public Setomnichannelexperience setCountry(String country) {
                this.country = country;
                return this;
            }

            public String getLsfType() {
                return this.lsfType;
            }

            public Setomnichannelexperience setLsfType(String lsfType) {
                this.lsfType = lsfType;
                return this;
            }

            public java.util.List<String> getPickupTypes() {
                return this.pickupTypes;
            }

            public Setomnichannelexperience setPickupTypes(java.util.List<String> pickupTypes) {
                this.pickupTypes = pickupTypes;
                return this;
            }

            @Override
            public Setomnichannelexperience set(String parameterName, Object value) {
                return (Setomnichannelexperience)super.set(parameterName, value);
            }
        }

        public class Setinventoryverificationcontact
        extends ShoppingContentRequest<LiasettingsSetInventoryVerificationContactResponse> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}/setinventoryverificationcontact";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private String country;
            @Key
            private String language;
            @Key
            private String contactName;
            @Key
            private String contactEmail;

            protected Setinventoryverificationcontact(BigInteger merchantId, BigInteger accountId, String country, String language, String contactName, String contactEmail) {
                super(ShoppingContent.this, "POST", REST_PATH, null, LiasettingsSetInventoryVerificationContactResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                this.country = (String)Preconditions.checkNotNull((Object)country, (Object)"Required parameter country must be specified.");
                this.language = (String)Preconditions.checkNotNull((Object)language, (Object)"Required parameter language must be specified.");
                this.contactName = (String)Preconditions.checkNotNull((Object)contactName, (Object)"Required parameter contactName must be specified.");
                this.contactEmail = (String)Preconditions.checkNotNull((Object)contactEmail, (Object)"Required parameter contactEmail must be specified.");
            }

            public Setinventoryverificationcontact set$Xgafv(String $Xgafv) {
                return (Setinventoryverificationcontact)super.set$Xgafv($Xgafv);
            }

            public Setinventoryverificationcontact setAccessToken(String accessToken) {
                return (Setinventoryverificationcontact)super.setAccessToken(accessToken);
            }

            public Setinventoryverificationcontact setAlt(String alt) {
                return (Setinventoryverificationcontact)super.setAlt(alt);
            }

            public Setinventoryverificationcontact setCallback(String callback) {
                return (Setinventoryverificationcontact)super.setCallback(callback);
            }

            public Setinventoryverificationcontact setFields(String fields) {
                return (Setinventoryverificationcontact)super.setFields(fields);
            }

            public Setinventoryverificationcontact setKey(String key) {
                return (Setinventoryverificationcontact)super.setKey(key);
            }

            public Setinventoryverificationcontact setOauthToken(String oauthToken) {
                return (Setinventoryverificationcontact)super.setOauthToken(oauthToken);
            }

            public Setinventoryverificationcontact setPrettyPrint(Boolean prettyPrint) {
                return (Setinventoryverificationcontact)super.setPrettyPrint(prettyPrint);
            }

            public Setinventoryverificationcontact setQuotaUser(String quotaUser) {
                return (Setinventoryverificationcontact)super.setQuotaUser(quotaUser);
            }

            public Setinventoryverificationcontact setUploadType(String uploadType) {
                return (Setinventoryverificationcontact)super.setUploadType(uploadType);
            }

            public Setinventoryverificationcontact setUploadProtocol(String uploadProtocol) {
                return (Setinventoryverificationcontact)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Setinventoryverificationcontact setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Setinventoryverificationcontact setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public Setinventoryverificationcontact setCountry(String country) {
                this.country = country;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Setinventoryverificationcontact setLanguage(String language) {
                this.language = language;
                return this;
            }

            public String getContactName() {
                return this.contactName;
            }

            public Setinventoryverificationcontact setContactName(String contactName) {
                this.contactName = contactName;
                return this;
            }

            public String getContactEmail() {
                return this.contactEmail;
            }

            public Setinventoryverificationcontact setContactEmail(String contactEmail) {
                this.contactEmail = contactEmail;
                return this;
            }

            @Override
            public Setinventoryverificationcontact set(String parameterName, Object value) {
                return (Setinventoryverificationcontact)super.set(parameterName, value);
            }
        }

        public class Requestinventoryverification
        extends ShoppingContentRequest<LiasettingsRequestInventoryVerificationResponse> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}/requestinventoryverification/{country}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private String country;

            protected Requestinventoryverification(BigInteger merchantId, BigInteger accountId, String country) {
                super(ShoppingContent.this, "POST", REST_PATH, null, LiasettingsRequestInventoryVerificationResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                this.country = (String)Preconditions.checkNotNull((Object)country, (Object)"Required parameter country must be specified.");
            }

            public Requestinventoryverification set$Xgafv(String $Xgafv) {
                return (Requestinventoryverification)super.set$Xgafv($Xgafv);
            }

            public Requestinventoryverification setAccessToken(String accessToken) {
                return (Requestinventoryverification)super.setAccessToken(accessToken);
            }

            public Requestinventoryverification setAlt(String alt) {
                return (Requestinventoryverification)super.setAlt(alt);
            }

            public Requestinventoryverification setCallback(String callback) {
                return (Requestinventoryverification)super.setCallback(callback);
            }

            public Requestinventoryverification setFields(String fields) {
                return (Requestinventoryverification)super.setFields(fields);
            }

            public Requestinventoryverification setKey(String key) {
                return (Requestinventoryverification)super.setKey(key);
            }

            public Requestinventoryverification setOauthToken(String oauthToken) {
                return (Requestinventoryverification)super.setOauthToken(oauthToken);
            }

            public Requestinventoryverification setPrettyPrint(Boolean prettyPrint) {
                return (Requestinventoryverification)super.setPrettyPrint(prettyPrint);
            }

            public Requestinventoryverification setQuotaUser(String quotaUser) {
                return (Requestinventoryverification)super.setQuotaUser(quotaUser);
            }

            public Requestinventoryverification setUploadType(String uploadType) {
                return (Requestinventoryverification)super.setUploadType(uploadType);
            }

            public Requestinventoryverification setUploadProtocol(String uploadProtocol) {
                return (Requestinventoryverification)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Requestinventoryverification setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Requestinventoryverification setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public Requestinventoryverification setCountry(String country) {
                this.country = country;
                return this;
            }

            @Override
            public Requestinventoryverification set(String parameterName, Object value) {
                return (Requestinventoryverification)super.set(parameterName, value);
            }
        }

        public class Requestgmbaccess
        extends ShoppingContentRequest<LiasettingsRequestGmbAccessResponse> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}/requestgmbaccess";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private String gmbEmail;

            protected Requestgmbaccess(BigInteger merchantId, BigInteger accountId, String gmbEmail) {
                super(ShoppingContent.this, "POST", REST_PATH, null, LiasettingsRequestGmbAccessResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                this.gmbEmail = (String)Preconditions.checkNotNull((Object)gmbEmail, (Object)"Required parameter gmbEmail must be specified.");
            }

            public Requestgmbaccess set$Xgafv(String $Xgafv) {
                return (Requestgmbaccess)super.set$Xgafv($Xgafv);
            }

            public Requestgmbaccess setAccessToken(String accessToken) {
                return (Requestgmbaccess)super.setAccessToken(accessToken);
            }

            public Requestgmbaccess setAlt(String alt) {
                return (Requestgmbaccess)super.setAlt(alt);
            }

            public Requestgmbaccess setCallback(String callback) {
                return (Requestgmbaccess)super.setCallback(callback);
            }

            public Requestgmbaccess setFields(String fields) {
                return (Requestgmbaccess)super.setFields(fields);
            }

            public Requestgmbaccess setKey(String key) {
                return (Requestgmbaccess)super.setKey(key);
            }

            public Requestgmbaccess setOauthToken(String oauthToken) {
                return (Requestgmbaccess)super.setOauthToken(oauthToken);
            }

            public Requestgmbaccess setPrettyPrint(Boolean prettyPrint) {
                return (Requestgmbaccess)super.setPrettyPrint(prettyPrint);
            }

            public Requestgmbaccess setQuotaUser(String quotaUser) {
                return (Requestgmbaccess)super.setQuotaUser(quotaUser);
            }

            public Requestgmbaccess setUploadType(String uploadType) {
                return (Requestgmbaccess)super.setUploadType(uploadType);
            }

            public Requestgmbaccess setUploadProtocol(String uploadProtocol) {
                return (Requestgmbaccess)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Requestgmbaccess setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Requestgmbaccess setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            public String getGmbEmail() {
                return this.gmbEmail;
            }

            public Requestgmbaccess setGmbEmail(String gmbEmail) {
                this.gmbEmail = gmbEmail;
                return this;
            }

            @Override
            public Requestgmbaccess set(String parameterName, Object value) {
                return (Requestgmbaccess)super.set(parameterName, value);
            }
        }

        public class Listposdataproviders
        extends ShoppingContentRequest<LiasettingsListPosDataProvidersResponse> {
            private static final String REST_PATH = "liasettings/posdataproviders";

            protected Listposdataproviders() {
                super(ShoppingContent.this, "GET", REST_PATH, null, LiasettingsListPosDataProvidersResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Listposdataproviders set$Xgafv(String $Xgafv) {
                return (Listposdataproviders)super.set$Xgafv($Xgafv);
            }

            public Listposdataproviders setAccessToken(String accessToken) {
                return (Listposdataproviders)super.setAccessToken(accessToken);
            }

            public Listposdataproviders setAlt(String alt) {
                return (Listposdataproviders)super.setAlt(alt);
            }

            public Listposdataproviders setCallback(String callback) {
                return (Listposdataproviders)super.setCallback(callback);
            }

            public Listposdataproviders setFields(String fields) {
                return (Listposdataproviders)super.setFields(fields);
            }

            public Listposdataproviders setKey(String key) {
                return (Listposdataproviders)super.setKey(key);
            }

            public Listposdataproviders setOauthToken(String oauthToken) {
                return (Listposdataproviders)super.setOauthToken(oauthToken);
            }

            public Listposdataproviders setPrettyPrint(Boolean prettyPrint) {
                return (Listposdataproviders)super.setPrettyPrint(prettyPrint);
            }

            public Listposdataproviders setQuotaUser(String quotaUser) {
                return (Listposdataproviders)super.setQuotaUser(quotaUser);
            }

            public Listposdataproviders setUploadType(String uploadType) {
                return (Listposdataproviders)super.setUploadType(uploadType);
            }

            public Listposdataproviders setUploadProtocol(String uploadProtocol) {
                return (Listposdataproviders)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Listposdataproviders set(String parameterName, Object value) {
                return (Listposdataproviders)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<LiasettingsListResponse> {
            private static final String REST_PATH = "{merchantId}/liasettings";
            @Key
            private BigInteger merchantId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, LiasettingsListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Getaccessiblegmbaccounts
        extends ShoppingContentRequest<LiasettingsGetAccessibleGmbAccountsResponse> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}/accessiblegmbaccounts";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Getaccessiblegmbaccounts(BigInteger merchantId, BigInteger accountId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, LiasettingsGetAccessibleGmbAccountsResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Getaccessiblegmbaccounts set$Xgafv(String $Xgafv) {
                return (Getaccessiblegmbaccounts)super.set$Xgafv($Xgafv);
            }

            public Getaccessiblegmbaccounts setAccessToken(String accessToken) {
                return (Getaccessiblegmbaccounts)super.setAccessToken(accessToken);
            }

            public Getaccessiblegmbaccounts setAlt(String alt) {
                return (Getaccessiblegmbaccounts)super.setAlt(alt);
            }

            public Getaccessiblegmbaccounts setCallback(String callback) {
                return (Getaccessiblegmbaccounts)super.setCallback(callback);
            }

            public Getaccessiblegmbaccounts setFields(String fields) {
                return (Getaccessiblegmbaccounts)super.setFields(fields);
            }

            public Getaccessiblegmbaccounts setKey(String key) {
                return (Getaccessiblegmbaccounts)super.setKey(key);
            }

            public Getaccessiblegmbaccounts setOauthToken(String oauthToken) {
                return (Getaccessiblegmbaccounts)super.setOauthToken(oauthToken);
            }

            public Getaccessiblegmbaccounts setPrettyPrint(Boolean prettyPrint) {
                return (Getaccessiblegmbaccounts)super.setPrettyPrint(prettyPrint);
            }

            public Getaccessiblegmbaccounts setQuotaUser(String quotaUser) {
                return (Getaccessiblegmbaccounts)super.setQuotaUser(quotaUser);
            }

            public Getaccessiblegmbaccounts setUploadType(String uploadType) {
                return (Getaccessiblegmbaccounts)super.setUploadType(uploadType);
            }

            public Getaccessiblegmbaccounts setUploadProtocol(String uploadProtocol) {
                return (Getaccessiblegmbaccounts)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Getaccessiblegmbaccounts setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Getaccessiblegmbaccounts setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Getaccessiblegmbaccounts set(String parameterName, Object value) {
                return (Getaccessiblegmbaccounts)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<LiaSettings> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Get(BigInteger merchantId, BigInteger accountId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, LiaSettings.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Get setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<LiasettingsCustomBatchResponse> {
            private static final String REST_PATH = "liasettings/batch";

            protected Custombatch(LiasettingsCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, LiasettingsCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Freelistingsprogram {
        public Get get(Long merchantId) throws IOException {
            Get result = new Get(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Requestreview requestreview(Long merchantId, RequestReviewFreeListingsRequest content) throws IOException {
            Requestreview result = new Requestreview(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Checkoutsettings checkoutsettings() {
            return new Checkoutsettings();
        }

        public class Checkoutsettings {
            public Delete delete(Long merchantId) throws IOException {
                Delete result = new Delete(merchantId);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(Long merchantId) throws IOException {
                Get result = new Get(merchantId);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(Long merchantId, InsertCheckoutSettingsRequest content) throws IOException {
                Insert result = new Insert(merchantId, content);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Insert
            extends ShoppingContentRequest<CheckoutSettings> {
                private static final String REST_PATH = "{merchantId}/freelistingsprogram/checkoutsettings";
                @Key
                private Long merchantId;

                protected Insert(Long merchantId, InsertCheckoutSettingsRequest content) {
                    super(ShoppingContent.this, "POST", REST_PATH, (Object)content, CheckoutSettings.class);
                    this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                }

                public Insert set$Xgafv(String $Xgafv) {
                    return (Insert)super.set$Xgafv($Xgafv);
                }

                public Insert setAccessToken(String accessToken) {
                    return (Insert)super.setAccessToken(accessToken);
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setCallback(String callback) {
                    return (Insert)super.setCallback(callback);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUploadType(String uploadType) {
                    return (Insert)super.setUploadType(uploadType);
                }

                public Insert setUploadProtocol(String uploadProtocol) {
                    return (Insert)super.setUploadProtocol(uploadProtocol);
                }

                public Long getMerchantId() {
                    return this.merchantId;
                }

                public Insert setMerchantId(Long merchantId) {
                    this.merchantId = merchantId;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class Get
            extends ShoppingContentRequest<CheckoutSettings> {
                private static final String REST_PATH = "{merchantId}/freelistingsprogram/checkoutsettings";
                @Key
                private Long merchantId;

                protected Get(Long merchantId) {
                    super(ShoppingContent.this, "GET", REST_PATH, null, CheckoutSettings.class);
                    this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public Long getMerchantId() {
                    return this.merchantId;
                }

                public Get setMerchantId(Long merchantId) {
                    this.merchantId = merchantId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends ShoppingContentRequest<Void> {
                private static final String REST_PATH = "{merchantId}/freelistingsprogram/checkoutsettings";
                @Key
                private Long merchantId;

                protected Delete(Long merchantId) {
                    super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                    this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public Long getMerchantId() {
                    return this.merchantId;
                }

                public Delete setMerchantId(Long merchantId) {
                    this.merchantId = merchantId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Requestreview
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/freelistingsprogram/requestreview";
            @Key
            private Long merchantId;

            protected Requestreview(Long merchantId, RequestReviewFreeListingsRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Void.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Requestreview set$Xgafv(String $Xgafv) {
                return (Requestreview)super.set$Xgafv($Xgafv);
            }

            public Requestreview setAccessToken(String accessToken) {
                return (Requestreview)super.setAccessToken(accessToken);
            }

            public Requestreview setAlt(String alt) {
                return (Requestreview)super.setAlt(alt);
            }

            public Requestreview setCallback(String callback) {
                return (Requestreview)super.setCallback(callback);
            }

            public Requestreview setFields(String fields) {
                return (Requestreview)super.setFields(fields);
            }

            public Requestreview setKey(String key) {
                return (Requestreview)super.setKey(key);
            }

            public Requestreview setOauthToken(String oauthToken) {
                return (Requestreview)super.setOauthToken(oauthToken);
            }

            public Requestreview setPrettyPrint(Boolean prettyPrint) {
                return (Requestreview)super.setPrettyPrint(prettyPrint);
            }

            public Requestreview setQuotaUser(String quotaUser) {
                return (Requestreview)super.setQuotaUser(quotaUser);
            }

            public Requestreview setUploadType(String uploadType) {
                return (Requestreview)super.setUploadType(uploadType);
            }

            public Requestreview setUploadProtocol(String uploadProtocol) {
                return (Requestreview)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Requestreview setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Requestreview set(String parameterName, Object value) {
                return (Requestreview)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<FreeListingsProgramStatus> {
            private static final String REST_PATH = "{merchantId}/freelistingsprogram";
            @Key
            private Long merchantId;

            protected Get(Long merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, FreeListingsProgramStatus.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Datafeedstatuses {
        public Custombatch custombatch(DatafeedstatusesCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, BigInteger datafeedId) throws IOException {
            Get result = new Get(merchantId, datafeedId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ShoppingContentRequest<DatafeedstatusesListResponse> {
            private static final String REST_PATH = "{merchantId}/datafeedstatuses";
            @Key
            private BigInteger merchantId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, DatafeedstatusesListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<DatafeedStatus> {
            private static final String REST_PATH = "{merchantId}/datafeedstatuses/{datafeedId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger datafeedId;
            @Key
            private String country;
            @Key
            private String feedLabel;
            @Key
            private String language;

            protected Get(BigInteger merchantId, BigInteger datafeedId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, DatafeedStatus.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.datafeedId = (BigInteger)Preconditions.checkNotNull((Object)datafeedId, (Object)"Required parameter datafeedId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getDatafeedId() {
                return this.datafeedId;
            }

            public Get setDatafeedId(BigInteger datafeedId) {
                this.datafeedId = datafeedId;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public Get setCountry(String country) {
                this.country = country;
                return this;
            }

            public String getFeedLabel() {
                return this.feedLabel;
            }

            public Get setFeedLabel(String feedLabel) {
                this.feedLabel = feedLabel;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Get setLanguage(String language) {
                this.language = language;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<DatafeedstatusesCustomBatchResponse> {
            private static final String REST_PATH = "datafeedstatuses/batch";

            protected Custombatch(DatafeedstatusesCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, DatafeedstatusesCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Datafeeds {
        public Custombatch custombatch(DatafeedsCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(BigInteger merchantId, BigInteger datafeedId) throws IOException {
            Delete result = new Delete(merchantId, datafeedId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Fetchnow fetchnow(BigInteger merchantId, BigInteger datafeedId) throws IOException {
            Fetchnow result = new Fetchnow(merchantId, datafeedId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, BigInteger datafeedId) throws IOException {
            Get result = new Get(merchantId, datafeedId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(BigInteger merchantId, Datafeed content) throws IOException {
            Insert result = new Insert(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(BigInteger merchantId, BigInteger datafeedId, Datafeed content) throws IOException {
            Update result = new Update(merchantId, datafeedId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends ShoppingContentRequest<Datafeed> {
            private static final String REST_PATH = "{merchantId}/datafeeds/{datafeedId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger datafeedId;

            protected Update(BigInteger merchantId, BigInteger datafeedId, Datafeed content) {
                super(ShoppingContent.this, "PUT", REST_PATH, (Object)content, Datafeed.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.datafeedId = (BigInteger)Preconditions.checkNotNull((Object)datafeedId, (Object)"Required parameter datafeedId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Update setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getDatafeedId() {
                return this.datafeedId;
            }

            public Update setDatafeedId(BigInteger datafeedId) {
                this.datafeedId = datafeedId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<DatafeedsListResponse> {
            private static final String REST_PATH = "{merchantId}/datafeeds";
            @Key
            private BigInteger merchantId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, DatafeedsListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ShoppingContentRequest<Datafeed> {
            private static final String REST_PATH = "{merchantId}/datafeeds";
            @Key
            private BigInteger merchantId;

            protected Insert(BigInteger merchantId, Datafeed content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Datafeed.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Insert setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<Datafeed> {
            private static final String REST_PATH = "{merchantId}/datafeeds/{datafeedId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger datafeedId;

            protected Get(BigInteger merchantId, BigInteger datafeedId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, Datafeed.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.datafeedId = (BigInteger)Preconditions.checkNotNull((Object)datafeedId, (Object)"Required parameter datafeedId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getDatafeedId() {
                return this.datafeedId;
            }

            public Get setDatafeedId(BigInteger datafeedId) {
                this.datafeedId = datafeedId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Fetchnow
        extends ShoppingContentRequest<DatafeedsFetchNowResponse> {
            private static final String REST_PATH = "{merchantId}/datafeeds/{datafeedId}/fetchNow";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger datafeedId;

            protected Fetchnow(BigInteger merchantId, BigInteger datafeedId) {
                super(ShoppingContent.this, "POST", REST_PATH, null, DatafeedsFetchNowResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.datafeedId = (BigInteger)Preconditions.checkNotNull((Object)datafeedId, (Object)"Required parameter datafeedId must be specified.");
            }

            public Fetchnow set$Xgafv(String $Xgafv) {
                return (Fetchnow)super.set$Xgafv($Xgafv);
            }

            public Fetchnow setAccessToken(String accessToken) {
                return (Fetchnow)super.setAccessToken(accessToken);
            }

            public Fetchnow setAlt(String alt) {
                return (Fetchnow)super.setAlt(alt);
            }

            public Fetchnow setCallback(String callback) {
                return (Fetchnow)super.setCallback(callback);
            }

            public Fetchnow setFields(String fields) {
                return (Fetchnow)super.setFields(fields);
            }

            public Fetchnow setKey(String key) {
                return (Fetchnow)super.setKey(key);
            }

            public Fetchnow setOauthToken(String oauthToken) {
                return (Fetchnow)super.setOauthToken(oauthToken);
            }

            public Fetchnow setPrettyPrint(Boolean prettyPrint) {
                return (Fetchnow)super.setPrettyPrint(prettyPrint);
            }

            public Fetchnow setQuotaUser(String quotaUser) {
                return (Fetchnow)super.setQuotaUser(quotaUser);
            }

            public Fetchnow setUploadType(String uploadType) {
                return (Fetchnow)super.setUploadType(uploadType);
            }

            public Fetchnow setUploadProtocol(String uploadProtocol) {
                return (Fetchnow)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Fetchnow setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getDatafeedId() {
                return this.datafeedId;
            }

            public Fetchnow setDatafeedId(BigInteger datafeedId) {
                this.datafeedId = datafeedId;
                return this;
            }

            @Override
            public Fetchnow set(String parameterName, Object value) {
                return (Fetchnow)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/datafeeds/{datafeedId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger datafeedId;

            protected Delete(BigInteger merchantId, BigInteger datafeedId) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.datafeedId = (BigInteger)Preconditions.checkNotNull((Object)datafeedId, (Object)"Required parameter datafeedId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getDatafeedId() {
                return this.datafeedId;
            }

            public Delete setDatafeedId(BigInteger datafeedId) {
                this.datafeedId = datafeedId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<DatafeedsCustomBatchResponse> {
            private static final String REST_PATH = "datafeeds/batch";

            protected Custombatch(DatafeedsCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, DatafeedsCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Csses {
        public Get get(Long cssGroupId, Long cssDomainId) throws IOException {
            Get result = new Get(cssGroupId, cssDomainId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(Long cssGroupId) throws IOException {
            List result = new List(cssGroupId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Updatelabels updatelabels(Long cssGroupId, Long cssDomainId, LabelIds content) throws IOException {
            Updatelabels result = new Updatelabels(cssGroupId, cssDomainId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Updatelabels
        extends ShoppingContentRequest<Css> {
            private static final String REST_PATH = "{cssGroupId}/csses/{cssDomainId}/updatelabels";
            @Key
            private Long cssGroupId;
            @Key
            private Long cssDomainId;

            protected Updatelabels(Long cssGroupId, Long cssDomainId, LabelIds content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Css.class);
                this.cssGroupId = (Long)Preconditions.checkNotNull((Object)cssGroupId, (Object)"Required parameter cssGroupId must be specified.");
                this.cssDomainId = (Long)Preconditions.checkNotNull((Object)cssDomainId, (Object)"Required parameter cssDomainId must be specified.");
            }

            public Updatelabels set$Xgafv(String $Xgafv) {
                return (Updatelabels)super.set$Xgafv($Xgafv);
            }

            public Updatelabels setAccessToken(String accessToken) {
                return (Updatelabels)super.setAccessToken(accessToken);
            }

            public Updatelabels setAlt(String alt) {
                return (Updatelabels)super.setAlt(alt);
            }

            public Updatelabels setCallback(String callback) {
                return (Updatelabels)super.setCallback(callback);
            }

            public Updatelabels setFields(String fields) {
                return (Updatelabels)super.setFields(fields);
            }

            public Updatelabels setKey(String key) {
                return (Updatelabels)super.setKey(key);
            }

            public Updatelabels setOauthToken(String oauthToken) {
                return (Updatelabels)super.setOauthToken(oauthToken);
            }

            public Updatelabels setPrettyPrint(Boolean prettyPrint) {
                return (Updatelabels)super.setPrettyPrint(prettyPrint);
            }

            public Updatelabels setQuotaUser(String quotaUser) {
                return (Updatelabels)super.setQuotaUser(quotaUser);
            }

            public Updatelabels setUploadType(String uploadType) {
                return (Updatelabels)super.setUploadType(uploadType);
            }

            public Updatelabels setUploadProtocol(String uploadProtocol) {
                return (Updatelabels)super.setUploadProtocol(uploadProtocol);
            }

            public Long getCssGroupId() {
                return this.cssGroupId;
            }

            public Updatelabels setCssGroupId(Long cssGroupId) {
                this.cssGroupId = cssGroupId;
                return this;
            }

            public Long getCssDomainId() {
                return this.cssDomainId;
            }

            public Updatelabels setCssDomainId(Long cssDomainId) {
                this.cssDomainId = cssDomainId;
                return this;
            }

            @Override
            public Updatelabels set(String parameterName, Object value) {
                return (Updatelabels)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<ListCssesResponse> {
            private static final String REST_PATH = "{cssGroupId}/csses";
            @Key
            private Long cssGroupId;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(Long cssGroupId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ListCssesResponse.class);
                this.cssGroupId = (Long)Preconditions.checkNotNull((Object)cssGroupId, (Object)"Required parameter cssGroupId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getCssGroupId() {
                return this.cssGroupId;
            }

            public List setCssGroupId(Long cssGroupId) {
                this.cssGroupId = cssGroupId;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<Css> {
            private static final String REST_PATH = "{cssGroupId}/csses/{cssDomainId}";
            @Key
            private Long cssGroupId;
            @Key
            private Long cssDomainId;

            protected Get(Long cssGroupId, Long cssDomainId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, Css.class);
                this.cssGroupId = (Long)Preconditions.checkNotNull((Object)cssGroupId, (Object)"Required parameter cssGroupId must be specified.");
                this.cssDomainId = (Long)Preconditions.checkNotNull((Object)cssDomainId, (Object)"Required parameter cssDomainId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getCssGroupId() {
                return this.cssGroupId;
            }

            public Get setCssGroupId(Long cssGroupId) {
                this.cssGroupId = cssGroupId;
                return this;
            }

            public Long getCssDomainId() {
                return this.cssDomainId;
            }

            public Get setCssDomainId(Long cssDomainId) {
                this.cssDomainId = cssDomainId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Conversionsources {
        public Create create(Long merchantId, ConversionSource content) throws IOException {
            Create result = new Create(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(Long merchantId, String conversionSourceId) throws IOException {
            Delete result = new Delete(merchantId, conversionSourceId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long merchantId, String conversionSourceId) throws IOException {
            Get result = new Get(merchantId, conversionSourceId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(Long merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(Long merchantId, String conversionSourceId, ConversionSource content) throws IOException {
            Patch result = new Patch(merchantId, conversionSourceId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Undelete undelete(Long merchantId, String conversionSourceId, UndeleteConversionSourceRequest content) throws IOException {
            Undelete result = new Undelete(merchantId, conversionSourceId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Undelete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/conversionsources/{conversionSourceId}:undelete";
            @Key
            private Long merchantId;
            @Key
            private String conversionSourceId;

            protected Undelete(Long merchantId, String conversionSourceId, UndeleteConversionSourceRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Void.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.conversionSourceId = (String)Preconditions.checkNotNull((Object)conversionSourceId, (Object)"Required parameter conversionSourceId must be specified.");
            }

            public Undelete set$Xgafv(String $Xgafv) {
                return (Undelete)super.set$Xgafv($Xgafv);
            }

            public Undelete setAccessToken(String accessToken) {
                return (Undelete)super.setAccessToken(accessToken);
            }

            public Undelete setAlt(String alt) {
                return (Undelete)super.setAlt(alt);
            }

            public Undelete setCallback(String callback) {
                return (Undelete)super.setCallback(callback);
            }

            public Undelete setFields(String fields) {
                return (Undelete)super.setFields(fields);
            }

            public Undelete setKey(String key) {
                return (Undelete)super.setKey(key);
            }

            public Undelete setOauthToken(String oauthToken) {
                return (Undelete)super.setOauthToken(oauthToken);
            }

            public Undelete setPrettyPrint(Boolean prettyPrint) {
                return (Undelete)super.setPrettyPrint(prettyPrint);
            }

            public Undelete setQuotaUser(String quotaUser) {
                return (Undelete)super.setQuotaUser(quotaUser);
            }

            public Undelete setUploadType(String uploadType) {
                return (Undelete)super.setUploadType(uploadType);
            }

            public Undelete setUploadProtocol(String uploadProtocol) {
                return (Undelete)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Undelete setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getConversionSourceId() {
                return this.conversionSourceId;
            }

            public Undelete setConversionSourceId(String conversionSourceId) {
                this.conversionSourceId = conversionSourceId;
                return this;
            }

            @Override
            public Undelete set(String parameterName, Object value) {
                return (Undelete)super.set(parameterName, value);
            }
        }

        public class Patch
        extends ShoppingContentRequest<ConversionSource> {
            private static final String REST_PATH = "{merchantId}/conversionsources/{conversionSourceId}";
            @Key
            private Long merchantId;
            @Key
            private String conversionSourceId;
            @Key
            private String updateMask;

            protected Patch(Long merchantId, String conversionSourceId, ConversionSource content) {
                super(ShoppingContent.this, "PATCH", REST_PATH, (Object)content, ConversionSource.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.conversionSourceId = (String)Preconditions.checkNotNull((Object)conversionSourceId, (Object)"Required parameter conversionSourceId must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Patch setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getConversionSourceId() {
                return this.conversionSourceId;
            }

            public Patch setConversionSourceId(String conversionSourceId) {
                this.conversionSourceId = conversionSourceId;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<ListConversionSourcesResponse> {
            private static final String REST_PATH = "{merchantId}/conversionsources";
            @Key
            private Long merchantId;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private Boolean showDeleted;

            protected List(Long merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ListConversionSourcesResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getShowDeleted() {
                return this.showDeleted;
            }

            public List setShowDeleted(Boolean showDeleted) {
                this.showDeleted = showDeleted;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<ConversionSource> {
            private static final String REST_PATH = "{merchantId}/conversionsources/{conversionSourceId}";
            @Key
            private Long merchantId;
            @Key
            private String conversionSourceId;

            protected Get(Long merchantId, String conversionSourceId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ConversionSource.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.conversionSourceId = (String)Preconditions.checkNotNull((Object)conversionSourceId, (Object)"Required parameter conversionSourceId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getConversionSourceId() {
                return this.conversionSourceId;
            }

            public Get setConversionSourceId(String conversionSourceId) {
                this.conversionSourceId = conversionSourceId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/conversionsources/{conversionSourceId}";
            @Key
            private Long merchantId;
            @Key
            private String conversionSourceId;

            protected Delete(Long merchantId, String conversionSourceId) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.conversionSourceId = (String)Preconditions.checkNotNull((Object)conversionSourceId, (Object)"Required parameter conversionSourceId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getConversionSourceId() {
                return this.conversionSourceId;
            }

            public Delete setConversionSourceId(String conversionSourceId) {
                this.conversionSourceId = conversionSourceId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends ShoppingContentRequest<ConversionSource> {
            private static final String REST_PATH = "{merchantId}/conversionsources";
            @Key
            private Long merchantId;

            protected Create(Long merchantId, ConversionSource content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, ConversionSource.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Create setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Collectionstatuses {
        public Get get(Long merchantId, String collectionId) throws IOException {
            Get result = new Get(merchantId, collectionId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(Long merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ShoppingContentRequest<ListCollectionStatusesResponse> {
            private static final String REST_PATH = "{merchantId}/collectionstatuses";
            @Key
            private Long merchantId;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(Long merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ListCollectionStatusesResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<CollectionStatus> {
            private static final String REST_PATH = "{merchantId}/collectionstatuses/{collectionId}";
            @Key
            private Long merchantId;
            @Key
            private String collectionId;

            protected Get(Long merchantId, String collectionId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, CollectionStatus.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.collectionId = (String)Preconditions.checkNotNull((Object)collectionId, (Object)"Required parameter collectionId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getCollectionId() {
                return this.collectionId;
            }

            public Get setCollectionId(String collectionId) {
                this.collectionId = collectionId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Collections {
        public Create create(Long merchantId, Collection content) throws IOException {
            Create result = new Create(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(Long merchantId, String collectionId) throws IOException {
            Delete result = new Delete(merchantId, collectionId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long merchantId, String collectionId) throws IOException {
            Get result = new Get(merchantId, collectionId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(Long merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ShoppingContentRequest<ListCollectionsResponse> {
            private static final String REST_PATH = "{merchantId}/collections";
            @Key
            private Long merchantId;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(Long merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ListCollectionsResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<Collection> {
            private static final String REST_PATH = "{merchantId}/collections/{collectionId}";
            @Key
            private Long merchantId;
            @Key
            private String collectionId;

            protected Get(Long merchantId, String collectionId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, Collection.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.collectionId = (String)Preconditions.checkNotNull((Object)collectionId, (Object)"Required parameter collectionId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getCollectionId() {
                return this.collectionId;
            }

            public Get setCollectionId(String collectionId) {
                this.collectionId = collectionId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/collections/{collectionId}";
            @Key
            private Long merchantId;
            @Key
            private String collectionId;

            protected Delete(Long merchantId, String collectionId) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.collectionId = (String)Preconditions.checkNotNull((Object)collectionId, (Object)"Required parameter collectionId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getCollectionId() {
                return this.collectionId;
            }

            public Delete setCollectionId(String collectionId) {
                this.collectionId = collectionId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends ShoppingContentRequest<Collection> {
            private static final String REST_PATH = "{merchantId}/collections";
            @Key
            private Long merchantId;

            protected Create(Long merchantId, Collection content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Collection.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Create setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Accounttax {
        public Custombatch custombatch(AccounttaxCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, BigInteger accountId) throws IOException {
            Get result = new Get(merchantId, accountId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(BigInteger merchantId, BigInteger accountId, AccountTax content) throws IOException {
            Update result = new Update(merchantId, accountId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends ShoppingContentRequest<AccountTax> {
            private static final String REST_PATH = "{merchantId}/accounttax/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Update(BigInteger merchantId, BigInteger accountId, AccountTax content) {
                super(ShoppingContent.this, "PUT", REST_PATH, (Object)content, AccountTax.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Update setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Update setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<AccounttaxListResponse> {
            private static final String REST_PATH = "{merchantId}/accounttax";
            @Key
            private BigInteger merchantId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, AccounttaxListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<AccountTax> {
            private static final String REST_PATH = "{merchantId}/accounttax/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Get(BigInteger merchantId, BigInteger accountId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, AccountTax.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Get setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<AccounttaxCustomBatchResponse> {
            private static final String REST_PATH = "accounttax/batch";

            protected Custombatch(AccounttaxCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, AccounttaxCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Accountstatuses {
        public Custombatch custombatch(AccountstatusesCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, BigInteger accountId) throws IOException {
            Get result = new Get(merchantId, accountId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ShoppingContentRequest<AccountstatusesListResponse> {
            private static final String REST_PATH = "{merchantId}/accountstatuses";
            @Key
            private BigInteger merchantId;
            @Key
            private java.util.List<String> destinations;
            @Key
            private Long maxResults;
            @Key
            private String name;
            @Key
            private String pageToken;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, AccountstatusesListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public java.util.List<String> getDestinations() {
                return this.destinations;
            }

            public List setDestinations(java.util.List<String> destinations) {
                this.destinations = destinations;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public List setName(String name) {
                this.name = name;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<AccountStatus> {
            private static final String REST_PATH = "{merchantId}/accountstatuses/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private java.util.List<String> destinations;

            protected Get(BigInteger merchantId, BigInteger accountId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, AccountStatus.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Get setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            public java.util.List<String> getDestinations() {
                return this.destinations;
            }

            public Get setDestinations(java.util.List<String> destinations) {
                this.destinations = destinations;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<AccountstatusesCustomBatchResponse> {
            private static final String REST_PATH = "accountstatuses/batch";

            protected Custombatch(AccountstatusesCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, AccountstatusesCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Accounts {
        public Authinfo authinfo() throws IOException {
            Authinfo result = new Authinfo();
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Claimwebsite claimwebsite(BigInteger merchantId, BigInteger accountId) throws IOException {
            Claimwebsite result = new Claimwebsite(merchantId, accountId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Custombatch custombatch(AccountsCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(BigInteger merchantId, BigInteger accountId) throws IOException {
            Delete result = new Delete(merchantId, accountId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, BigInteger accountId) throws IOException {
            Get result = new Get(merchantId, accountId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(BigInteger merchantId, Account content) throws IOException {
            Insert result = new Insert(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Link link(BigInteger merchantId, BigInteger accountId, AccountsLinkRequest content) throws IOException {
            Link result = new Link(merchantId, accountId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Listlinks listlinks(BigInteger merchantId, BigInteger accountId) throws IOException {
            Listlinks result = new Listlinks(merchantId, accountId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Requestphoneverification requestphoneverification(Long merchantId, Long accountId, RequestPhoneVerificationRequest content) throws IOException {
            Requestphoneverification result = new Requestphoneverification(merchantId, accountId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(BigInteger merchantId, BigInteger accountId, Account content) throws IOException {
            Update result = new Update(merchantId, accountId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Updatelabels updatelabels(BigInteger merchantId, BigInteger accountId, AccountsUpdateLabelsRequest content) throws IOException {
            Updatelabels result = new Updatelabels(merchantId, accountId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Verifyphonenumber verifyphonenumber(Long merchantId, Long accountId, VerifyPhoneNumberRequest content) throws IOException {
            Verifyphonenumber result = new Verifyphonenumber(merchantId, accountId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Credentials credentials() {
            return new Credentials();
        }

        public Labels labels() {
            return new Labels();
        }

        public Returncarrier returncarrier() {
            return new Returncarrier();
        }

        public class Returncarrier {
            public Create create(Long accountId, AccountReturnCarrier content) throws IOException {
                Create result = new Create(accountId, content);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(Long accountId, Long carrierAccountId) throws IOException {
                Delete result = new Delete(accountId, carrierAccountId);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long accountId) throws IOException {
                List result = new List(accountId);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(Long accountId, Long carrierAccountId, AccountReturnCarrier content) throws IOException {
                Patch result = new Patch(accountId, carrierAccountId, content);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends ShoppingContentRequest<AccountReturnCarrier> {
                private static final String REST_PATH = "accounts/{accountId}/returncarrier/{carrierAccountId}";
                @Key
                private Long accountId;
                @Key
                private Long carrierAccountId;

                protected Patch(Long accountId, Long carrierAccountId, AccountReturnCarrier content) {
                    super(ShoppingContent.this, "PATCH", REST_PATH, (Object)content, AccountReturnCarrier.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.carrierAccountId = (Long)Preconditions.checkNotNull((Object)carrierAccountId, (Object)"Required parameter carrierAccountId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public Long getCarrierAccountId() {
                    return this.carrierAccountId;
                }

                public Patch setCarrierAccountId(Long carrierAccountId) {
                    this.carrierAccountId = carrierAccountId;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends ShoppingContentRequest<ListAccountReturnCarrierResponse> {
                private static final String REST_PATH = "accounts/{accountId}/returncarrier";
                @Key
                private Long accountId;

                protected List(Long accountId) {
                    super(ShoppingContent.this, "GET", REST_PATH, null, ListAccountReturnCarrierResponse.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Delete
            extends ShoppingContentRequest<Void> {
                private static final String REST_PATH = "accounts/{accountId}/returncarrier/{carrierAccountId}";
                @Key
                private Long accountId;
                @Key
                private Long carrierAccountId;

                protected Delete(Long accountId, Long carrierAccountId) {
                    super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.carrierAccountId = (Long)Preconditions.checkNotNull((Object)carrierAccountId, (Object)"Required parameter carrierAccountId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public Long getCarrierAccountId() {
                    return this.carrierAccountId;
                }

                public Delete setCarrierAccountId(Long carrierAccountId) {
                    this.carrierAccountId = carrierAccountId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends ShoppingContentRequest<AccountReturnCarrier> {
                private static final String REST_PATH = "accounts/{accountId}/returncarrier";
                @Key
                private Long accountId;

                protected Create(Long accountId, AccountReturnCarrier content) {
                    super(ShoppingContent.this, "POST", REST_PATH, (Object)content, AccountReturnCarrier.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public Create setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Labels {
            public Create create(Long accountId, AccountLabel content) throws IOException {
                Create result = new Create(accountId, content);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(Long accountId, Long labelId) throws IOException {
                Delete result = new Delete(accountId, labelId);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long accountId) throws IOException {
                List result = new List(accountId);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(Long accountId, Long labelId, AccountLabel content) throws IOException {
                Patch result = new Patch(accountId, labelId, content);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends ShoppingContentRequest<AccountLabel> {
                private static final String REST_PATH = "accounts/{accountId}/labels/{labelId}";
                @Key
                private Long accountId;
                @Key
                private Long labelId;

                protected Patch(Long accountId, Long labelId, AccountLabel content) {
                    super(ShoppingContent.this, "PATCH", REST_PATH, (Object)content, AccountLabel.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.labelId = (Long)Preconditions.checkNotNull((Object)labelId, (Object)"Required parameter labelId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public Long getLabelId() {
                    return this.labelId;
                }

                public Patch setLabelId(Long labelId) {
                    this.labelId = labelId;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends ShoppingContentRequest<ListAccountLabelsResponse> {
                private static final String REST_PATH = "accounts/{accountId}/labels";
                @Key
                private Long accountId;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(Long accountId) {
                    super(ShoppingContent.this, "GET", REST_PATH, null, ListAccountLabelsResponse.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Delete
            extends ShoppingContentRequest<Void> {
                private static final String REST_PATH = "accounts/{accountId}/labels/{labelId}";
                @Key
                private Long accountId;
                @Key
                private Long labelId;

                protected Delete(Long accountId, Long labelId) {
                    super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.labelId = (Long)Preconditions.checkNotNull((Object)labelId, (Object)"Required parameter labelId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public Long getLabelId() {
                    return this.labelId;
                }

                public Delete setLabelId(Long labelId) {
                    this.labelId = labelId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends ShoppingContentRequest<AccountLabel> {
                private static final String REST_PATH = "accounts/{accountId}/labels";
                @Key
                private Long accountId;

                protected Create(Long accountId, AccountLabel content) {
                    super(ShoppingContent.this, "POST", REST_PATH, (Object)content, AccountLabel.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public Create setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Credentials {
            public Create create(Long accountId, AccountCredentials content) throws IOException {
                Create result = new Create(accountId, content);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Create
            extends ShoppingContentRequest<AccountCredentials> {
                private static final String REST_PATH = "accounts/{accountId}/credentials";
                @Key
                private Long accountId;

                protected Create(Long accountId, AccountCredentials content) {
                    super(ShoppingContent.this, "POST", REST_PATH, (Object)content, AccountCredentials.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public Create setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Verifyphonenumber
        extends ShoppingContentRequest<VerifyPhoneNumberResponse> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}/verifyphonenumber";
            @Key
            private Long merchantId;
            @Key
            private Long accountId;

            protected Verifyphonenumber(Long merchantId, Long accountId, VerifyPhoneNumberRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, VerifyPhoneNumberResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public Verifyphonenumber set$Xgafv(String $Xgafv) {
                return (Verifyphonenumber)super.set$Xgafv($Xgafv);
            }

            public Verifyphonenumber setAccessToken(String accessToken) {
                return (Verifyphonenumber)super.setAccessToken(accessToken);
            }

            public Verifyphonenumber setAlt(String alt) {
                return (Verifyphonenumber)super.setAlt(alt);
            }

            public Verifyphonenumber setCallback(String callback) {
                return (Verifyphonenumber)super.setCallback(callback);
            }

            public Verifyphonenumber setFields(String fields) {
                return (Verifyphonenumber)super.setFields(fields);
            }

            public Verifyphonenumber setKey(String key) {
                return (Verifyphonenumber)super.setKey(key);
            }

            public Verifyphonenumber setOauthToken(String oauthToken) {
                return (Verifyphonenumber)super.setOauthToken(oauthToken);
            }

            public Verifyphonenumber setPrettyPrint(Boolean prettyPrint) {
                return (Verifyphonenumber)super.setPrettyPrint(prettyPrint);
            }

            public Verifyphonenumber setQuotaUser(String quotaUser) {
                return (Verifyphonenumber)super.setQuotaUser(quotaUser);
            }

            public Verifyphonenumber setUploadType(String uploadType) {
                return (Verifyphonenumber)super.setUploadType(uploadType);
            }

            public Verifyphonenumber setUploadProtocol(String uploadProtocol) {
                return (Verifyphonenumber)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Verifyphonenumber setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Long getAccountId() {
                return this.accountId;
            }

            public Verifyphonenumber setAccountId(Long accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Verifyphonenumber set(String parameterName, Object value) {
                return (Verifyphonenumber)super.set(parameterName, value);
            }
        }

        public class Updatelabels
        extends ShoppingContentRequest<AccountsUpdateLabelsResponse> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}/updatelabels";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Updatelabels(BigInteger merchantId, BigInteger accountId, AccountsUpdateLabelsRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, AccountsUpdateLabelsResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public Updatelabels set$Xgafv(String $Xgafv) {
                return (Updatelabels)super.set$Xgafv($Xgafv);
            }

            public Updatelabels setAccessToken(String accessToken) {
                return (Updatelabels)super.setAccessToken(accessToken);
            }

            public Updatelabels setAlt(String alt) {
                return (Updatelabels)super.setAlt(alt);
            }

            public Updatelabels setCallback(String callback) {
                return (Updatelabels)super.setCallback(callback);
            }

            public Updatelabels setFields(String fields) {
                return (Updatelabels)super.setFields(fields);
            }

            public Updatelabels setKey(String key) {
                return (Updatelabels)super.setKey(key);
            }

            public Updatelabels setOauthToken(String oauthToken) {
                return (Updatelabels)super.setOauthToken(oauthToken);
            }

            public Updatelabels setPrettyPrint(Boolean prettyPrint) {
                return (Updatelabels)super.setPrettyPrint(prettyPrint);
            }

            public Updatelabels setQuotaUser(String quotaUser) {
                return (Updatelabels)super.setQuotaUser(quotaUser);
            }

            public Updatelabels setUploadType(String uploadType) {
                return (Updatelabels)super.setUploadType(uploadType);
            }

            public Updatelabels setUploadProtocol(String uploadProtocol) {
                return (Updatelabels)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Updatelabels setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Updatelabels setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Updatelabels set(String parameterName, Object value) {
                return (Updatelabels)super.set(parameterName, value);
            }
        }

        public class Update
        extends ShoppingContentRequest<Account> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Update(BigInteger merchantId, BigInteger accountId, Account content) {
                super(ShoppingContent.this, "PUT", REST_PATH, (Object)content, Account.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Update setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Update setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Requestphoneverification
        extends ShoppingContentRequest<RequestPhoneVerificationResponse> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}/requestphoneverification";
            @Key
            private Long merchantId;
            @Key
            private Long accountId;

            protected Requestphoneverification(Long merchantId, Long accountId, RequestPhoneVerificationRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, RequestPhoneVerificationResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public Requestphoneverification set$Xgafv(String $Xgafv) {
                return (Requestphoneverification)super.set$Xgafv($Xgafv);
            }

            public Requestphoneverification setAccessToken(String accessToken) {
                return (Requestphoneverification)super.setAccessToken(accessToken);
            }

            public Requestphoneverification setAlt(String alt) {
                return (Requestphoneverification)super.setAlt(alt);
            }

            public Requestphoneverification setCallback(String callback) {
                return (Requestphoneverification)super.setCallback(callback);
            }

            public Requestphoneverification setFields(String fields) {
                return (Requestphoneverification)super.setFields(fields);
            }

            public Requestphoneverification setKey(String key) {
                return (Requestphoneverification)super.setKey(key);
            }

            public Requestphoneverification setOauthToken(String oauthToken) {
                return (Requestphoneverification)super.setOauthToken(oauthToken);
            }

            public Requestphoneverification setPrettyPrint(Boolean prettyPrint) {
                return (Requestphoneverification)super.setPrettyPrint(prettyPrint);
            }

            public Requestphoneverification setQuotaUser(String quotaUser) {
                return (Requestphoneverification)super.setQuotaUser(quotaUser);
            }

            public Requestphoneverification setUploadType(String uploadType) {
                return (Requestphoneverification)super.setUploadType(uploadType);
            }

            public Requestphoneverification setUploadProtocol(String uploadProtocol) {
                return (Requestphoneverification)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Requestphoneverification setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Long getAccountId() {
                return this.accountId;
            }

            public Requestphoneverification setAccountId(Long accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Requestphoneverification set(String parameterName, Object value) {
                return (Requestphoneverification)super.set(parameterName, value);
            }
        }

        public class Listlinks
        extends ShoppingContentRequest<AccountsListLinksResponse> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}/listlinks";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected Listlinks(BigInteger merchantId, BigInteger accountId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, AccountsListLinksResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Listlinks set$Xgafv(String $Xgafv) {
                return (Listlinks)super.set$Xgafv($Xgafv);
            }

            public Listlinks setAccessToken(String accessToken) {
                return (Listlinks)super.setAccessToken(accessToken);
            }

            public Listlinks setAlt(String alt) {
                return (Listlinks)super.setAlt(alt);
            }

            public Listlinks setCallback(String callback) {
                return (Listlinks)super.setCallback(callback);
            }

            public Listlinks setFields(String fields) {
                return (Listlinks)super.setFields(fields);
            }

            public Listlinks setKey(String key) {
                return (Listlinks)super.setKey(key);
            }

            public Listlinks setOauthToken(String oauthToken) {
                return (Listlinks)super.setOauthToken(oauthToken);
            }

            public Listlinks setPrettyPrint(Boolean prettyPrint) {
                return (Listlinks)super.setPrettyPrint(prettyPrint);
            }

            public Listlinks setQuotaUser(String quotaUser) {
                return (Listlinks)super.setQuotaUser(quotaUser);
            }

            public Listlinks setUploadType(String uploadType) {
                return (Listlinks)super.setUploadType(uploadType);
            }

            public Listlinks setUploadProtocol(String uploadProtocol) {
                return (Listlinks)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Listlinks setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Listlinks setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public Listlinks setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Listlinks setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public Listlinks set(String parameterName, Object value) {
                return (Listlinks)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<AccountsListResponse> {
            private static final String REST_PATH = "{merchantId}/accounts";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger label;
            @Key
            private Long maxResults;
            @Key
            private String name;
            @Key
            private String pageToken;
            @Key
            private String view;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, AccountsListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getLabel() {
                return this.label;
            }

            public List setLabel(BigInteger label) {
                this.label = label;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public List setName(String name) {
                this.name = name;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public List setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Link
        extends ShoppingContentRequest<AccountsLinkResponse> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}/link";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Link(BigInteger merchantId, BigInteger accountId, AccountsLinkRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, AccountsLinkResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public Link set$Xgafv(String $Xgafv) {
                return (Link)super.set$Xgafv($Xgafv);
            }

            public Link setAccessToken(String accessToken) {
                return (Link)super.setAccessToken(accessToken);
            }

            public Link setAlt(String alt) {
                return (Link)super.setAlt(alt);
            }

            public Link setCallback(String callback) {
                return (Link)super.setCallback(callback);
            }

            public Link setFields(String fields) {
                return (Link)super.setFields(fields);
            }

            public Link setKey(String key) {
                return (Link)super.setKey(key);
            }

            public Link setOauthToken(String oauthToken) {
                return (Link)super.setOauthToken(oauthToken);
            }

            public Link setPrettyPrint(Boolean prettyPrint) {
                return (Link)super.setPrettyPrint(prettyPrint);
            }

            public Link setQuotaUser(String quotaUser) {
                return (Link)super.setQuotaUser(quotaUser);
            }

            public Link setUploadType(String uploadType) {
                return (Link)super.setUploadType(uploadType);
            }

            public Link setUploadProtocol(String uploadProtocol) {
                return (Link)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Link setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Link setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Link set(String parameterName, Object value) {
                return (Link)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ShoppingContentRequest<Account> {
            private static final String REST_PATH = "{merchantId}/accounts";
            @Key
            private BigInteger merchantId;

            protected Insert(BigInteger merchantId, Account content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Account.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Insert setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<Account> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private String view;

            protected Get(BigInteger merchantId, BigInteger accountId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, Account.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Get setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public Get setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private Boolean force;

            protected Delete(BigInteger merchantId, BigInteger accountId) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Delete setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            public Boolean getForce() {
                return this.force;
            }

            public Delete setForce(Boolean force) {
                this.force = force;
                return this;
            }

            public boolean isForce() {
                if (this.force == null || this.force == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.force;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<AccountsCustomBatchResponse> {
            private static final String REST_PATH = "accounts/batch";

            protected Custombatch(AccountsCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, AccountsCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }

        public class Claimwebsite
        extends ShoppingContentRequest<AccountsClaimWebsiteResponse> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}/claimwebsite";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private Boolean overwrite;

            protected Claimwebsite(BigInteger merchantId, BigInteger accountId) {
                super(ShoppingContent.this, "POST", REST_PATH, null, AccountsClaimWebsiteResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public Claimwebsite set$Xgafv(String $Xgafv) {
                return (Claimwebsite)super.set$Xgafv($Xgafv);
            }

            public Claimwebsite setAccessToken(String accessToken) {
                return (Claimwebsite)super.setAccessToken(accessToken);
            }

            public Claimwebsite setAlt(String alt) {
                return (Claimwebsite)super.setAlt(alt);
            }

            public Claimwebsite setCallback(String callback) {
                return (Claimwebsite)super.setCallback(callback);
            }

            public Claimwebsite setFields(String fields) {
                return (Claimwebsite)super.setFields(fields);
            }

            public Claimwebsite setKey(String key) {
                return (Claimwebsite)super.setKey(key);
            }

            public Claimwebsite setOauthToken(String oauthToken) {
                return (Claimwebsite)super.setOauthToken(oauthToken);
            }

            public Claimwebsite setPrettyPrint(Boolean prettyPrint) {
                return (Claimwebsite)super.setPrettyPrint(prettyPrint);
            }

            public Claimwebsite setQuotaUser(String quotaUser) {
                return (Claimwebsite)super.setQuotaUser(quotaUser);
            }

            public Claimwebsite setUploadType(String uploadType) {
                return (Claimwebsite)super.setUploadType(uploadType);
            }

            public Claimwebsite setUploadProtocol(String uploadProtocol) {
                return (Claimwebsite)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Claimwebsite setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Claimwebsite setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            public Boolean getOverwrite() {
                return this.overwrite;
            }

            public Claimwebsite setOverwrite(Boolean overwrite) {
                this.overwrite = overwrite;
                return this;
            }

            @Override
            public Claimwebsite set(String parameterName, Object value) {
                return (Claimwebsite)super.set(parameterName, value);
            }
        }

        public class Authinfo
        extends ShoppingContentRequest<AccountsAuthInfoResponse> {
            private static final String REST_PATH = "accounts/authinfo";

            protected Authinfo() {
                super(ShoppingContent.this, "GET", REST_PATH, null, AccountsAuthInfoResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Authinfo set$Xgafv(String $Xgafv) {
                return (Authinfo)super.set$Xgafv($Xgafv);
            }

            public Authinfo setAccessToken(String accessToken) {
                return (Authinfo)super.setAccessToken(accessToken);
            }

            public Authinfo setAlt(String alt) {
                return (Authinfo)super.setAlt(alt);
            }

            public Authinfo setCallback(String callback) {
                return (Authinfo)super.setCallback(callback);
            }

            public Authinfo setFields(String fields) {
                return (Authinfo)super.setFields(fields);
            }

            public Authinfo setKey(String key) {
                return (Authinfo)super.setKey(key);
            }

            public Authinfo setOauthToken(String oauthToken) {
                return (Authinfo)super.setOauthToken(oauthToken);
            }

            public Authinfo setPrettyPrint(Boolean prettyPrint) {
                return (Authinfo)super.setPrettyPrint(prettyPrint);
            }

            public Authinfo setQuotaUser(String quotaUser) {
                return (Authinfo)super.setQuotaUser(quotaUser);
            }

            public Authinfo setUploadType(String uploadType) {
                return (Authinfo)super.setUploadType(uploadType);
            }

            public Authinfo setUploadProtocol(String uploadProtocol) {
                return (Authinfo)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Authinfo set(String parameterName, Object value) {
                return (Authinfo)super.set(parameterName, value);
            }
        }
    }
}

