/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.datastore.client;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import java.util.Arrays;
import java.util.List;

public class DatastoreOptions {
    private final String dataset;
    private final String host;
    private static final String DEFAULT_HOST = "https://www.googleapis.com";
    private final HttpRequestInitializer initializer;
    private final Credential credential;
    private final HttpTransport transport;
    public static final List<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/datastore", "https://www.googleapis.com/auth/userinfo.email");

    DatastoreOptions(Builder b) {
        this.dataset = b.dataset;
        this.host = b.host != null ? b.host : DEFAULT_HOST;
        this.initializer = b.initializer;
        this.credential = b.credential;
        this.transport = b.transport;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getHost() {
        return this.host;
    }

    public HttpRequestInitializer getInitializer() {
        return this.initializer;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public static class Builder {
        private String dataset;
        private String host;
        private HttpRequestInitializer initializer;
        private Credential credential;
        private HttpTransport transport;

        public Builder() {
        }

        public Builder(DatastoreOptions options) {
            this.dataset = options.dataset;
            this.host = options.host;
            this.initializer = options.initializer;
            this.credential = options.credential;
            this.transport = options.transport;
        }

        public DatastoreOptions build() {
            return new DatastoreOptions(this);
        }

        public Builder dataset(String newDataset) {
            this.dataset = newDataset;
            return this;
        }

        public Builder host(String newHost) {
            this.host = newHost;
            return this;
        }

        public Builder initializer(HttpRequestInitializer newInitializer) {
            this.initializer = newInitializer;
            return this;
        }

        public Builder credential(Credential newCredential) {
            this.credential = newCredential;
            return this;
        }

        public Builder transport(HttpTransport transport) {
            this.transport = transport;
            return this;
        }
    }
}

