/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.datastore.client;

import com.google.api.services.datastore.DatastoreV1;
import com.google.api.services.datastore.client.Datastore;
import com.google.api.services.datastore.client.DatastoreException;
import com.google.api.services.datastore.client.DatastoreHelper;
import com.google.api.services.datastore.client.QuerySplitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

final class QuerySplitterImpl
implements QuerySplitter {
    private static final int KEYS_PER_SPLIT = 32;
    private static final EnumSet<DatastoreV1.PropertyFilter.Operator> UNSUPPORTED_OPERATORS = EnumSet.of(DatastoreV1.PropertyFilter.Operator.LESS_THAN, DatastoreV1.PropertyFilter.Operator.LESS_THAN_OR_EQUAL, DatastoreV1.PropertyFilter.Operator.GREATER_THAN, DatastoreV1.PropertyFilter.Operator.GREATER_THAN_OR_EQUAL);
    static final QuerySplitter INSTANCE = new QuerySplitterImpl();

    private QuerySplitterImpl() {
    }

    @Override
    public List<DatastoreV1.Query> getSplits(DatastoreV1.Query query, int numSplits, Datastore datastore) throws DatastoreException, IllegalArgumentException {
        this.validateQuery(query);
        this.validateSplitSize(numSplits);
        ArrayList<DatastoreV1.Query> splits = new ArrayList<DatastoreV1.Query>(numSplits);
        List<DatastoreV1.Key> scatterKeys = this.getScatterKeys(numSplits, query, datastore);
        DatastoreV1.Key lastKey = null;
        for (DatastoreV1.Key nextKey : this.getSplitKey(scatterKeys, numSplits)) {
            splits.add(this.createSplit(lastKey, nextKey, query));
            lastKey = nextKey;
        }
        splits.add(this.createSplit(lastKey, null, query));
        return splits;
    }

    private void validateSplitSize(int numSplits) throws IllegalArgumentException {
        if (numSplits < 1) {
            throw new IllegalArgumentException("The number of splits must be greater than 0.");
        }
    }

    private void validateFilter(DatastoreV1.Filter filter) throws IllegalArgumentException {
        if (filter.hasCompositeFilter()) {
            for (DatastoreV1.Filter subFilter : filter.getCompositeFilter().getFilterList()) {
                this.validateFilter(subFilter);
            }
        } else if (filter.hasPropertyFilter() && UNSUPPORTED_OPERATORS.contains((Object)filter.getPropertyFilter().getOperator())) {
            throw new IllegalArgumentException("Query cannot have any inequality filters.");
        }
    }

    private void validateQuery(DatastoreV1.Query query) throws IllegalArgumentException {
        if (query.getKindCount() != 1) {
            throw new IllegalArgumentException("Query must have exactly one kind.");
        }
        if (query.getOrderCount() != 0) {
            throw new IllegalArgumentException("Query cannot have any sort orders.");
        }
        if (query.hasFilter()) {
            this.validateFilter(query.getFilter());
        }
    }

    private DatastoreV1.Query createSplit(DatastoreV1.Key lastKey, DatastoreV1.Key nextKey, DatastoreV1.Query query) {
        ArrayList<DatastoreV1.Filter> keyFilters = new ArrayList<DatastoreV1.Filter>();
        if (query.hasFilter()) {
            keyFilters.add(query.getFilter());
        }
        if (lastKey != null) {
            DatastoreV1.Filter lowerBound = DatastoreHelper.makeFilter("__key__", DatastoreV1.PropertyFilter.Operator.GREATER_THAN_OR_EQUAL, DatastoreHelper.makeValue(lastKey)).build();
            keyFilters.add(lowerBound);
        }
        if (nextKey != null) {
            DatastoreV1.Filter upperBound = DatastoreHelper.makeFilter("__key__", DatastoreV1.PropertyFilter.Operator.LESS_THAN, DatastoreHelper.makeValue(nextKey)).build();
            keyFilters.add(upperBound);
        }
        return DatastoreV1.Query.newBuilder(query).setFilter(DatastoreHelper.makeFilter(keyFilters)).build();
    }

    private List<DatastoreV1.Key> getScatterKeys(int numSplits, DatastoreV1.Query query, Datastore datastore) throws DatastoreException {
        DatastoreV1.QueryResultBatch batch;
        DatastoreV1.Query.Builder scatterPointQuery = this.createScatterQuery(query, numSplits);
        ArrayList<DatastoreV1.Key> keySplits = new ArrayList<DatastoreV1.Key>();
        do {
            DatastoreV1.RunQueryRequest scatterRequest = DatastoreV1.RunQueryRequest.newBuilder().setQuery(scatterPointQuery).build();
            batch = datastore.runQuery(scatterRequest).getBatch();
            for (DatastoreV1.EntityResult result : batch.getEntityResultList()) {
                keySplits.add(result.getEntity().getKey());
            }
            scatterPointQuery.setStartCursor(batch.getEndCursor());
            scatterPointQuery.setLimit(scatterPointQuery.getLimit() - batch.getEntityResultCount());
        } while (batch.getMoreResults() == DatastoreV1.QueryResultBatch.MoreResultsType.NOT_FINISHED);
        Collections.sort(keySplits, DatastoreHelper.getKeyComparator());
        return keySplits;
    }

    private DatastoreV1.Query.Builder createScatterQuery(DatastoreV1.Query query, int numSplits) {
        DatastoreV1.Query.Builder scatterPointQuery = DatastoreV1.Query.newBuilder();
        scatterPointQuery.addAllKind(query.getKindList());
        scatterPointQuery.addOrder(DatastoreHelper.makeOrder("__scatter__", DatastoreV1.PropertyOrder.Direction.ASCENDING));
        scatterPointQuery.setLimit((numSplits - 1) * 32);
        scatterPointQuery.addProjection(DatastoreV1.PropertyExpression.newBuilder().setProperty(DatastoreV1.PropertyReference.newBuilder().setName("__key__")));
        return scatterPointQuery;
    }

    private Iterable<DatastoreV1.Key> getSplitKey(List<DatastoreV1.Key> keys, int numSplits) {
        if (keys.size() < numSplits - 1) {
            return keys;
        }
        double numKeysPerSplit = Math.max(1.0, (double)keys.size() / (double)(numSplits - 1));
        ArrayList<DatastoreV1.Key> keysList = new ArrayList<DatastoreV1.Key>(numSplits - 1);
        for (int i = 1; i < numSplits; ++i) {
            int splitIndex = (int)Math.round((double)i * numKeysPerSplit) - 1;
            keysList.add(keys.get(splitIndex));
        }
        return keysList;
    }
}

