/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.datastore.client;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.services.datastore.client.Datastore;
import com.google.api.services.datastore.client.LocalDevelopmentDatastoreException;
import com.google.api.services.datastore.client.LocalDevelopmentDatastoreOptions;
import com.google.api.services.datastore.client.RemoteRpc;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class LocalDevelopmentDatastore
extends Datastore {
    private static final int STARTUP_TIMEOUT_SECS = 30;
    private final String host;
    private LocalDevelopmentDatastoreOptions localDevelopmentOptions;
    private volatile State state = State.NEW;
    private File datasetDirectory;

    LocalDevelopmentDatastore(RemoteRpc rpc, String host, LocalDevelopmentDatastoreOptions localDevelopmentOptions) {
        super(rpc);
        this.host = host;
        this.localDevelopmentOptions = localDevelopmentOptions;
    }

    public void clear() throws LocalDevelopmentDatastoreException {
        HttpRequestFactory client = this.remoteRpc.getHttpRequestFactory();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("action", "Clear Datastore");
            UrlEncodedContent content = new UrlEncodedContent(params);
            GenericUrl url = new GenericUrl(String.valueOf(this.host).concat("/_ah/admin/datastore"));
            HttpResponse httpResponse = client.buildPostRequest(url, (HttpContent)content).execute();
            if (!httpResponse.isSuccessStatusCode()) {
                int n = httpResponse.getStatusCode();
                throw new LocalDevelopmentDatastoreException(new StringBuilder(48).append("Clear Datastore returned http status ").append(n).toString());
            }
        }
        catch (IOException e) {
            throw new LocalDevelopmentDatastoreException("Exception trying to clear the dev datastore", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(String sdkPath, String dataset, String ... cmdLineOptions) throws LocalDevelopmentDatastoreException {
        Preconditions.checkNotNull((Object)sdkPath, (Object)"sdkPath cannot be null");
        Preconditions.checkNotNull((Object)dataset, (Object)"dataset cannot be null");
        Preconditions.checkState((this.state == State.NEW ? 1 : 0) != 0, (Object)"Cannot call start() more than once.");
        try {
            this.startDatastoreInternal(sdkPath, dataset, cmdLineOptions);
            this.state = State.STARTED;
        }
        finally {
            if (this.state != State.STARTED) {
                this.state = State.STOPPED;
            }
        }
    }

    void startDatastoreInternal(String sdkPath, String dataset, String ... cmdLineOptions) throws LocalDevelopmentDatastoreException {
        Process gcdStartProcess;
        File datasetDirectory = this.createDatastore(sdkPath, dataset);
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList("./gcd.sh", "start", "--allow_remote_shutdown", "--store_on_disk=false"));
        cmd.addAll(Arrays.asList(cmdLineOptions));
        cmd.add(datasetDirectory.getPath());
        try {
            gcdStartProcess = this.newGcdProcess(sdkPath, cmd).start();
        }
        catch (IOException e) {
            throw new LocalDevelopmentDatastoreException("Could not start dev server", e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                gcdStartProcess.destroy();
            }
        });
        StartupMonitor monitor = new StartupMonitor(gcdStartProcess.getInputStream());
        try {
            monitor.start();
            if (!monitor.startupCompleteLatch.await(30L, TimeUnit.SECONDS)) {
                throw new LocalDevelopmentDatastoreException("Dev server did not start within 30 seconds");
            }
            if (!monitor.success) {
                throw new LocalDevelopmentDatastoreException("Server did not start normally");
            }
        }
        catch (InterruptedException e) {
            throw new LocalDevelopmentDatastoreException("Received an interrupt", e);
        }
    }

    private File createDatastore(String sdkPath, String dataset) throws LocalDevelopmentDatastoreException {
        try {
            this.datasetDirectory = Files.createTempDirectory("local-development-datastore", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new LocalDevelopmentDatastoreException("Could not create dataset tmp directory", e);
        }
        String[] stringArray = new String[4];
        stringArray[0] = "./gcd.sh";
        stringArray[1] = "create";
        String string = String.valueOf(dataset);
        stringArray[2] = string.length() != 0 ? "--project_id=".concat(string) : new String("--project_id=");
        stringArray[3] = this.datasetDirectory.getPath();
        List<String> cmd = Arrays.asList(stringArray);
        try {
            int retCode = this.newGcdProcess(sdkPath, cmd).start().waitFor();
            if (retCode != 0) {
                throw new LocalDevelopmentDatastoreException(String.format("Could not create dataset (retcode=%d)", retCode));
            }
        }
        catch (IOException e) {
            throw new LocalDevelopmentDatastoreException("Could not create dataset", e);
        }
        catch (InterruptedException e) {
            throw new LocalDevelopmentDatastoreException("Received an interrupt", e);
        }
        return this.datasetDirectory;
    }

    private ProcessBuilder newGcdProcess(String sdkPath, List<String> cmd) {
        ProcessBuilder builder = new ProcessBuilder(cmd);
        builder.directory(new File(sdkPath));
        builder.redirectErrorStream(true);
        builder.environment().putAll(this.localDevelopmentOptions.getEnvVars());
        return builder;
    }

    public File getDatasetDirectory() {
        Preconditions.checkState((this.state == State.STARTED ? 1 : 0) != 0);
        return this.datasetDirectory;
    }

    public synchronized void stop() throws LocalDevelopmentDatastoreException {
        this.stopDatastoreInternal();
        if (this.state != State.STOPPED) {
            this.state = State.STOPPED;
            if (this.datasetDirectory != null) {
                try {
                    Process process = new ProcessBuilder("rm", "-r", this.datasetDirectory.getAbsolutePath()).start();
                    if (process.waitFor() != 0) {
                        int n = process.exitValue();
                        throw new IOException(new StringBuilder(45).append("Temp directory delete exited with ").append(n).toString());
                    }
                }
                catch (IOException | InterruptedException e) {
                    throw new IllegalStateException("Dataset directory wipe failed.", e);
                }
            }
        }
    }

    void stopDatastoreInternal() throws LocalDevelopmentDatastoreException {
        HttpRequestFactory client = this.remoteRpc.getHttpRequestFactory();
        HashMap params = new HashMap();
        UrlEncodedContent content = new UrlEncodedContent(params);
        GenericUrl url = new GenericUrl(String.valueOf(this.host).concat("/_ah/admin/quit"));
        try {
            HttpResponse httpResponse = client.buildPostRequest(url, (HttpContent)content).execute();
            if (!httpResponse.isSuccessStatusCode()) {
                int n = httpResponse.getStatusCode();
                throw new LocalDevelopmentDatastoreException(new StringBuilder(72).append("Request to shutdown local datastore returned http error code ").append(n).toString());
            }
        }
        catch (IOException e) {
            throw new LocalDevelopmentDatastoreException("Exception trying to stop the dev datastore", e);
        }
    }

    static class StartupMonitor
    extends Thread {
        private final InputStream inputStream;
        private volatile boolean success = false;
        private final CountDownLatch startupCompleteLatch = new CountDownLatch(1);

        StartupMonitor(InputStream inputStream) {
            this.inputStream = inputStream;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.inputStream));
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                    if (this.success || !line.contains("Dev App Server is now running")) continue;
                    this.success = true;
                    this.startupCompleteLatch.countDown();
                }
            }
            catch (IOException ioe) {
                if (!this.success) {
                    System.err.println("Received an IOException before the dev server startup completed. Dev server is in an unknown state.");
                } else {
                    System.err.println("Received an exception handling output from the dev server. Logging will stop but the dev server is probably ok.");
                }
                ioe.printStackTrace();
            }
            finally {
                if (!this.success) {
                    this.startupCompleteLatch.countDown();
                }
            }
        }
    }

    static enum State {
        NEW,
        STARTED,
        STOPPED;

    }
}

