/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.datastore.client;

import com.google.api.services.datastore.DatastoreV1;
import com.google.api.services.datastore.client.DatastoreException;
import com.google.api.services.datastore.client.RemoteRpc;
import com.google.protobuf.MessageLite;
import java.io.IOException;

public class Datastore {
    final RemoteRpc remoteRpc;

    Datastore(RemoteRpc remoteRpc) {
        this.remoteRpc = remoteRpc;
    }

    public void resetRpcCount() {
        this.remoteRpc.resetRpcCount();
    }

    public int getRpcCount() {
        return this.remoteRpc.getRpcCount();
    }

    private DatastoreException invalidResponseException(String method, IOException exception) {
        return RemoteRpc.makeException(this.remoteRpc.getUrl(), method, 503, "Invalid response", exception);
    }

    public DatastoreV1.AllocateIdsResponse allocateIds(DatastoreV1.AllocateIdsRequest request) throws DatastoreException {
        try {
            return DatastoreV1.AllocateIdsResponse.parseFrom(this.remoteRpc.call("allocateIds", (MessageLite)request));
        }
        catch (IOException exception) {
            throw this.invalidResponseException("allocateIds", exception);
        }
    }

    public DatastoreV1.BeginTransactionResponse beginTransaction(DatastoreV1.BeginTransactionRequest request) throws DatastoreException {
        try {
            return DatastoreV1.BeginTransactionResponse.parseFrom(this.remoteRpc.call("beginTransaction", (MessageLite)request));
        }
        catch (IOException exception) {
            throw this.invalidResponseException("beginTransaction", exception);
        }
    }

    public DatastoreV1.CommitResponse commit(DatastoreV1.CommitRequest request) throws DatastoreException {
        try {
            return DatastoreV1.CommitResponse.parseFrom(this.remoteRpc.call("commit", (MessageLite)request));
        }
        catch (IOException exception) {
            throw this.invalidResponseException("commit", exception);
        }
    }

    public DatastoreV1.LookupResponse lookup(DatastoreV1.LookupRequest request) throws DatastoreException {
        try {
            return DatastoreV1.LookupResponse.parseFrom(this.remoteRpc.call("lookup", (MessageLite)request));
        }
        catch (IOException exception) {
            throw this.invalidResponseException("lookup", exception);
        }
    }

    public DatastoreV1.RollbackResponse rollback(DatastoreV1.RollbackRequest request) throws DatastoreException {
        try {
            return DatastoreV1.RollbackResponse.parseFrom(this.remoteRpc.call("rollback", (MessageLite)request));
        }
        catch (IOException exception) {
            throw this.invalidResponseException("rollback", exception);
        }
    }

    public DatastoreV1.RunQueryResponse runQuery(DatastoreV1.RunQueryRequest request) throws DatastoreException {
        try {
            return DatastoreV1.RunQueryResponse.parseFrom(this.remoteRpc.call("runQuery", (MessageLite)request));
        }
        catch (IOException exception) {
            throw this.invalidResponseException("runQuery", exception);
        }
    }
}

