/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-16 at 10:27:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.deploymentmanager.model;

/**
 * Options allows customized resource handling by Deployment Manager.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Deployment Manager Alpha API. For a
 * detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Options extends com.google.api.client.json.GenericJson {

  /**
   * Options regarding how to thread async requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AsyncOptions> asyncOptions;

  static {
    // hack to force ProGuard to consider AsyncOptions used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(AsyncOptions.class);
  }

  /**
   * The mappings that apply for requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InputMapping> inputMappings;

  static {
    // hack to force ProGuard to consider InputMapping used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(InputMapping.class);
  }

  /**
   * The json path to the field in the resource JSON body into which the resource name should be
   * mapped. Leaving this empty indicates that there should be no mapping performed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nameProperty;

  /**
   * Options for how to validate and process properties on a resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ValidationOptions validationOptions;

  /**
   * Options regarding how to thread async requests.
   * @return value or {@code null} for none
   */
  public java.util.List<AsyncOptions> getAsyncOptions() {
    return asyncOptions;
  }

  /**
   * Options regarding how to thread async requests.
   * @param asyncOptions asyncOptions or {@code null} for none
   */
  public Options setAsyncOptions(java.util.List<AsyncOptions> asyncOptions) {
    this.asyncOptions = asyncOptions;
    return this;
  }

  /**
   * The mappings that apply for requests.
   * @return value or {@code null} for none
   */
  public java.util.List<InputMapping> getInputMappings() {
    return inputMappings;
  }

  /**
   * The mappings that apply for requests.
   * @param inputMappings inputMappings or {@code null} for none
   */
  public Options setInputMappings(java.util.List<InputMapping> inputMappings) {
    this.inputMappings = inputMappings;
    return this;
  }

  /**
   * The json path to the field in the resource JSON body into which the resource name should be
   * mapped. Leaving this empty indicates that there should be no mapping performed.
   * @return value or {@code null} for none
   */
  public java.lang.String getNameProperty() {
    return nameProperty;
  }

  /**
   * The json path to the field in the resource JSON body into which the resource name should be
   * mapped. Leaving this empty indicates that there should be no mapping performed.
   * @param nameProperty nameProperty or {@code null} for none
   */
  public Options setNameProperty(java.lang.String nameProperty) {
    this.nameProperty = nameProperty;
    return this;
  }

  /**
   * Options for how to validate and process properties on a resource.
   * @return value or {@code null} for none
   */
  public ValidationOptions getValidationOptions() {
    return validationOptions;
  }

  /**
   * Options for how to validate and process properties on a resource.
   * @param validationOptions validationOptions or {@code null} for none
   */
  public Options setValidationOptions(ValidationOptions validationOptions) {
    this.validationOptions = validationOptions;
    return this;
  }

  @Override
  public Options set(String fieldName, Object value) {
    return (Options) super.set(fieldName, value);
  }

  @Override
  public Options clone() {
    return (Options) super.clone();
  }

}
