/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.deploymentmanager.model;

/**
 * Deployment Manager will call these methods during the events of
 * creation/deletion/update/get/setIamPolicy
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Deployment Manager V2 API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MethodMap extends com.google.api.client.json.GenericJson {

  /**
   * The action identifier for the create method to be used for this collection
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String create;

  /**
   * The action identifier for the delete method to be used for this collection
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String delete;

  /**
   * The action identifier for the get method to be used for this collection
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String get;

  /**
   * The action identifier for the setIamPolicy method to be used for this collection
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String setIamPolicy;

  /**
   * The action identifier for the update method to be used for this collection
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String update;

  /**
   * The action identifier for the create method to be used for this collection
   * @return value or {@code null} for none
   */
  public java.lang.String getCreate() {
    return create;
  }

  /**
   * The action identifier for the create method to be used for this collection
   * @param create create or {@code null} for none
   */
  public MethodMap setCreate(java.lang.String create) {
    this.create = create;
    return this;
  }

  /**
   * The action identifier for the delete method to be used for this collection
   * @return value or {@code null} for none
   */
  public java.lang.String getDelete() {
    return delete;
  }

  /**
   * The action identifier for the delete method to be used for this collection
   * @param delete delete or {@code null} for none
   */
  public MethodMap setDelete(java.lang.String delete) {
    this.delete = delete;
    return this;
  }

  /**
   * The action identifier for the get method to be used for this collection
   * @return value or {@code null} for none
   */
  public java.lang.String getGet() {
    return get;
  }

  /**
   * The action identifier for the get method to be used for this collection
   * @param get get or {@code null} for none
   */
  public MethodMap setGet(java.lang.String get) {
    this.get = get;
    return this;
  }

  /**
   * The action identifier for the setIamPolicy method to be used for this collection
   * @return value or {@code null} for none
   */
  public java.lang.String getSetIamPolicy() {
    return setIamPolicy;
  }

  /**
   * The action identifier for the setIamPolicy method to be used for this collection
   * @param setIamPolicy setIamPolicy or {@code null} for none
   */
  public MethodMap setSetIamPolicy(java.lang.String setIamPolicy) {
    this.setIamPolicy = setIamPolicy;
    return this;
  }

  /**
   * The action identifier for the update method to be used for this collection
   * @return value or {@code null} for none
   */
  public java.lang.String getUpdate() {
    return update;
  }

  /**
   * The action identifier for the update method to be used for this collection
   * @param update update or {@code null} for none
   */
  public MethodMap setUpdate(java.lang.String update) {
    this.update = update;
    return this;
  }

  @Override
  public MethodMap set(String fieldName, Object value) {
    return (MethodMap) super.set(fieldName, value);
  }

  @Override
  public MethodMap clone() {
    return (MethodMap) super.clone();
  }

}
