/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.deploymentmanager.model;

/**
 * Model definition for InstancesBulkInsertOperationMetadata.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Deployment Manager V2 API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstancesBulkInsertOperationMetadata extends com.google.api.client.json.GenericJson {

  /**
   * Status information per location (location name is key). Example key: zones/us-central1-a
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, BulkInsertOperationStatus> perLocationStatus;

  static {
    // hack to force ProGuard to consider BulkInsertOperationStatus used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(BulkInsertOperationStatus.class);
  }

  /**
   * Status information per location (location name is key). Example key: zones/us-central1-a
   * @return value or {@code null} for none
   */
  public java.util.Map<String, BulkInsertOperationStatus> getPerLocationStatus() {
    return perLocationStatus;
  }

  /**
   * Status information per location (location name is key). Example key: zones/us-central1-a
   * @param perLocationStatus perLocationStatus or {@code null} for none
   */
  public InstancesBulkInsertOperationMetadata setPerLocationStatus(java.util.Map<String, BulkInsertOperationStatus> perLocationStatus) {
    this.perLocationStatus = perLocationStatus;
    return this;
  }

  @Override
  public InstancesBulkInsertOperationMetadata set(String fieldName, Object value) {
    return (InstancesBulkInsertOperationMetadata) super.set(fieldName, value);
  }

  @Override
  public InstancesBulkInsertOperationMetadata clone() {
    return (InstancesBulkInsertOperationMetadata) super.clone();
  }

}
