/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-02-26 17:53:51 UTC)
 * on 2018-03-15 at 08:05:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.deploymentmanager.model;

/**
 * The credential used by Deployment Manager and TypeProvider. Only one of the options is permitted.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Deployment Manager Alpha API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Credential extends com.google.api.client.json.GenericJson {

  /**
   * Basic Auth Credential, only used by TypeProvider.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BasicAuth basicAuth;

  /**
   * Service Account Credential, only used by Deployment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ServiceAccount serviceAccount;

  /**
   * Specify to use the project default credential, only supported by Deployment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean useProjectDefault;

  /**
   * Basic Auth Credential, only used by TypeProvider.
   * @return value or {@code null} for none
   */
  public BasicAuth getBasicAuth() {
    return basicAuth;
  }

  /**
   * Basic Auth Credential, only used by TypeProvider.
   * @param basicAuth basicAuth or {@code null} for none
   */
  public Credential setBasicAuth(BasicAuth basicAuth) {
    this.basicAuth = basicAuth;
    return this;
  }

  /**
   * Service Account Credential, only used by Deployment.
   * @return value or {@code null} for none
   */
  public ServiceAccount getServiceAccount() {
    return serviceAccount;
  }

  /**
   * Service Account Credential, only used by Deployment.
   * @param serviceAccount serviceAccount or {@code null} for none
   */
  public Credential setServiceAccount(ServiceAccount serviceAccount) {
    this.serviceAccount = serviceAccount;
    return this;
  }

  /**
   * Specify to use the project default credential, only supported by Deployment.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUseProjectDefault() {
    return useProjectDefault;
  }

  /**
   * Specify to use the project default credential, only supported by Deployment.
   * @param useProjectDefault useProjectDefault or {@code null} for none
   */
  public Credential setUseProjectDefault(java.lang.Boolean useProjectDefault) {
    this.useProjectDefault = useProjectDefault;
    return this;
  }

  @Override
  public Credential set(String fieldName, Object value) {
    return (Credential) super.set(fieldName, value);
  }

  @Override
  public Credential clone() {
    return (Credential) super.clone();
  }

}
