/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-05-16 at 02:49:27 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.deploymentmanager.model;

/**
 * Model definition for Resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Deployment Manager Alpha API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Resource extends com.google.api.client.json.GenericJson {

  /**
   * The Access Control Policy set on this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResourceAccessControl accessControl;

  /**
   * Output only. The evaluated properties of the resource with references expanded. Returned as
   * serialized YAML.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String finalProperties;

  /**
   * Output only. Unique identifier for the resource; defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * Output only. Timestamp when the resource was created or acquired, in RFC3339 text format .
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String insertTime;

  /**
   * Output only. The last used credential that successfully created/updated the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Credential lastUsedCredential;

  /**
   * Output only. URL of the manifest representing the current configuration of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String manifest;

  /**
   * Output only. The name of the resource as it appears in the YAML config.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. The current properties of the resource before any references have been filled in.
   * Returned as serialized YAML.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String properties;

  /**
   * Output only. In case this is an action, it will show the runtimePolicies on which this action
   * will run in the deployment
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> runtimePolicies;

  /**
   * Output only. The type of the resource, for example compute.v1.instance, or
   * cloudfunctions.v1beta1.function.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Output only. If Deployment Manager is currently updating or previewing an update to this
   * resource, the updated configuration appears here.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ResourceUpdate update;

  /**
   * Output only. Timestamp when the resource was updated, in RFC3339 text format .
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String updateTime;

  /**
   * Output only. The URL of the actual resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String url;

  /**
   * Output only. If warning messages are generated during processing of this resource, this field
   * will be populated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Warnings> warnings;

  static {
    // hack to force ProGuard to consider Warnings used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Warnings.class);
  }

  /**
   * The Access Control Policy set on this resource.
   * @return value or {@code null} for none
   */
  public ResourceAccessControl getAccessControl() {
    return accessControl;
  }

  /**
   * The Access Control Policy set on this resource.
   * @param accessControl accessControl or {@code null} for none
   */
  public Resource setAccessControl(ResourceAccessControl accessControl) {
    this.accessControl = accessControl;
    return this;
  }

  /**
   * Output only. The evaluated properties of the resource with references expanded. Returned as
   * serialized YAML.
   * @return value or {@code null} for none
   */
  public java.lang.String getFinalProperties() {
    return finalProperties;
  }

  /**
   * Output only. The evaluated properties of the resource with references expanded. Returned as
   * serialized YAML.
   * @param finalProperties finalProperties or {@code null} for none
   */
  public Resource setFinalProperties(java.lang.String finalProperties) {
    this.finalProperties = finalProperties;
    return this;
  }

  /**
   * Output only. Unique identifier for the resource; defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * Output only. Unique identifier for the resource; defined by the server.
   * @param id id or {@code null} for none
   */
  public Resource setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * Output only. Timestamp when the resource was created or acquired, in RFC3339 text format .
   * @return value or {@code null} for none
   */
  public java.lang.String getInsertTime() {
    return insertTime;
  }

  /**
   * Output only. Timestamp when the resource was created or acquired, in RFC3339 text format .
   * @param insertTime insertTime or {@code null} for none
   */
  public Resource setInsertTime(java.lang.String insertTime) {
    this.insertTime = insertTime;
    return this;
  }

  /**
   * Output only. The last used credential that successfully created/updated the resource.
   * @return value or {@code null} for none
   */
  public Credential getLastUsedCredential() {
    return lastUsedCredential;
  }

  /**
   * Output only. The last used credential that successfully created/updated the resource.
   * @param lastUsedCredential lastUsedCredential or {@code null} for none
   */
  public Resource setLastUsedCredential(Credential lastUsedCredential) {
    this.lastUsedCredential = lastUsedCredential;
    return this;
  }

  /**
   * Output only. URL of the manifest representing the current configuration of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getManifest() {
    return manifest;
  }

  /**
   * Output only. URL of the manifest representing the current configuration of this resource.
   * @param manifest manifest or {@code null} for none
   */
  public Resource setManifest(java.lang.String manifest) {
    this.manifest = manifest;
    return this;
  }

  /**
   * Output only. The name of the resource as it appears in the YAML config.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. The name of the resource as it appears in the YAML config.
   * @param name name or {@code null} for none
   */
  public Resource setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Output only. The current properties of the resource before any references have been filled in.
   * Returned as serialized YAML.
   * @return value or {@code null} for none
   */
  public java.lang.String getProperties() {
    return properties;
  }

  /**
   * Output only. The current properties of the resource before any references have been filled in.
   * Returned as serialized YAML.
   * @param properties properties or {@code null} for none
   */
  public Resource setProperties(java.lang.String properties) {
    this.properties = properties;
    return this;
  }

  /**
   * Output only. In case this is an action, it will show the runtimePolicies on which this action
   * will run in the deployment
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getRuntimePolicies() {
    return runtimePolicies;
  }

  /**
   * Output only. In case this is an action, it will show the runtimePolicies on which this action
   * will run in the deployment
   * @param runtimePolicies runtimePolicies or {@code null} for none
   */
  public Resource setRuntimePolicies(java.util.List<java.lang.String> runtimePolicies) {
    this.runtimePolicies = runtimePolicies;
    return this;
  }

  /**
   * Output only. The type of the resource, for example compute.v1.instance, or
   * cloudfunctions.v1beta1.function.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Output only. The type of the resource, for example compute.v1.instance, or
   * cloudfunctions.v1beta1.function.
   * @param type type or {@code null} for none
   */
  public Resource setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * Output only. If Deployment Manager is currently updating or previewing an update to this
   * resource, the updated configuration appears here.
   * @return value or {@code null} for none
   */
  public ResourceUpdate getUpdate() {
    return update;
  }

  /**
   * Output only. If Deployment Manager is currently updating or previewing an update to this
   * resource, the updated configuration appears here.
   * @param update update or {@code null} for none
   */
  public Resource setUpdate(ResourceUpdate update) {
    this.update = update;
    return this;
  }

  /**
   * Output only. Timestamp when the resource was updated, in RFC3339 text format .
   * @return value or {@code null} for none
   */
  public java.lang.String getUpdateTime() {
    return updateTime;
  }

  /**
   * Output only. Timestamp when the resource was updated, in RFC3339 text format .
   * @param updateTime updateTime or {@code null} for none
   */
  public Resource setUpdateTime(java.lang.String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  /**
   * Output only. The URL of the actual resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getUrl() {
    return url;
  }

  /**
   * Output only. The URL of the actual resource.
   * @param url url or {@code null} for none
   */
  public Resource setUrl(java.lang.String url) {
    this.url = url;
    return this;
  }

  /**
   * Output only. If warning messages are generated during processing of this resource, this field
   * will be populated.
   * @return value or {@code null} for none
   */
  public java.util.List<Warnings> getWarnings() {
    return warnings;
  }

  /**
   * Output only. If warning messages are generated during processing of this resource, this field
   * will be populated.
   * @param warnings warnings or {@code null} for none
   */
  public Resource setWarnings(java.util.List<Warnings> warnings) {
    this.warnings = warnings;
    return this;
  }

  @Override
  public Resource set(String fieldName, Object value) {
    return (Resource) super.set(fieldName, value);
  }

  @Override
  public Resource clone() {
    return (Resource) super.clone();
  }

  /**
   * Model definition for ResourceWarnings.
   */
  public static final class Warnings extends com.google.api.client.json.GenericJson {

    /**
     * [Output Only] A warning code, if applicable. For example, Compute Engine returns
     * NO_RESULTS_ON_PAGE if there are no results in the response.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String code;

    /**
     * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key":
     * "scope", "value": "zones/us-east1-d" }
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Data> data;

    static {
      // hack to force ProGuard to consider Data used, since otherwise it would be stripped out
      // see https://github.com/google/google-api-java-client/issues/543
      com.google.api.client.util.Data.nullOf(Data.class);
    }

    /**
     * [Output Only] A human-readable description of the warning code.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String message;

    /**
     * [Output Only] A warning code, if applicable. For example, Compute Engine returns
     * NO_RESULTS_ON_PAGE if there are no results in the response.
     * @return value or {@code null} for none
     */
    public java.lang.String getCode() {
      return code;
    }

    /**
     * [Output Only] A warning code, if applicable. For example, Compute Engine returns
     * NO_RESULTS_ON_PAGE if there are no results in the response.
     * @param code code or {@code null} for none
     */
    public Warnings setCode(java.lang.String code) {
      this.code = code;
      return this;
    }

    /**
     * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key":
     * "scope", "value": "zones/us-east1-d" }
     * @return value or {@code null} for none
     */
    public java.util.List<Data> getData() {
      return data;
    }

    /**
     * [Output Only] Metadata about this warning in key: value format. For example: "data": [ { "key":
     * "scope", "value": "zones/us-east1-d" }
     * @param data data or {@code null} for none
     */
    public Warnings setData(java.util.List<Data> data) {
      this.data = data;
      return this;
    }

    /**
     * [Output Only] A human-readable description of the warning code.
     * @return value or {@code null} for none
     */
    public java.lang.String getMessage() {
      return message;
    }

    /**
     * [Output Only] A human-readable description of the warning code.
     * @param message message or {@code null} for none
     */
    public Warnings setMessage(java.lang.String message) {
      this.message = message;
      return this;
    }

    @Override
    public Warnings set(String fieldName, Object value) {
      return (Warnings) super.set(fieldName, value);
    }

    @Override
    public Warnings clone() {
      return (Warnings) super.clone();
    }

    /**
     * Model definition for ResourceWarningsData.
     */
    public static final class Data extends com.google.api.client.json.GenericJson {

      /**
       * [Output Only] A key that provides more detail on the warning being returned. For example, for
       * warnings where there are no results in a list request for a particular zone, this key might be
       * scope and the key value might be the zone name. Other examples might be a key indicating a
       * deprecated resource and a suggested replacement, or a warning about invalid network settings
       * (for example, if an instance attempts to perform IP forwarding but is not enabled for IP
       * forwarding).
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String key;

      /**
       * [Output Only] A warning data value corresponding to the key.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String value;

      /**
       * [Output Only] A key that provides more detail on the warning being returned. For example, for
       * warnings where there are no results in a list request for a particular zone, this key might be
       * scope and the key value might be the zone name. Other examples might be a key indicating a
       * deprecated resource and a suggested replacement, or a warning about invalid network settings
       * (for example, if an instance attempts to perform IP forwarding but is not enabled for IP
       * forwarding).
       * @return value or {@code null} for none
       */
      public java.lang.String getKey() {
        return key;
      }

      /**
       * [Output Only] A key that provides more detail on the warning being returned. For example, for
       * warnings where there are no results in a list request for a particular zone, this key might be
       * scope and the key value might be the zone name. Other examples might be a key indicating a
       * deprecated resource and a suggested replacement, or a warning about invalid network settings
       * (for example, if an instance attempts to perform IP forwarding but is not enabled for IP
       * forwarding).
       * @param key key or {@code null} for none
       */
      public Data setKey(java.lang.String key) {
        this.key = key;
        return this;
      }

      /**
       * [Output Only] A warning data value corresponding to the key.
       * @return value or {@code null} for none
       */
      public java.lang.String getValue() {
        return value;
      }

      /**
       * [Output Only] A warning data value corresponding to the key.
       * @param value value or {@code null} for none
       */
      public Data setValue(java.lang.String value) {
        this.value = value;
        return this;
      }

      @Override
      public Data set(String fieldName, Object value) {
        return (Data) super.set(fieldName, value);
      }

      @Override
      public Data clone() {
        return (Data) super.clone();
      }

    }
  }

}
