/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-06-12 at 19:31:30 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.deploymentmanager.model;

/**
 * A resource type supported by Deployment Manager.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Deployment Manager Alpha API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Type extends com.google.api.client.json.GenericJson {

  /**
   * Base Type (configurable service) that backs this Type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ConfigurableService configurableService;

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Output only. Unique identifier for the resource; defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * Output only. Timestamp when the type was created, in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String insertTime;

  /**
   * Map of labels; provided by the client when the resource is created or updated. Specifically:
   * Label keys must be between 1 and 63 characters long and must conform to the following regular
   * expression: [a-z]([-a-z0-9]*[a-z0-9])? Label values must be between 0 and 63 characters long
   * and must conform to the regular expression ([a-z]([-a-z0-9]*[a-z0-9])?)?
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TypeLabelEntry> labels;

  /**
   * Name of the type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. The Operation that most recently ran, or is currently running, on this type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Operation operation;

  /**
   * Output only. Self link for the type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Base Type (configurable service) that backs this Type.
   * @return value or {@code null} for none
   */
  public ConfigurableService getConfigurableService() {
    return configurableService;
  }

  /**
   * Base Type (configurable service) that backs this Type.
   * @param configurableService configurableService or {@code null} for none
   */
  public Type setConfigurableService(ConfigurableService configurableService) {
    this.configurableService = configurableService;
    return this;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @param description description or {@code null} for none
   */
  public Type setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Output only. Unique identifier for the resource; defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * Output only. Unique identifier for the resource; defined by the server.
   * @param id id or {@code null} for none
   */
  public Type setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * Output only. Timestamp when the type was created, in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getInsertTime() {
    return insertTime;
  }

  /**
   * Output only. Timestamp when the type was created, in RFC3339 text format.
   * @param insertTime insertTime or {@code null} for none
   */
  public Type setInsertTime(java.lang.String insertTime) {
    this.insertTime = insertTime;
    return this;
  }

  /**
   * Map of labels; provided by the client when the resource is created or updated. Specifically:
   * Label keys must be between 1 and 63 characters long and must conform to the following regular
   * expression: [a-z]([-a-z0-9]*[a-z0-9])? Label values must be between 0 and 63 characters long
   * and must conform to the regular expression ([a-z]([-a-z0-9]*[a-z0-9])?)?
   * @return value or {@code null} for none
   */
  public java.util.List<TypeLabelEntry> getLabels() {
    return labels;
  }

  /**
   * Map of labels; provided by the client when the resource is created or updated. Specifically:
   * Label keys must be between 1 and 63 characters long and must conform to the following regular
   * expression: [a-z]([-a-z0-9]*[a-z0-9])? Label values must be between 0 and 63 characters long
   * and must conform to the regular expression ([a-z]([-a-z0-9]*[a-z0-9])?)?
   * @param labels labels or {@code null} for none
   */
  public Type setLabels(java.util.List<TypeLabelEntry> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Name of the type.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the type.
   * @param name name or {@code null} for none
   */
  public Type setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Output only. The Operation that most recently ran, or is currently running, on this type.
   * @return value or {@code null} for none
   */
  public Operation getOperation() {
    return operation;
  }

  /**
   * Output only. The Operation that most recently ran, or is currently running, on this type.
   * @param operation operation or {@code null} for none
   */
  public Type setOperation(Operation operation) {
    this.operation = operation;
    return this;
  }

  /**
   * Output only. Self link for the type.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Output only. Self link for the type.
   * @param selfLink selfLink or {@code null} for none
   */
  public Type setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public Type set(String fieldName, Object value) {
    return (Type) super.set(fieldName, value);
  }

  @Override
  public Type clone() {
    return (Type) super.clone();
  }

}
