/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-06-12 at 19:31:30 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.deploymentmanager.model;

/**
 * A type provider that describes a service-backed Type.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Deployment Manager Alpha API. For a
 * detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TypeProvider extends com.google.api.client.json.GenericJson {

  /**
   * Allows resource handling overrides for specific collections
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CollectionOverride> collectionOverrides;

  static {
    // hack to force ProGuard to consider CollectionOverride used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(CollectionOverride.class);
  }

  /**
   * Credential used when interacting with this type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Credential credential;

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Descriptor Url for the this type provider.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String descriptorUrl;

  /**
   * Output only. Unique identifier for the resource; defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * Output only. Timestamp when the type provider was created, in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String insertTime;

  /**
   * Map of labels; provided by the client when the resource is created or updated. Specifically:
   * Label keys must be between 1 and 63 characters long and must conform to the following regular
   * expression: [a-z]([-a-z0-9]*[a-z0-9])? Label values must be between 0 and 63 characters long
   * and must conform to the regular expression ([a-z]([-a-z0-9]*[a-z0-9])?)?
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TypeProviderLabelEntry> labels;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. The Operation that most recently ran, or is currently running, on this type
   * provider.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Operation operation;

  /**
   * Options to apply when handling any resources in this service.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Options options;

  /**
   * Output only. Self link for the type provider.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Allows resource handling overrides for specific collections
   * @return value or {@code null} for none
   */
  public java.util.List<CollectionOverride> getCollectionOverrides() {
    return collectionOverrides;
  }

  /**
   * Allows resource handling overrides for specific collections
   * @param collectionOverrides collectionOverrides or {@code null} for none
   */
  public TypeProvider setCollectionOverrides(java.util.List<CollectionOverride> collectionOverrides) {
    this.collectionOverrides = collectionOverrides;
    return this;
  }

  /**
   * Credential used when interacting with this type.
   * @return value or {@code null} for none
   */
  public Credential getCredential() {
    return credential;
  }

  /**
   * Credential used when interacting with this type.
   * @param credential credential or {@code null} for none
   */
  public TypeProvider setCredential(Credential credential) {
    this.credential = credential;
    return this;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @param description description or {@code null} for none
   */
  public TypeProvider setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Descriptor Url for the this type provider.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescriptorUrl() {
    return descriptorUrl;
  }

  /**
   * Descriptor Url for the this type provider.
   * @param descriptorUrl descriptorUrl or {@code null} for none
   */
  public TypeProvider setDescriptorUrl(java.lang.String descriptorUrl) {
    this.descriptorUrl = descriptorUrl;
    return this;
  }

  /**
   * Output only. Unique identifier for the resource; defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * Output only. Unique identifier for the resource; defined by the server.
   * @param id id or {@code null} for none
   */
  public TypeProvider setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * Output only. Timestamp when the type provider was created, in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getInsertTime() {
    return insertTime;
  }

  /**
   * Output only. Timestamp when the type provider was created, in RFC3339 text format.
   * @param insertTime insertTime or {@code null} for none
   */
  public TypeProvider setInsertTime(java.lang.String insertTime) {
    this.insertTime = insertTime;
    return this;
  }

  /**
   * Map of labels; provided by the client when the resource is created or updated. Specifically:
   * Label keys must be between 1 and 63 characters long and must conform to the following regular
   * expression: [a-z]([-a-z0-9]*[a-z0-9])? Label values must be between 0 and 63 characters long
   * and must conform to the regular expression ([a-z]([-a-z0-9]*[a-z0-9])?)?
   * @return value or {@code null} for none
   */
  public java.util.List<TypeProviderLabelEntry> getLabels() {
    return labels;
  }

  /**
   * Map of labels; provided by the client when the resource is created or updated. Specifically:
   * Label keys must be between 1 and 63 characters long and must conform to the following regular
   * expression: [a-z]([-a-z0-9]*[a-z0-9])? Label values must be between 0 and 63 characters long
   * and must conform to the regular expression ([a-z]([-a-z0-9]*[a-z0-9])?)?
   * @param labels labels or {@code null} for none
   */
  public TypeProvider setLabels(java.util.List<TypeProviderLabelEntry> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public TypeProvider setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Output only. The Operation that most recently ran, or is currently running, on this type
   * provider.
   * @return value or {@code null} for none
   */
  public Operation getOperation() {
    return operation;
  }

  /**
   * Output only. The Operation that most recently ran, or is currently running, on this type
   * provider.
   * @param operation operation or {@code null} for none
   */
  public TypeProvider setOperation(Operation operation) {
    this.operation = operation;
    return this;
  }

  /**
   * Options to apply when handling any resources in this service.
   * @return value or {@code null} for none
   */
  public Options getOptions() {
    return options;
  }

  /**
   * Options to apply when handling any resources in this service.
   * @param options options or {@code null} for none
   */
  public TypeProvider setOptions(Options options) {
    this.options = options;
    return this;
  }

  /**
   * Output only. Self link for the type provider.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Output only. Self link for the type provider.
   * @param selfLink selfLink or {@code null} for none
   */
  public TypeProvider setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public TypeProvider set(String fieldName, Object value) {
    return (TypeProvider) super.set(fieldName, value);
  }

  @Override
  public TypeProvider clone() {
    return (TypeProvider) super.clone();
  }

}
