/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.deploymentmanager;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.deploymentmanager.DeploymentManagerRequest;
import com.google.api.services.deploymentmanager.DeploymentManagerRequestInitializer;
import com.google.api.services.deploymentmanager.model.Deployment;
import com.google.api.services.deploymentmanager.model.DeploymentsCancelPreviewRequest;
import com.google.api.services.deploymentmanager.model.DeploymentsListResponse;
import com.google.api.services.deploymentmanager.model.DeploymentsStopRequest;
import com.google.api.services.deploymentmanager.model.GlobalSetPolicyRequest;
import com.google.api.services.deploymentmanager.model.Manifest;
import com.google.api.services.deploymentmanager.model.ManifestsListResponse;
import com.google.api.services.deploymentmanager.model.Operation;
import com.google.api.services.deploymentmanager.model.OperationsListResponse;
import com.google.api.services.deploymentmanager.model.Policy;
import com.google.api.services.deploymentmanager.model.Resource;
import com.google.api.services.deploymentmanager.model.ResourcesListResponse;
import com.google.api.services.deploymentmanager.model.TestPermissionsRequest;
import com.google.api.services.deploymentmanager.model.TestPermissionsResponse;
import com.google.api.services.deploymentmanager.model.TypesListResponse;
import java.io.IOException;
import java.util.regex.Pattern;

public class DeploymentManager
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "deploymentmanager/v2/projects/";
    public static final String DEFAULT_BATCH_PATH = "batch/deploymentmanager/v2";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/deploymentmanager/v2/projects/";

    public DeploymentManager(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    DeploymentManager(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Deployments deployments() {
        return new Deployments();
    }

    public Manifests manifests() {
        return new Manifests();
    }

    public Operations operations() {
        return new Operations();
    }

    public Resources resources() {
        return new Resources();
    }

    public Types types() {
        return new Types();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.29.2 of the Google Cloud Deployment Manager API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, DeploymentManager.DEFAULT_ROOT_URL, DeploymentManager.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(DeploymentManager.DEFAULT_BATCH_PATH);
        }

        public DeploymentManager build() {
            return new DeploymentManager(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setDeploymentManagerRequestInitializer(DeploymentManagerRequestInitializer deploymentmanagerRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)deploymentmanagerRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Types {
        public List list(String project) throws IOException {
            List result = new List(project);
            DeploymentManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DeploymentManagerRequest<TypesListResponse> {
            private static final String REST_PATH = "{project}/global/types";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;

            protected List(String project) {
                super(DeploymentManager.this, "GET", REST_PATH, null, TypesListResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Resources {
        public Get get(String project, String deployment, String resource) throws IOException {
            Get result = new Get(project, deployment, resource);
            DeploymentManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project, String deployment) throws IOException {
            List result = new List(project, deployment);
            DeploymentManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DeploymentManagerRequest<ResourcesListResponse> {
            private static final String REST_PATH = "{project}/global/deployments/{deployment}/resources";
            private final Pattern PROJECT_PATTERN;
            private final Pattern DEPLOYMENT_PATTERN;
            @Key
            private String project;
            @Key
            private String deployment;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;

            protected List(String project, String deployment) {
                super(DeploymentManager.this, "GET", REST_PATH, null, ResourcesListResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.DEPLOYMENT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.deployment = (String)Preconditions.checkNotNull((Object)deployment, (Object)"Required parameter deployment must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(deployment).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getDeployment() {
                return this.deployment;
            }

            public List setDeployment(String deployment) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(deployment).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.deployment = deployment;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DeploymentManagerRequest<Resource> {
            private static final String REST_PATH = "{project}/global/deployments/{deployment}/resources/{resource}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern DEPLOYMENT_PATTERN;
            @Key
            private String project;
            @Key
            private String deployment;
            @Key
            private String resource;

            protected Get(String project, String deployment, String resource) {
                super(DeploymentManager.this, "GET", REST_PATH, null, Resource.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.DEPLOYMENT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.deployment = (String)Preconditions.checkNotNull((Object)deployment, (Object)"Required parameter deployment must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(deployment).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getDeployment() {
                return this.deployment;
            }

            public Get setDeployment(String deployment) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(deployment).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.deployment = deployment;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public Get setResource(String resource) {
                this.resource = resource;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Operations {
        public Get get(String project, String operation) throws IOException {
            Get result = new Get(project, operation);
            DeploymentManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project) throws IOException {
            List result = new List(project);
            DeploymentManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DeploymentManagerRequest<OperationsListResponse> {
            private static final String REST_PATH = "{project}/global/operations";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;

            protected List(String project) {
                super(DeploymentManager.this, "GET", REST_PATH, null, OperationsListResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DeploymentManagerRequest<Operation> {
            private static final String REST_PATH = "{project}/global/operations/{operation}";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String operation;

            protected Get(String project, String operation) {
                super(DeploymentManager.this, "GET", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.operation = (String)Preconditions.checkNotNull((Object)operation, (Object)"Required parameter operation must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Get setOperation(String operation) {
                this.operation = operation;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Manifests {
        public Get get(String project, String deployment, String manifest) throws IOException {
            Get result = new Get(project, deployment, manifest);
            DeploymentManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project, String deployment) throws IOException {
            List result = new List(project, deployment);
            DeploymentManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends DeploymentManagerRequest<ManifestsListResponse> {
            private static final String REST_PATH = "{project}/global/deployments/{deployment}/manifests";
            private final Pattern PROJECT_PATTERN;
            private final Pattern DEPLOYMENT_PATTERN;
            @Key
            private String project;
            @Key
            private String deployment;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;

            protected List(String project, String deployment) {
                super(DeploymentManager.this, "GET", REST_PATH, null, ManifestsListResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.DEPLOYMENT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.deployment = (String)Preconditions.checkNotNull((Object)deployment, (Object)"Required parameter deployment must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(deployment).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getDeployment() {
                return this.deployment;
            }

            public List setDeployment(String deployment) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(deployment).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.deployment = deployment;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends DeploymentManagerRequest<Manifest> {
            private static final String REST_PATH = "{project}/global/deployments/{deployment}/manifests/{manifest}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern DEPLOYMENT_PATTERN;
            private final Pattern MANIFEST_PATTERN;
            @Key
            private String project;
            @Key
            private String deployment;
            @Key
            private String manifest;

            protected Get(String project, String deployment, String manifest) {
                super(DeploymentManager.this, "GET", REST_PATH, null, Manifest.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.DEPLOYMENT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.MANIFEST_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.deployment = (String)Preconditions.checkNotNull((Object)deployment, (Object)"Required parameter deployment must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(deployment).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.manifest = (String)Preconditions.checkNotNull((Object)manifest, (Object)"Required parameter manifest must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MANIFEST_PATTERN.matcher(manifest).matches(), (Object)"Parameter manifest must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getDeployment() {
                return this.deployment;
            }

            public Get setDeployment(String deployment) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(deployment).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.deployment = deployment;
                return this;
            }

            public String getManifest() {
                return this.manifest;
            }

            public Get setManifest(String manifest) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MANIFEST_PATTERN.matcher(manifest).matches(), (Object)"Parameter manifest must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.manifest = manifest;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Deployments {
        public CancelPreview cancelPreview(String project, String deployment, DeploymentsCancelPreviewRequest content) throws IOException {
            CancelPreview result = new CancelPreview(project, deployment, content);
            DeploymentManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String project, String deployment) throws IOException {
            Delete result = new Delete(project, deployment);
            DeploymentManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String deployment) throws IOException {
            Get result = new Get(project, deployment);
            DeploymentManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetIamPolicy getIamPolicy(String project, String resource) throws IOException {
            GetIamPolicy result = new GetIamPolicy(project, resource);
            DeploymentManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, Deployment content) throws IOException {
            Insert result = new Insert(project, content);
            DeploymentManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project) throws IOException {
            List result = new List(project);
            DeploymentManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String project, String deployment, Deployment content) throws IOException {
            Patch result = new Patch(project, deployment, content);
            DeploymentManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetIamPolicy setIamPolicy(String project, String resource, GlobalSetPolicyRequest content) throws IOException {
            SetIamPolicy result = new SetIamPolicy(project, resource, content);
            DeploymentManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Stop stop(String project, String deployment, DeploymentsStopRequest content) throws IOException {
            Stop result = new Stop(project, deployment, content);
            DeploymentManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String project, String resource, TestPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(project, resource, content);
            DeploymentManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String project, String deployment, Deployment content) throws IOException {
            Update result = new Update(project, deployment, content);
            DeploymentManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends DeploymentManagerRequest<Operation> {
            private static final String REST_PATH = "{project}/global/deployments/{deployment}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern DEPLOYMENT_PATTERN;
            @Key
            private String project;
            @Key
            private String deployment;
            @Key
            private String createPolicy;
            @Key
            private String deletePolicy;
            @Key
            private Boolean preview;

            protected Update(String project, String deployment, Deployment content) {
                super(DeploymentManager.this, "PUT", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.DEPLOYMENT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.deployment = (String)Preconditions.checkNotNull((Object)deployment, (Object)"Required parameter deployment must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(deployment).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String project) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getDeployment() {
                return this.deployment;
            }

            public Update setDeployment(String deployment) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(deployment).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.deployment = deployment;
                return this;
            }

            public String getCreatePolicy() {
                return this.createPolicy;
            }

            public Update setCreatePolicy(String createPolicy) {
                this.createPolicy = createPolicy;
                return this;
            }

            public String getDeletePolicy() {
                return this.deletePolicy;
            }

            public Update setDeletePolicy(String deletePolicy) {
                this.deletePolicy = deletePolicy;
                return this;
            }

            public Boolean getPreview() {
                return this.preview;
            }

            public Update setPreview(Boolean preview) {
                this.preview = preview;
                return this;
            }

            public boolean isPreview() {
                if (this.preview == null || this.preview == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.preview;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class TestIamPermissions
        extends DeploymentManagerRequest<TestPermissionsResponse> {
            private static final String REST_PATH = "{project}/global/deployments/{resource}/testIamPermissions";
            private final Pattern PROJECT_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String resource;

            protected TestIamPermissions(String project, String resource, TestPermissionsRequest content) {
                super(DeploymentManager.this, "POST", REST_PATH, (Object)content, TestPermissionsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUserIp(String userIp) {
                return (TestIamPermissions)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public TestIamPermissions setProject(String project) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class Stop
        extends DeploymentManagerRequest<Operation> {
            private static final String REST_PATH = "{project}/global/deployments/{deployment}/stop";
            private final Pattern PROJECT_PATTERN;
            private final Pattern DEPLOYMENT_PATTERN;
            @Key
            private String project;
            @Key
            private String deployment;

            protected Stop(String project, String deployment, DeploymentsStopRequest content) {
                super(DeploymentManager.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.DEPLOYMENT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.deployment = (String)Preconditions.checkNotNull((Object)deployment, (Object)"Required parameter deployment must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(deployment).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Stop setAlt(String alt) {
                return (Stop)super.setAlt(alt);
            }

            public Stop setFields(String fields) {
                return (Stop)super.setFields(fields);
            }

            public Stop setKey(String key) {
                return (Stop)super.setKey(key);
            }

            public Stop setOauthToken(String oauthToken) {
                return (Stop)super.setOauthToken(oauthToken);
            }

            public Stop setPrettyPrint(Boolean prettyPrint) {
                return (Stop)super.setPrettyPrint(prettyPrint);
            }

            public Stop setQuotaUser(String quotaUser) {
                return (Stop)super.setQuotaUser(quotaUser);
            }

            public Stop setUserIp(String userIp) {
                return (Stop)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Stop setProject(String project) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getDeployment() {
                return this.deployment;
            }

            public Stop setDeployment(String deployment) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(deployment).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.deployment = deployment;
                return this;
            }

            @Override
            public Stop set(String parameterName, Object value) {
                return (Stop)super.set(parameterName, value);
            }
        }

        public class SetIamPolicy
        extends DeploymentManagerRequest<Policy> {
            private static final String REST_PATH = "{project}/global/deployments/{resource}/setIamPolicy";
            private final Pattern PROJECT_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String resource;

            protected SetIamPolicy(String project, String resource, GlobalSetPolicyRequest content) {
                super(DeploymentManager.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public SetIamPolicy setAlt(String alt) {
                return (SetIamPolicy)super.setAlt(alt);
            }

            public SetIamPolicy setFields(String fields) {
                return (SetIamPolicy)super.setFields(fields);
            }

            public SetIamPolicy setKey(String key) {
                return (SetIamPolicy)super.setKey(key);
            }

            public SetIamPolicy setOauthToken(String oauthToken) {
                return (SetIamPolicy)super.setOauthToken(oauthToken);
            }

            public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public SetIamPolicy setQuotaUser(String quotaUser) {
                return (SetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public SetIamPolicy setUserIp(String userIp) {
                return (SetIamPolicy)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetIamPolicy setProject(String project) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public SetIamPolicy setResource(String resource) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public SetIamPolicy set(String parameterName, Object value) {
                return (SetIamPolicy)super.set(parameterName, value);
            }
        }

        public class Patch
        extends DeploymentManagerRequest<Operation> {
            private static final String REST_PATH = "{project}/global/deployments/{deployment}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern DEPLOYMENT_PATTERN;
            @Key
            private String project;
            @Key
            private String deployment;
            @Key
            private String createPolicy;
            @Key
            private String deletePolicy;
            @Key
            private Boolean preview;

            protected Patch(String project, String deployment, Deployment content) {
                super(DeploymentManager.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.DEPLOYMENT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.deployment = (String)Preconditions.checkNotNull((Object)deployment, (Object)"Required parameter deployment must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(deployment).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String project) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getDeployment() {
                return this.deployment;
            }

            public Patch setDeployment(String deployment) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(deployment).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.deployment = deployment;
                return this;
            }

            public String getCreatePolicy() {
                return this.createPolicy;
            }

            public Patch setCreatePolicy(String createPolicy) {
                this.createPolicy = createPolicy;
                return this;
            }

            public String getDeletePolicy() {
                return this.deletePolicy;
            }

            public Patch setDeletePolicy(String deletePolicy) {
                this.deletePolicy = deletePolicy;
                return this;
            }

            public Boolean getPreview() {
                return this.preview;
            }

            public Patch setPreview(Boolean preview) {
                this.preview = preview;
                return this;
            }

            public boolean isPreview() {
                if (this.preview == null || this.preview == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.preview;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends DeploymentManagerRequest<DeploymentsListResponse> {
            private static final String REST_PATH = "{project}/global/deployments";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;

            protected List(String project) {
                super(DeploymentManager.this, "GET", REST_PATH, null, DeploymentsListResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends DeploymentManagerRequest<Operation> {
            private static final String REST_PATH = "{project}/global/deployments";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String createPolicy;
            @Key
            private Boolean preview;

            protected Insert(String project, Deployment content) {
                super(DeploymentManager.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getCreatePolicy() {
                return this.createPolicy;
            }

            public Insert setCreatePolicy(String createPolicy) {
                this.createPolicy = createPolicy;
                return this;
            }

            public Boolean getPreview() {
                return this.preview;
            }

            public Insert setPreview(Boolean preview) {
                this.preview = preview;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class GetIamPolicy
        extends DeploymentManagerRequest<Policy> {
            private static final String REST_PATH = "{project}/global/deployments/{resource}/getIamPolicy";
            private final Pattern PROJECT_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String resource;

            protected GetIamPolicy(String project, String resource) {
                super(DeploymentManager.this, "GET", REST_PATH, null, Policy.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetIamPolicy setAlt(String alt) {
                return (GetIamPolicy)super.setAlt(alt);
            }

            public GetIamPolicy setFields(String fields) {
                return (GetIamPolicy)super.setFields(fields);
            }

            public GetIamPolicy setKey(String key) {
                return (GetIamPolicy)super.setKey(key);
            }

            public GetIamPolicy setOauthToken(String oauthToken) {
                return (GetIamPolicy)super.setOauthToken(oauthToken);
            }

            public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public GetIamPolicy setQuotaUser(String quotaUser) {
                return (GetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public GetIamPolicy setUserIp(String userIp) {
                return (GetIamPolicy)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public GetIamPolicy setProject(String project) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String resource) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public GetIamPolicy set(String parameterName, Object value) {
                return (GetIamPolicy)super.set(parameterName, value);
            }
        }

        public class Get
        extends DeploymentManagerRequest<Deployment> {
            private static final String REST_PATH = "{project}/global/deployments/{deployment}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern DEPLOYMENT_PATTERN;
            @Key
            private String project;
            @Key
            private String deployment;

            protected Get(String project, String deployment) {
                super(DeploymentManager.this, "GET", REST_PATH, null, Deployment.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.DEPLOYMENT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.deployment = (String)Preconditions.checkNotNull((Object)deployment, (Object)"Required parameter deployment must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(deployment).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getDeployment() {
                return this.deployment;
            }

            public Get setDeployment(String deployment) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(deployment).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.deployment = deployment;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends DeploymentManagerRequest<Operation> {
            private static final String REST_PATH = "{project}/global/deployments/{deployment}";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String deployment;
            @Key
            private String deletePolicy;

            protected Delete(String project, String deployment) {
                super(DeploymentManager.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.deployment = (String)Preconditions.checkNotNull((Object)deployment, (Object)"Required parameter deployment must be specified.");
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getDeployment() {
                return this.deployment;
            }

            public Delete setDeployment(String deployment) {
                this.deployment = deployment;
                return this;
            }

            public String getDeletePolicy() {
                return this.deletePolicy;
            }

            public Delete setDeletePolicy(String deletePolicy) {
                this.deletePolicy = deletePolicy;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class CancelPreview
        extends DeploymentManagerRequest<Operation> {
            private static final String REST_PATH = "{project}/global/deployments/{deployment}/cancelPreview";
            private final Pattern PROJECT_PATTERN;
            private final Pattern DEPLOYMENT_PATTERN;
            @Key
            private String project;
            @Key
            private String deployment;

            protected CancelPreview(String project, String deployment, DeploymentsCancelPreviewRequest content) {
                super(DeploymentManager.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.DEPLOYMENT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.deployment = (String)Preconditions.checkNotNull((Object)deployment, (Object)"Required parameter deployment must be specified.");
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(deployment).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public CancelPreview setAlt(String alt) {
                return (CancelPreview)super.setAlt(alt);
            }

            public CancelPreview setFields(String fields) {
                return (CancelPreview)super.setFields(fields);
            }

            public CancelPreview setKey(String key) {
                return (CancelPreview)super.setKey(key);
            }

            public CancelPreview setOauthToken(String oauthToken) {
                return (CancelPreview)super.setOauthToken(oauthToken);
            }

            public CancelPreview setPrettyPrint(Boolean prettyPrint) {
                return (CancelPreview)super.setPrettyPrint(prettyPrint);
            }

            public CancelPreview setQuotaUser(String quotaUser) {
                return (CancelPreview)super.setQuotaUser(quotaUser);
            }

            public CancelPreview setUserIp(String userIp) {
                return (CancelPreview)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public CancelPreview setProject(String project) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getDeployment() {
                return this.deployment;
            }

            public CancelPreview setDeployment(String deployment) {
                if (!DeploymentManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(deployment).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.deployment = deployment;
                return this;
            }

            @Override
            public CancelPreview set(String parameterName, Object value) {
                return (CancelPreview)super.set(parameterName, value);
            }
        }
    }
}

