/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-04-06 17:52:19 UTC)
 * on 2018-05-01 at 18:21:28 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.deploymentmanager.model;

/**
 * Async options that determine when a resource should finish.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Deployment Manager API V2Beta Methods.
 * For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AsyncOptions extends com.google.api.client.json.GenericJson {

  /**
   * Method regex where this policy will apply.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String methodMatch;

  /**
   * Deployment manager will poll instances for this API resource setting a RUNNING state, and
   * blocking until polling conditions tell whether the resource is completed or failed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PollingOptions pollingOptions;

  /**
   * Method regex where this policy will apply.
   * @return value or {@code null} for none
   */
  public java.lang.String getMethodMatch() {
    return methodMatch;
  }

  /**
   * Method regex where this policy will apply.
   * @param methodMatch methodMatch or {@code null} for none
   */
  public AsyncOptions setMethodMatch(java.lang.String methodMatch) {
    this.methodMatch = methodMatch;
    return this;
  }

  /**
   * Deployment manager will poll instances for this API resource setting a RUNNING state, and
   * blocking until polling conditions tell whether the resource is completed or failed.
   * @return value or {@code null} for none
   */
  public PollingOptions getPollingOptions() {
    return pollingOptions;
  }

  /**
   * Deployment manager will poll instances for this API resource setting a RUNNING state, and
   * blocking until polling conditions tell whether the resource is completed or failed.
   * @param pollingOptions pollingOptions or {@code null} for none
   */
  public AsyncOptions setPollingOptions(PollingOptions pollingOptions) {
    this.pollingOptions = pollingOptions;
    return this;
  }

  @Override
  public AsyncOptions set(String fieldName, Object value) {
    return (AsyncOptions) super.set(fieldName, value);
  }

  @Override
  public AsyncOptions clone() {
    return (AsyncOptions) super.clone();
  }

}
