/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.deploymentmanager;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.deploymentmanager.DeploymentManagerV2BetaRequest;
import com.google.api.services.deploymentmanager.DeploymentManagerV2BetaRequestInitializer;
import com.google.api.services.deploymentmanager.model.CompositeType;
import com.google.api.services.deploymentmanager.model.CompositeTypesListResponse;
import com.google.api.services.deploymentmanager.model.Deployment;
import com.google.api.services.deploymentmanager.model.DeploymentsCancelPreviewRequest;
import com.google.api.services.deploymentmanager.model.DeploymentsListResponse;
import com.google.api.services.deploymentmanager.model.DeploymentsStopRequest;
import com.google.api.services.deploymentmanager.model.GlobalSetPolicyRequest;
import com.google.api.services.deploymentmanager.model.Manifest;
import com.google.api.services.deploymentmanager.model.ManifestsListResponse;
import com.google.api.services.deploymentmanager.model.Operation;
import com.google.api.services.deploymentmanager.model.OperationsListResponse;
import com.google.api.services.deploymentmanager.model.Policy;
import com.google.api.services.deploymentmanager.model.Resource;
import com.google.api.services.deploymentmanager.model.ResourcesListResponse;
import com.google.api.services.deploymentmanager.model.TestPermissionsRequest;
import com.google.api.services.deploymentmanager.model.TestPermissionsResponse;
import com.google.api.services.deploymentmanager.model.TypeInfo;
import com.google.api.services.deploymentmanager.model.TypeProvider;
import com.google.api.services.deploymentmanager.model.TypeProvidersListResponse;
import com.google.api.services.deploymentmanager.model.TypeProvidersListTypesResponse;
import com.google.api.services.deploymentmanager.model.TypesListResponse;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentManagerV2Beta
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "deploymentmanager/v2beta/projects/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/deploymentmanager/v2beta/projects/";

    public DeploymentManagerV2Beta(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    DeploymentManagerV2Beta(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public CompositeTypes compositeTypes() {
        return new CompositeTypes();
    }

    public Deployments deployments() {
        return new Deployments();
    }

    public Manifests manifests() {
        return new Manifests();
    }

    public Operations operations() {
        return new Operations();
    }

    public Resources resources() {
        return new Resources();
    }

    public TypeProviders typeProviders() {
        return new TypeProviders();
    }

    public Types types() {
        return new Types();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.22.0 of the Google Cloud Deployment Manager API V2Beta Methods library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, DeploymentManagerV2Beta.DEFAULT_ROOT_URL, DeploymentManagerV2Beta.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public DeploymentManagerV2Beta build() {
            return new DeploymentManagerV2Beta(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setDeploymentManagerV2BetaRequestInitializer(DeploymentManagerV2BetaRequestInitializer deploymentManagerV2BetaRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)deploymentManagerV2BetaRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Types {
        public List list(String string) throws IOException {
            List list = new List(string);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DeploymentManagerV2BetaRequest<TypesListResponse> {
            private static final String REST_PATH = "{project}/global/types";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;

            protected List(String string) {
                super(DeploymentManagerV2Beta.this, "GET", REST_PATH, null, TypesListResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class TypeProviders {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetType getType(String string, String string2, String string3) throws IOException {
            GetType getType = new GetType(string, string2, string3);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)getType);
            return getType;
        }

        public Insert insert(String string, TypeProvider typeProvider) throws IOException {
            Insert insert = new Insert(string, typeProvider);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public ListTypes listTypes(String string, String string2) throws IOException {
            ListTypes listTypes = new ListTypes(string, string2);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)listTypes);
            return listTypes;
        }

        public Patch patch(String string, String string2, TypeProvider typeProvider) throws IOException {
            Patch patch = new Patch(string, string2, typeProvider);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, TypeProvider typeProvider) throws IOException {
            Update update = new Update(string, string2, typeProvider);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DeploymentManagerV2BetaRequest<Operation> {
            private static final String REST_PATH = "{project}/global/typeProviders/{typeProvider}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TYPE_PROVIDER_PATTERN;
            @Key
            private String project;
            @Key
            private String typeProvider;

            protected Update(String string, String string2, TypeProvider typeProvider) {
                super(DeploymentManagerV2Beta.this, "PUT", REST_PATH, (Object)typeProvider, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TYPE_PROVIDER_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.typeProvider = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter typeProvider must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TYPE_PROVIDER_PATTERN.matcher(string2).matches(), (Object)"Parameter typeProvider must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getTypeProvider() {
                return this.typeProvider;
            }

            public Update setTypeProvider(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TYPE_PROVIDER_PATTERN.matcher(string).matches(), (Object)"Parameter typeProvider must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.typeProvider = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DeploymentManagerV2BetaRequest<Operation> {
            private static final String REST_PATH = "{project}/global/typeProviders/{typeProvider}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TYPE_PROVIDER_PATTERN;
            @Key
            private String project;
            @Key
            private String typeProvider;

            protected Patch(String string, String string2, TypeProvider typeProvider) {
                super(DeploymentManagerV2Beta.this, "PATCH", REST_PATH, (Object)typeProvider, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TYPE_PROVIDER_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.typeProvider = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter typeProvider must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TYPE_PROVIDER_PATTERN.matcher(string2).matches(), (Object)"Parameter typeProvider must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getTypeProvider() {
                return this.typeProvider;
            }

            public Patch setTypeProvider(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TYPE_PROVIDER_PATTERN.matcher(string).matches(), (Object)"Parameter typeProvider must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.typeProvider = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ListTypes
        extends DeploymentManagerV2BetaRequest<TypeProvidersListTypesResponse> {
            private static final String REST_PATH = "{project}/global/typeProviders/{typeProvider}/types";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TYPE_PROVIDER_PATTERN;
            @Key
            private String project;
            @Key
            private String typeProvider;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;

            protected ListTypes(String string, String string2) {
                super(DeploymentManagerV2Beta.this, "GET", REST_PATH, null, TypeProvidersListTypesResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TYPE_PROVIDER_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.typeProvider = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter typeProvider must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TYPE_PROVIDER_PATTERN.matcher(string2).matches(), (Object)"Parameter typeProvider must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListTypes setAlt(String string) {
                return (ListTypes)super.setAlt(string);
            }

            public ListTypes setFields(String string) {
                return (ListTypes)super.setFields(string);
            }

            public ListTypes setKey(String string) {
                return (ListTypes)super.setKey(string);
            }

            public ListTypes setOauthToken(String string) {
                return (ListTypes)super.setOauthToken(string);
            }

            public ListTypes setPrettyPrint(Boolean bl) {
                return (ListTypes)super.setPrettyPrint(bl);
            }

            public ListTypes setQuotaUser(String string) {
                return (ListTypes)super.setQuotaUser(string);
            }

            public ListTypes setUserIp(String string) {
                return (ListTypes)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public ListTypes setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getTypeProvider() {
                return this.typeProvider;
            }

            public ListTypes setTypeProvider(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TYPE_PROVIDER_PATTERN.matcher(string).matches(), (Object)"Parameter typeProvider must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.typeProvider = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public ListTypes setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public ListTypes setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public ListTypes setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListTypes setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public ListTypes set(String string, Object object) {
                return (ListTypes)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DeploymentManagerV2BetaRequest<TypeProvidersListResponse> {
            private static final String REST_PATH = "{project}/global/typeProviders";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;

            protected List(String string) {
                super(DeploymentManagerV2Beta.this, "GET", REST_PATH, null, TypeProvidersListResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DeploymentManagerV2BetaRequest<Operation> {
            private static final String REST_PATH = "{project}/global/typeProviders";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, TypeProvider typeProvider) {
                super(DeploymentManagerV2Beta.this, "POST", REST_PATH, (Object)typeProvider, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetType
        extends DeploymentManagerV2BetaRequest<TypeInfo> {
            private static final String REST_PATH = "{project}/global/typeProviders/{typeProvider}/types/{type}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TYPE_PROVIDER_PATTERN;
            @Key
            private String project;
            @Key
            private String typeProvider;
            @Key
            private String type;

            protected GetType(String string, String string2, String string3) {
                super(DeploymentManagerV2Beta.this, "GET", REST_PATH, null, TypeInfo.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TYPE_PROVIDER_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.typeProvider = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter typeProvider must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TYPE_PROVIDER_PATTERN.matcher(string2).matches(), (Object)"Parameter typeProvider must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.type = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter type must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetType setAlt(String string) {
                return (GetType)super.setAlt(string);
            }

            public GetType setFields(String string) {
                return (GetType)super.setFields(string);
            }

            public GetType setKey(String string) {
                return (GetType)super.setKey(string);
            }

            public GetType setOauthToken(String string) {
                return (GetType)super.setOauthToken(string);
            }

            public GetType setPrettyPrint(Boolean bl) {
                return (GetType)super.setPrettyPrint(bl);
            }

            public GetType setQuotaUser(String string) {
                return (GetType)super.setQuotaUser(string);
            }

            public GetType setUserIp(String string) {
                return (GetType)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public GetType setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getTypeProvider() {
                return this.typeProvider;
            }

            public GetType setTypeProvider(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TYPE_PROVIDER_PATTERN.matcher(string).matches(), (Object)"Parameter typeProvider must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.typeProvider = string;
                return this;
            }

            public String getType() {
                return this.type;
            }

            public GetType setType(String string) {
                this.type = string;
                return this;
            }

            @Override
            public GetType set(String string, Object object) {
                return (GetType)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DeploymentManagerV2BetaRequest<TypeProvider> {
            private static final String REST_PATH = "{project}/global/typeProviders/{typeProvider}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TYPE_PROVIDER_PATTERN;
            @Key
            private String project;
            @Key
            private String typeProvider;

            protected Get(String string, String string2) {
                super(DeploymentManagerV2Beta.this, "GET", REST_PATH, null, TypeProvider.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TYPE_PROVIDER_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.typeProvider = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter typeProvider must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TYPE_PROVIDER_PATTERN.matcher(string2).matches(), (Object)"Parameter typeProvider must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getTypeProvider() {
                return this.typeProvider;
            }

            public Get setTypeProvider(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TYPE_PROVIDER_PATTERN.matcher(string).matches(), (Object)"Parameter typeProvider must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.typeProvider = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DeploymentManagerV2BetaRequest<Operation> {
            private static final String REST_PATH = "{project}/global/typeProviders/{typeProvider}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TYPE_PROVIDER_PATTERN;
            @Key
            private String project;
            @Key
            private String typeProvider;

            protected Delete(String string, String string2) {
                super(DeploymentManagerV2Beta.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TYPE_PROVIDER_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.typeProvider = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter typeProvider must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TYPE_PROVIDER_PATTERN.matcher(string2).matches(), (Object)"Parameter typeProvider must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getTypeProvider() {
                return this.typeProvider;
            }

            public Delete setTypeProvider(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TYPE_PROVIDER_PATTERN.matcher(string).matches(), (Object)"Parameter typeProvider must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.typeProvider = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Resources {
        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DeploymentManagerV2BetaRequest<ResourcesListResponse> {
            private static final String REST_PATH = "{project}/global/deployments/{deployment}/resources";
            private final Pattern PROJECT_PATTERN;
            private final Pattern DEPLOYMENT_PATTERN;
            @Key
            private String project;
            @Key
            private String deployment;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(DeploymentManagerV2Beta.this, "GET", REST_PATH, null, ResourcesListResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.DEPLOYMENT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.deployment = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter deployment must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(string2).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getDeployment() {
                return this.deployment;
            }

            public List setDeployment(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(string).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.deployment = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DeploymentManagerV2BetaRequest<Resource> {
            private static final String REST_PATH = "{project}/global/deployments/{deployment}/resources/{resource}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern DEPLOYMENT_PATTERN;
            @Key
            private String project;
            @Key
            private String deployment;
            @Key
            private String resource;

            protected Get(String string, String string2, String string3) {
                super(DeploymentManagerV2Beta.this, "GET", REST_PATH, null, Resource.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.DEPLOYMENT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.deployment = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter deployment must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(string2).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter resource must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getDeployment() {
                return this.deployment;
            }

            public Get setDeployment(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(string).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.deployment = string;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public Get setResource(String string) {
                this.resource = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Operations {
        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DeploymentManagerV2BetaRequest<OperationsListResponse> {
            private static final String REST_PATH = "{project}/global/operations";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;

            protected List(String string) {
                super(DeploymentManagerV2Beta.this, "GET", REST_PATH, null, OperationsListResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DeploymentManagerV2BetaRequest<Operation> {
            private static final String REST_PATH = "{project}/global/operations/{operation}";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String operation;

            protected Get(String string, String string2) {
                super(DeploymentManagerV2Beta.this, "GET", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.operation = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter operation must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Get setOperation(String string) {
                this.operation = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Manifests {
        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DeploymentManagerV2BetaRequest<ManifestsListResponse> {
            private static final String REST_PATH = "{project}/global/deployments/{deployment}/manifests";
            private final Pattern PROJECT_PATTERN;
            private final Pattern DEPLOYMENT_PATTERN;
            @Key
            private String project;
            @Key
            private String deployment;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;

            protected List(String string, String string2) {
                super(DeploymentManagerV2Beta.this, "GET", REST_PATH, null, ManifestsListResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.DEPLOYMENT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.deployment = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter deployment must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(string2).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getDeployment() {
                return this.deployment;
            }

            public List setDeployment(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(string).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.deployment = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DeploymentManagerV2BetaRequest<Manifest> {
            private static final String REST_PATH = "{project}/global/deployments/{deployment}/manifests/{manifest}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern DEPLOYMENT_PATTERN;
            private final Pattern MANIFEST_PATTERN;
            @Key
            private String project;
            @Key
            private String deployment;
            @Key
            private String manifest;

            protected Get(String string, String string2, String string3) {
                super(DeploymentManagerV2Beta.this, "GET", REST_PATH, null, Manifest.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.DEPLOYMENT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.MANIFEST_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.deployment = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter deployment must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(string2).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.manifest = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter manifest must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MANIFEST_PATTERN.matcher(string3).matches(), (Object)"Parameter manifest must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getDeployment() {
                return this.deployment;
            }

            public Get setDeployment(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(string).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.deployment = string;
                return this;
            }

            public String getManifest() {
                return this.manifest;
            }

            public Get setManifest(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MANIFEST_PATTERN.matcher(string).matches(), (Object)"Parameter manifest must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.manifest = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Deployments {
        public CancelPreview cancelPreview(String string, String string2, DeploymentsCancelPreviewRequest deploymentsCancelPreviewRequest) throws IOException {
            CancelPreview cancelPreview = new CancelPreview(string, string2, deploymentsCancelPreviewRequest);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)cancelPreview);
            return cancelPreview;
        }

        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetIamPolicy getIamPolicy(String string, String string2) throws IOException {
            GetIamPolicy getIamPolicy = new GetIamPolicy(string, string2);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
            return getIamPolicy;
        }

        public Insert insert(String string, Deployment deployment) throws IOException {
            Insert insert = new Insert(string, deployment);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, Deployment deployment) throws IOException {
            Patch patch = new Patch(string, string2, deployment);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public SetIamPolicy setIamPolicy(String string, String string2, GlobalSetPolicyRequest globalSetPolicyRequest) throws IOException {
            SetIamPolicy setIamPolicy = new SetIamPolicy(string, string2, globalSetPolicyRequest);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
            return setIamPolicy;
        }

        public Stop stop(String string, String string2, DeploymentsStopRequest deploymentsStopRequest) throws IOException {
            Stop stop = new Stop(string, string2, deploymentsStopRequest);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)stop);
            return stop;
        }

        public TestIamPermissions testIamPermissions(String string, String string2, TestPermissionsRequest testPermissionsRequest) throws IOException {
            TestIamPermissions testIamPermissions = new TestIamPermissions(string, string2, testPermissionsRequest);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
            return testIamPermissions;
        }

        public Update update(String string, String string2, Deployment deployment) throws IOException {
            Update update = new Update(string, string2, deployment);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DeploymentManagerV2BetaRequest<Operation> {
            private static final String REST_PATH = "{project}/global/deployments/{deployment}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern DEPLOYMENT_PATTERN;
            @Key
            private String project;
            @Key
            private String deployment;
            @Key
            private String createPolicy;
            @Key
            private String deletePolicy;
            @Key
            private Boolean preview;

            protected Update(String string, String string2, Deployment deployment) {
                super(DeploymentManagerV2Beta.this, "PUT", REST_PATH, (Object)deployment, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.DEPLOYMENT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.deployment = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter deployment must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(string2).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getDeployment() {
                return this.deployment;
            }

            public Update setDeployment(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(string).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.deployment = string;
                return this;
            }

            public String getCreatePolicy() {
                return this.createPolicy;
            }

            public Update setCreatePolicy(String string) {
                this.createPolicy = string;
                return this;
            }

            public String getDeletePolicy() {
                return this.deletePolicy;
            }

            public Update setDeletePolicy(String string) {
                this.deletePolicy = string;
                return this;
            }

            public Boolean getPreview() {
                return this.preview;
            }

            public Update setPreview(Boolean bl) {
                this.preview = bl;
                return this;
            }

            public boolean isPreview() {
                if (this.preview == null || this.preview == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.preview;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class TestIamPermissions
        extends DeploymentManagerV2BetaRequest<TestPermissionsResponse> {
            private static final String REST_PATH = "{project}/global/deployments/{resource}/testIamPermissions";
            private final Pattern PROJECT_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String resource;

            protected TestIamPermissions(String string, String string2, TestPermissionsRequest testPermissionsRequest) {
                super(DeploymentManagerV2Beta.this, "POST", REST_PATH, (Object)testPermissionsRequest, TestPermissionsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.RESOURCE_PATTERN = Pattern.compile("(?:[-a-z0-9_]{0,62}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter resource must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string2).matches(), (Object)"Parameter resource must conform to the pattern (?:[-a-z0-9_]{0,62}[a-z0-9])?");
                }
            }

            public TestIamPermissions setAlt(String string) {
                return (TestIamPermissions)super.setAlt(string);
            }

            public TestIamPermissions setFields(String string) {
                return (TestIamPermissions)super.setFields(string);
            }

            public TestIamPermissions setKey(String string) {
                return (TestIamPermissions)super.setKey(string);
            }

            public TestIamPermissions setOauthToken(String string) {
                return (TestIamPermissions)super.setOauthToken(string);
            }

            public TestIamPermissions setPrettyPrint(Boolean bl) {
                return (TestIamPermissions)super.setPrettyPrint(bl);
            }

            public TestIamPermissions setQuotaUser(String string) {
                return (TestIamPermissions)super.setQuotaUser(string);
            }

            public TestIamPermissions setUserIp(String string) {
                return (TestIamPermissions)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public TestIamPermissions setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern (?:[-a-z0-9_]{0,62}[a-z0-9])?");
                }
                this.resource = string;
                return this;
            }

            @Override
            public TestIamPermissions set(String string, Object object) {
                return (TestIamPermissions)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Stop
        extends DeploymentManagerV2BetaRequest<Operation> {
            private static final String REST_PATH = "{project}/global/deployments/{deployment}/stop";
            private final Pattern PROJECT_PATTERN;
            private final Pattern DEPLOYMENT_PATTERN;
            @Key
            private String project;
            @Key
            private String deployment;

            protected Stop(String string, String string2, DeploymentsStopRequest deploymentsStopRequest) {
                super(DeploymentManagerV2Beta.this, "POST", REST_PATH, (Object)deploymentsStopRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.DEPLOYMENT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.deployment = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter deployment must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(string2).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Stop setAlt(String string) {
                return (Stop)super.setAlt(string);
            }

            public Stop setFields(String string) {
                return (Stop)super.setFields(string);
            }

            public Stop setKey(String string) {
                return (Stop)super.setKey(string);
            }

            public Stop setOauthToken(String string) {
                return (Stop)super.setOauthToken(string);
            }

            public Stop setPrettyPrint(Boolean bl) {
                return (Stop)super.setPrettyPrint(bl);
            }

            public Stop setQuotaUser(String string) {
                return (Stop)super.setQuotaUser(string);
            }

            public Stop setUserIp(String string) {
                return (Stop)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Stop setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getDeployment() {
                return this.deployment;
            }

            public Stop setDeployment(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(string).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.deployment = string;
                return this;
            }

            @Override
            public Stop set(String string, Object object) {
                return (Stop)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetIamPolicy
        extends DeploymentManagerV2BetaRequest<Policy> {
            private static final String REST_PATH = "{project}/global/deployments/{resource}/setIamPolicy";
            private final Pattern PROJECT_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String resource;

            protected SetIamPolicy(String string, String string2, GlobalSetPolicyRequest globalSetPolicyRequest) {
                super(DeploymentManagerV2Beta.this, "POST", REST_PATH, (Object)globalSetPolicyRequest, Policy.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z0-9](?:[-a-z0-9_]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter resource must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string2).matches(), (Object)"Parameter resource must conform to the pattern [a-z0-9](?:[-a-z0-9_]{0,61}[a-z0-9])?");
                }
            }

            public SetIamPolicy setAlt(String string) {
                return (SetIamPolicy)super.setAlt(string);
            }

            public SetIamPolicy setFields(String string) {
                return (SetIamPolicy)super.setFields(string);
            }

            public SetIamPolicy setKey(String string) {
                return (SetIamPolicy)super.setKey(string);
            }

            public SetIamPolicy setOauthToken(String string) {
                return (SetIamPolicy)super.setOauthToken(string);
            }

            public SetIamPolicy setPrettyPrint(Boolean bl) {
                return (SetIamPolicy)super.setPrettyPrint(bl);
            }

            public SetIamPolicy setQuotaUser(String string) {
                return (SetIamPolicy)super.setQuotaUser(string);
            }

            public SetIamPolicy setUserIp(String string) {
                return (SetIamPolicy)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetIamPolicy setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public SetIamPolicy setResource(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern [a-z0-9](?:[-a-z0-9_]{0,61}[a-z0-9])?");
                }
                this.resource = string;
                return this;
            }

            @Override
            public SetIamPolicy set(String string, Object object) {
                return (SetIamPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DeploymentManagerV2BetaRequest<Operation> {
            private static final String REST_PATH = "{project}/global/deployments/{deployment}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern DEPLOYMENT_PATTERN;
            @Key
            private String project;
            @Key
            private String deployment;
            @Key
            private String createPolicy;
            @Key
            private String deletePolicy;
            @Key
            private Boolean preview;

            protected Patch(String string, String string2, Deployment deployment) {
                super(DeploymentManagerV2Beta.this, "PATCH", REST_PATH, (Object)deployment, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.DEPLOYMENT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.deployment = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter deployment must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(string2).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getDeployment() {
                return this.deployment;
            }

            public Patch setDeployment(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(string).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.deployment = string;
                return this;
            }

            public String getCreatePolicy() {
                return this.createPolicy;
            }

            public Patch setCreatePolicy(String string) {
                this.createPolicy = string;
                return this;
            }

            public String getDeletePolicy() {
                return this.deletePolicy;
            }

            public Patch setDeletePolicy(String string) {
                this.deletePolicy = string;
                return this;
            }

            public Boolean getPreview() {
                return this.preview;
            }

            public Patch setPreview(Boolean bl) {
                this.preview = bl;
                return this;
            }

            public boolean isPreview() {
                if (this.preview == null || this.preview == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.preview;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DeploymentManagerV2BetaRequest<DeploymentsListResponse> {
            private static final String REST_PATH = "{project}/global/deployments";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;

            protected List(String string) {
                super(DeploymentManagerV2Beta.this, "GET", REST_PATH, null, DeploymentsListResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DeploymentManagerV2BetaRequest<Operation> {
            private static final String REST_PATH = "{project}/global/deployments";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String createPolicy;
            @Key
            private Boolean preview;

            protected Insert(String string, Deployment deployment) {
                super(DeploymentManagerV2Beta.this, "POST", REST_PATH, (Object)deployment, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getCreatePolicy() {
                return this.createPolicy;
            }

            public Insert setCreatePolicy(String string) {
                this.createPolicy = string;
                return this;
            }

            public Boolean getPreview() {
                return this.preview;
            }

            public Insert setPreview(Boolean bl) {
                this.preview = bl;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetIamPolicy
        extends DeploymentManagerV2BetaRequest<Policy> {
            private static final String REST_PATH = "{project}/global/deployments/{resource}/getIamPolicy";
            private final Pattern PROJECT_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String resource;

            protected GetIamPolicy(String string, String string2) {
                super(DeploymentManagerV2Beta.this, "GET", REST_PATH, null, Policy.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z0-9](?:[-a-z0-9_]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter resource must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string2).matches(), (Object)"Parameter resource must conform to the pattern [a-z0-9](?:[-a-z0-9_]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetIamPolicy setAlt(String string) {
                return (GetIamPolicy)super.setAlt(string);
            }

            public GetIamPolicy setFields(String string) {
                return (GetIamPolicy)super.setFields(string);
            }

            public GetIamPolicy setKey(String string) {
                return (GetIamPolicy)super.setKey(string);
            }

            public GetIamPolicy setOauthToken(String string) {
                return (GetIamPolicy)super.setOauthToken(string);
            }

            public GetIamPolicy setPrettyPrint(Boolean bl) {
                return (GetIamPolicy)super.setPrettyPrint(bl);
            }

            public GetIamPolicy setQuotaUser(String string) {
                return (GetIamPolicy)super.setQuotaUser(string);
            }

            public GetIamPolicy setUserIp(String string) {
                return (GetIamPolicy)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public GetIamPolicy setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern [a-z0-9](?:[-a-z0-9_]{0,61}[a-z0-9])?");
                }
                this.resource = string;
                return this;
            }

            @Override
            public GetIamPolicy set(String string, Object object) {
                return (GetIamPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DeploymentManagerV2BetaRequest<Deployment> {
            private static final String REST_PATH = "{project}/global/deployments/{deployment}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern DEPLOYMENT_PATTERN;
            @Key
            private String project;
            @Key
            private String deployment;

            protected Get(String string, String string2) {
                super(DeploymentManagerV2Beta.this, "GET", REST_PATH, null, Deployment.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.DEPLOYMENT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.deployment = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter deployment must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(string2).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getDeployment() {
                return this.deployment;
            }

            public Get setDeployment(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(string).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.deployment = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DeploymentManagerV2BetaRequest<Operation> {
            private static final String REST_PATH = "{project}/global/deployments/{deployment}";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String deployment;
            @Key
            private String deletePolicy;

            protected Delete(String string, String string2) {
                super(DeploymentManagerV2Beta.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.deployment = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter deployment must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getDeployment() {
                return this.deployment;
            }

            public Delete setDeployment(String string) {
                this.deployment = string;
                return this;
            }

            public String getDeletePolicy() {
                return this.deletePolicy;
            }

            public Delete setDeletePolicy(String string) {
                this.deletePolicy = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class CancelPreview
        extends DeploymentManagerV2BetaRequest<Operation> {
            private static final String REST_PATH = "{project}/global/deployments/{deployment}/cancelPreview";
            private final Pattern PROJECT_PATTERN;
            private final Pattern DEPLOYMENT_PATTERN;
            @Key
            private String project;
            @Key
            private String deployment;

            protected CancelPreview(String string, String string2, DeploymentsCancelPreviewRequest deploymentsCancelPreviewRequest) {
                super(DeploymentManagerV2Beta.this, "POST", REST_PATH, (Object)deploymentsCancelPreviewRequest, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.DEPLOYMENT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.deployment = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter deployment must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(string2).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public CancelPreview setAlt(String string) {
                return (CancelPreview)super.setAlt(string);
            }

            public CancelPreview setFields(String string) {
                return (CancelPreview)super.setFields(string);
            }

            public CancelPreview setKey(String string) {
                return (CancelPreview)super.setKey(string);
            }

            public CancelPreview setOauthToken(String string) {
                return (CancelPreview)super.setOauthToken(string);
            }

            public CancelPreview setPrettyPrint(Boolean bl) {
                return (CancelPreview)super.setPrettyPrint(bl);
            }

            public CancelPreview setQuotaUser(String string) {
                return (CancelPreview)super.setQuotaUser(string);
            }

            public CancelPreview setUserIp(String string) {
                return (CancelPreview)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public CancelPreview setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getDeployment() {
                return this.deployment;
            }

            public CancelPreview setDeployment(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DEPLOYMENT_PATTERN.matcher(string).matches(), (Object)"Parameter deployment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.deployment = string;
                return this;
            }

            @Override
            public CancelPreview set(String string, Object object) {
                return (CancelPreview)super.set(string, object);
            }
        }
    }

    public class CompositeTypes {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, CompositeType compositeType) throws IOException {
            Insert insert = new Insert(string, compositeType);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, CompositeType compositeType) throws IOException {
            Patch patch = new Patch(string, string2, compositeType);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, CompositeType compositeType) throws IOException {
            Update update = new Update(string, string2, compositeType);
            DeploymentManagerV2Beta.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DeploymentManagerV2BetaRequest<Operation> {
            private static final String REST_PATH = "{project}/global/compositeTypes/{compositeType}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern COMPOSITE_TYPE_PATTERN;
            @Key
            private String project;
            @Key
            private String compositeType;

            protected Update(String string, String string2, CompositeType compositeType) {
                super(DeploymentManagerV2Beta.this, "PUT", REST_PATH, (Object)compositeType, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.COMPOSITE_TYPE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_.]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.compositeType = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter compositeType must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.COMPOSITE_TYPE_PATTERN.matcher(string2).matches(), (Object)"Parameter compositeType must conform to the pattern [a-z](?:[-a-z0-9_.]{0,61}[a-z0-9])?");
                }
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getCompositeType() {
                return this.compositeType;
            }

            public Update setCompositeType(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.COMPOSITE_TYPE_PATTERN.matcher(string).matches(), (Object)"Parameter compositeType must conform to the pattern [a-z](?:[-a-z0-9_.]{0,61}[a-z0-9])?");
                }
                this.compositeType = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DeploymentManagerV2BetaRequest<Operation> {
            private static final String REST_PATH = "{project}/global/compositeTypes/{compositeType}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern COMPOSITE_TYPE_PATTERN;
            @Key
            private String project;
            @Key
            private String compositeType;

            protected Patch(String string, String string2, CompositeType compositeType) {
                super(DeploymentManagerV2Beta.this, "PATCH", REST_PATH, (Object)compositeType, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.COMPOSITE_TYPE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_.]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.compositeType = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter compositeType must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.COMPOSITE_TYPE_PATTERN.matcher(string2).matches(), (Object)"Parameter compositeType must conform to the pattern [a-z](?:[-a-z0-9_.]{0,61}[a-z0-9])?");
                }
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getCompositeType() {
                return this.compositeType;
            }

            public Patch setCompositeType(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.COMPOSITE_TYPE_PATTERN.matcher(string).matches(), (Object)"Parameter compositeType must conform to the pattern [a-z](?:[-a-z0-9_.]{0,61}[a-z0-9])?");
                }
                this.compositeType = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DeploymentManagerV2BetaRequest<CompositeTypesListResponse> {
            private static final String REST_PATH = "{project}/global/compositeTypes";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;

            protected List(String string) {
                super(DeploymentManagerV2Beta.this, "GET", REST_PATH, null, CompositeTypesListResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DeploymentManagerV2BetaRequest<Operation> {
            private static final String REST_PATH = "{project}/global/compositeTypes";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, CompositeType compositeType) {
                super(DeploymentManagerV2Beta.this, "POST", REST_PATH, (Object)compositeType, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DeploymentManagerV2BetaRequest<CompositeType> {
            private static final String REST_PATH = "{project}/global/compositeTypes/{compositeType}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern COMPOSITE_TYPE_PATTERN;
            @Key
            private String project;
            @Key
            private String compositeType;

            protected Get(String string, String string2) {
                super(DeploymentManagerV2Beta.this, "GET", REST_PATH, null, CompositeType.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.COMPOSITE_TYPE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_.]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.compositeType = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter compositeType must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.COMPOSITE_TYPE_PATTERN.matcher(string2).matches(), (Object)"Parameter compositeType must conform to the pattern [a-z](?:[-a-z0-9_.]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getCompositeType() {
                return this.compositeType;
            }

            public Get setCompositeType(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.COMPOSITE_TYPE_PATTERN.matcher(string).matches(), (Object)"Parameter compositeType must conform to the pattern [a-z](?:[-a-z0-9_.]{0,61}[a-z0-9])?");
                }
                this.compositeType = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DeploymentManagerV2BetaRequest<Operation> {
            private static final String REST_PATH = "{project}/global/compositeTypes/{compositeType}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern COMPOSITE_TYPE_PATTERN;
            @Key
            private String project;
            @Key
            private String compositeType;

            protected Delete(String string, String string2) {
                super(DeploymentManagerV2Beta.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.COMPOSITE_TYPE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_.]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.compositeType = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter compositeType must be specified.");
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.COMPOSITE_TYPE_PATTERN.matcher(string2).matches(), (Object)"Parameter compositeType must conform to the pattern [a-z](?:[-a-z0-9_.]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getCompositeType() {
                return this.compositeType;
            }

            public Delete setCompositeType(String string) {
                if (!DeploymentManagerV2Beta.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.COMPOSITE_TYPE_PATTERN.matcher(string).matches(), (Object)"Parameter compositeType must conform to the pattern [a-z](?:[-a-z0-9_.]{0,61}[a-z0-9])?");
                }
                this.compositeType = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }
}

