/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-05-16 at 01:45:47 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.deploymentmanager.model;

/**
 * InputMapping creates a 'virtual' property that will be injected into the properties before
 * sending the request to the underlying API.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Deployment Manager API V2Beta Methods.
 * For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InputMapping extends com.google.api.client.json.GenericJson {

  /**
   * The name of the field that is going to be injected.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fieldName;

  /**
   * The location where this mapping applies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * Regex to evaluate on method to decide if input applies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String methodMatch;

  /**
   * A jsonPath expression to select an element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * The name of the field that is going to be injected.
   * @return value or {@code null} for none
   */
  public java.lang.String getFieldName() {
    return fieldName;
  }

  /**
   * The name of the field that is going to be injected.
   * @param fieldName fieldName or {@code null} for none
   */
  public InputMapping setFieldName(java.lang.String fieldName) {
    this.fieldName = fieldName;
    return this;
  }

  /**
   * The location where this mapping applies.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * The location where this mapping applies.
   * @param location location or {@code null} for none
   */
  public InputMapping setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * Regex to evaluate on method to decide if input applies.
   * @return value or {@code null} for none
   */
  public java.lang.String getMethodMatch() {
    return methodMatch;
  }

  /**
   * Regex to evaluate on method to decide if input applies.
   * @param methodMatch methodMatch or {@code null} for none
   */
  public InputMapping setMethodMatch(java.lang.String methodMatch) {
    this.methodMatch = methodMatch;
    return this;
  }

  /**
   * A jsonPath expression to select an element.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * A jsonPath expression to select an element.
   * @param value value or {@code null} for none
   */
  public InputMapping setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public InputMapping set(String fieldName, Object value) {
    return (InputMapping) super.set(fieldName, value);
  }

  @Override
  public InputMapping clone() {
    return (InputMapping) super.clone();
  }

}
