/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-07-06 at 16:46:25 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.deploymentmanager.model;

/**
 * Options for how to validate and process properties on a resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Deployment Manager API V2Beta Methods.
 * For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ValidationOptions extends com.google.api.client.json.GenericJson {

  /**
   * Customize how deployment manager will validate the resource against schema errors.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String schemaValidation;

  /**
   * Specify what to do with extra properties when executing a request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String undeclaredProperties;

  /**
   * Customize how deployment manager will validate the resource against schema errors.
   * @return value or {@code null} for none
   */
  public java.lang.String getSchemaValidation() {
    return schemaValidation;
  }

  /**
   * Customize how deployment manager will validate the resource against schema errors.
   * @param schemaValidation schemaValidation or {@code null} for none
   */
  public ValidationOptions setSchemaValidation(java.lang.String schemaValidation) {
    this.schemaValidation = schemaValidation;
    return this;
  }

  /**
   * Specify what to do with extra properties when executing a request.
   * @return value or {@code null} for none
   */
  public java.lang.String getUndeclaredProperties() {
    return undeclaredProperties;
  }

  /**
   * Specify what to do with extra properties when executing a request.
   * @param undeclaredProperties undeclaredProperties or {@code null} for none
   */
  public ValidationOptions setUndeclaredProperties(java.lang.String undeclaredProperties) {
    this.undeclaredProperties = undeclaredProperties;
    return this;
  }

  @Override
  public ValidationOptions set(String fieldName, Object value) {
    return (ValidationOptions) super.set(fieldName, value);
  }

  @Override
  public ValidationOptions clone() {
    return (ValidationOptions) super.clone();
  }

}
