/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Gets a summary of active ads in an account.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountActiveAdSummary extends com.google.api.client.json.GenericJson {

  /**
   * ID of the account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long accountId;

  /**
   * Ads that have been activated for the account
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long activeAds;

  /**
   * Maximum number of active ads allowed for the account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String activeAdsLimitTier;

  /**
   * Ads that can be activated for the account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long availableAds;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#accountActiveAdSummary".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * ID of the account.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAccountId() {
    return accountId;
  }

  /**
   * ID of the account.
   * @param accountId accountId or {@code null} for none
   */
  public AccountActiveAdSummary setAccountId(java.lang.Long accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Ads that have been activated for the account
   * @return value or {@code null} for none
   */
  public java.lang.Long getActiveAds() {
    return activeAds;
  }

  /**
   * Ads that have been activated for the account
   * @param activeAds activeAds or {@code null} for none
   */
  public AccountActiveAdSummary setActiveAds(java.lang.Long activeAds) {
    this.activeAds = activeAds;
    return this;
  }

  /**
   * Maximum number of active ads allowed for the account.
   * @return value or {@code null} for none
   */
  public java.lang.String getActiveAdsLimitTier() {
    return activeAdsLimitTier;
  }

  /**
   * Maximum number of active ads allowed for the account.
   * @param activeAdsLimitTier activeAdsLimitTier or {@code null} for none
   */
  public AccountActiveAdSummary setActiveAdsLimitTier(java.lang.String activeAdsLimitTier) {
    this.activeAdsLimitTier = activeAdsLimitTier;
    return this;
  }

  /**
   * Ads that can be activated for the account.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAvailableAds() {
    return availableAds;
  }

  /**
   * Ads that can be activated for the account.
   * @param availableAds availableAds or {@code null} for none
   */
  public AccountActiveAdSummary setAvailableAds(java.lang.Long availableAds) {
    this.availableAds = availableAds;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#accountActiveAdSummary".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#accountActiveAdSummary".
   * @param kind kind or {@code null} for none
   */
  public AccountActiveAdSummary setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public AccountActiveAdSummary set(String fieldName, Object value) {
    return (AccountActiveAdSummary) super.set(fieldName, value);
  }

  @Override
  public AccountActiveAdSummary clone() {
    return (AccountActiveAdSummary) super.clone();
  }

}
