/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * AccountPermissions contains information about a particular account permission. Some features of
 * Campaign Manager require an account permission to be present in the account.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountPermission extends com.google.api.client.json.GenericJson {

  /**
   * Account profiles associated with this account permission.
   *
   * Possible values are: - "ACCOUNT_PROFILE_BASIC" - "ACCOUNT_PROFILE_STANDARD"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> accountProfiles;

  /**
   * ID of this account permission.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#accountPermission".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Administrative level required to enable this account permission.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String level;

  /**
   * Name of this account permission.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Permission group of this account permission.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long permissionGroupId;

  /**
   * Account profiles associated with this account permission.
   *
   * Possible values are: - "ACCOUNT_PROFILE_BASIC" - "ACCOUNT_PROFILE_STANDARD"
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAccountProfiles() {
    return accountProfiles;
  }

  /**
   * Account profiles associated with this account permission.
   *
   * Possible values are: - "ACCOUNT_PROFILE_BASIC" - "ACCOUNT_PROFILE_STANDARD"
   * @param accountProfiles accountProfiles or {@code null} for none
   */
  public AccountPermission setAccountProfiles(java.util.List<java.lang.String> accountProfiles) {
    this.accountProfiles = accountProfiles;
    return this;
  }

  /**
   * ID of this account permission.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * ID of this account permission.
   * @param id id or {@code null} for none
   */
  public AccountPermission setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#accountPermission".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#accountPermission".
   * @param kind kind or {@code null} for none
   */
  public AccountPermission setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Administrative level required to enable this account permission.
   * @return value or {@code null} for none
   */
  public java.lang.String getLevel() {
    return level;
  }

  /**
   * Administrative level required to enable this account permission.
   * @param level level or {@code null} for none
   */
  public AccountPermission setLevel(java.lang.String level) {
    this.level = level;
    return this;
  }

  /**
   * Name of this account permission.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this account permission.
   * @param name name or {@code null} for none
   */
  public AccountPermission setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Permission group of this account permission.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPermissionGroupId() {
    return permissionGroupId;
  }

  /**
   * Permission group of this account permission.
   * @param permissionGroupId permissionGroupId or {@code null} for none
   */
  public AccountPermission setPermissionGroupId(java.lang.Long permissionGroupId) {
    this.permissionGroupId = permissionGroupId;
    return this;
  }

  @Override
  public AccountPermission set(String fieldName, Object value) {
    return (AccountPermission) super.set(fieldName, value);
  }

  @Override
  public AccountPermission clone() {
    return (AccountPermission) super.clone();
  }

}
