/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Campaign ad blocking settings.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AdBlockingConfiguration extends com.google.api.client.json.GenericJson {

  /**
   * Click-through URL used by brand-neutral ads. This is a required field when
   * overrideClickThroughUrl is set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String clickThroughUrl;

  /**
   * ID of a creative bundle to use for this campaign. If set, brand-neutral ads will select
   * creatives from this bundle. Otherwise, a default transparent pixel will be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long creativeBundleId;

  /**
   * Whether this campaign has enabled ad blocking. When true, ad blocking is enabled for placements
   * in the campaign, but this may be overridden by site and placement settings. When false, ad
   * blocking is disabled for all placements under the campaign, regardless of site and placement
   * settings.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enabled;

  /**
   * Whether the brand-neutral ad's click-through URL comes from the campaign's creative bundle or
   * the override URL. Must be set to true if ad blocking is enabled and no creative bundle is
   * configured.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean overrideClickThroughUrl;

  /**
   * Click-through URL used by brand-neutral ads. This is a required field when
   * overrideClickThroughUrl is set to true.
   * @return value or {@code null} for none
   */
  public java.lang.String getClickThroughUrl() {
    return clickThroughUrl;
  }

  /**
   * Click-through URL used by brand-neutral ads. This is a required field when
   * overrideClickThroughUrl is set to true.
   * @param clickThroughUrl clickThroughUrl or {@code null} for none
   */
  public AdBlockingConfiguration setClickThroughUrl(java.lang.String clickThroughUrl) {
    this.clickThroughUrl = clickThroughUrl;
    return this;
  }

  /**
   * ID of a creative bundle to use for this campaign. If set, brand-neutral ads will select
   * creatives from this bundle. Otherwise, a default transparent pixel will be used.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCreativeBundleId() {
    return creativeBundleId;
  }

  /**
   * ID of a creative bundle to use for this campaign. If set, brand-neutral ads will select
   * creatives from this bundle. Otherwise, a default transparent pixel will be used.
   * @param creativeBundleId creativeBundleId or {@code null} for none
   */
  public AdBlockingConfiguration setCreativeBundleId(java.lang.Long creativeBundleId) {
    this.creativeBundleId = creativeBundleId;
    return this;
  }

  /**
   * Whether this campaign has enabled ad blocking. When true, ad blocking is enabled for placements
   * in the campaign, but this may be overridden by site and placement settings. When false, ad
   * blocking is disabled for all placements under the campaign, regardless of site and placement
   * settings.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnabled() {
    return enabled;
  }

  /**
   * Whether this campaign has enabled ad blocking. When true, ad blocking is enabled for placements
   * in the campaign, but this may be overridden by site and placement settings. When false, ad
   * blocking is disabled for all placements under the campaign, regardless of site and placement
   * settings.
   * @param enabled enabled or {@code null} for none
   */
  public AdBlockingConfiguration setEnabled(java.lang.Boolean enabled) {
    this.enabled = enabled;
    return this;
  }

  /**
   * Whether the brand-neutral ad's click-through URL comes from the campaign's creative bundle or
   * the override URL. Must be set to true if ad blocking is enabled and no creative bundle is
   * configured.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getOverrideClickThroughUrl() {
    return overrideClickThroughUrl;
  }

  /**
   * Whether the brand-neutral ad's click-through URL comes from the campaign's creative bundle or
   * the override URL. Must be set to true if ad blocking is enabled and no creative bundle is
   * configured.
   * @param overrideClickThroughUrl overrideClickThroughUrl or {@code null} for none
   */
  public AdBlockingConfiguration setOverrideClickThroughUrl(java.lang.Boolean overrideClickThroughUrl) {
    this.overrideClickThroughUrl = overrideClickThroughUrl;
    return this;
  }

  @Override
  public AdBlockingConfiguration set(String fieldName, Object value) {
    return (AdBlockingConfiguration) super.set(fieldName, value);
  }

  @Override
  public AdBlockingConfiguration clone() {
    return (AdBlockingConfiguration) super.clone();
  }

}
