/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Groups advertisers together so that reports can be generated for the entire group at once.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AdvertiserGroup extends com.google.api.client.json.GenericJson {

  /**
   * Account ID of this advertiser group. This is a read-only field that can be left blank.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long accountId;

  /**
   * ID of this advertiser group. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#advertiserGroup".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of this advertiser group. This is a required field and must be less than 256 characters
   * long and unique among advertiser groups of the same account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Account ID of this advertiser group. This is a read-only field that can be left blank.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAccountId() {
    return accountId;
  }

  /**
   * Account ID of this advertiser group. This is a read-only field that can be left blank.
   * @param accountId accountId or {@code null} for none
   */
  public AdvertiserGroup setAccountId(java.lang.Long accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * ID of this advertiser group. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * ID of this advertiser group. This is a read-only, auto-generated field.
   * @param id id or {@code null} for none
   */
  public AdvertiserGroup setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#advertiserGroup".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#advertiserGroup".
   * @param kind kind or {@code null} for none
   */
  public AdvertiserGroup setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of this advertiser group. This is a required field and must be less than 256 characters
   * long and unique among advertiser groups of the same account.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this advertiser group. This is a required field and must be less than 256 characters
   * long and unique among advertiser groups of the same account.
   * @param name name or {@code null} for none
   */
  public AdvertiserGroup setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public AdvertiserGroup set(String fieldName, Object value) {
    return (AdvertiserGroup) super.set(fieldName, value);
  }

  @Override
  public AdvertiserGroup clone() {
    return (AdvertiserGroup) super.clone();
  }

}
