/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Audience Segment Group.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AudienceSegmentGroup extends com.google.api.client.json.GenericJson {

  /**
   * Audience segments assigned to this group. The number of segments must be between 2 and 100.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AudienceSegment> audienceSegments;

  static {
    // hack to force ProGuard to consider AudienceSegment used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AudienceSegment.class);
  }

  /**
   * ID of this audience segment group. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Name of this audience segment group. This is a required field and must be less than 65
   * characters long.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Audience segments assigned to this group. The number of segments must be between 2 and 100.
   * @return value or {@code null} for none
   */
  public java.util.List<AudienceSegment> getAudienceSegments() {
    return audienceSegments;
  }

  /**
   * Audience segments assigned to this group. The number of segments must be between 2 and 100.
   * @param audienceSegments audienceSegments or {@code null} for none
   */
  public AudienceSegmentGroup setAudienceSegments(java.util.List<AudienceSegment> audienceSegments) {
    this.audienceSegments = audienceSegments;
    return this;
  }

  /**
   * ID of this audience segment group. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * ID of this audience segment group. This is a read-only, auto-generated field.
   * @param id id or {@code null} for none
   */
  public AudienceSegmentGroup setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Name of this audience segment group. This is a required field and must be less than 65
   * characters long.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this audience segment group. This is a required field and must be less than 65
   * characters long.
   * @param name name or {@code null} for none
   */
  public AudienceSegmentGroup setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public AudienceSegmentGroup set(String fieldName, Object value) {
    return (AudienceSegmentGroup) super.set(fieldName, value);
  }

  @Override
  public AudienceSegmentGroup clone() {
    return (AudienceSegmentGroup) super.clone();
  }

}
