/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Describes a change that a user has made to a resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChangeLog extends com.google.api.client.json.GenericJson {

  /**
   * Account ID of the modified object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long accountId;

  /**
   * Action which caused the change.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String action;

  /**
   * Time when the object was modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime changeTime;

  /**
   * Field name of the object which changed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fieldName;

  /**
   * ID of this change log.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#changeLog".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * New value of the object field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String newValue;

  /**
   * ID of the object of this change log. The object could be a campaign, placement, ad, or other
   * type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long objectId;

  /**
   * Object type of the change log.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectType;

  /**
   * Old value of the object field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String oldValue;

  /**
   * Subaccount ID of the modified object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long subaccountId;

  /**
   * Transaction ID of this change log. When a single API call results in many changes, each change
   * will have a separate ID in the change log but will share the same transactionId.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long transactionId;

  /**
   * ID of the user who modified the object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long userProfileId;

  /**
   * User profile name of the user who modified the object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String userProfileName;

  /**
   * Account ID of the modified object.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAccountId() {
    return accountId;
  }

  /**
   * Account ID of the modified object.
   * @param accountId accountId or {@code null} for none
   */
  public ChangeLog setAccountId(java.lang.Long accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Action which caused the change.
   * @return value or {@code null} for none
   */
  public java.lang.String getAction() {
    return action;
  }

  /**
   * Action which caused the change.
   * @param action action or {@code null} for none
   */
  public ChangeLog setAction(java.lang.String action) {
    this.action = action;
    return this;
  }

  /**
   * Time when the object was modified.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getChangeTime() {
    return changeTime;
  }

  /**
   * Time when the object was modified.
   * @param changeTime changeTime or {@code null} for none
   */
  public ChangeLog setChangeTime(com.google.api.client.util.DateTime changeTime) {
    this.changeTime = changeTime;
    return this;
  }

  /**
   * Field name of the object which changed.
   * @return value or {@code null} for none
   */
  public java.lang.String getFieldName() {
    return fieldName;
  }

  /**
   * Field name of the object which changed.
   * @param fieldName fieldName or {@code null} for none
   */
  public ChangeLog setFieldName(java.lang.String fieldName) {
    this.fieldName = fieldName;
    return this;
  }

  /**
   * ID of this change log.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * ID of this change log.
   * @param id id or {@code null} for none
   */
  public ChangeLog setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#changeLog".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#changeLog".
   * @param kind kind or {@code null} for none
   */
  public ChangeLog setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * New value of the object field.
   * @return value or {@code null} for none
   */
  public java.lang.String getNewValue() {
    return newValue;
  }

  /**
   * New value of the object field.
   * @param newValue newValue or {@code null} for none
   */
  public ChangeLog setNewValue(java.lang.String newValue) {
    this.newValue = newValue;
    return this;
  }

  /**
   * ID of the object of this change log. The object could be a campaign, placement, ad, or other
   * type.
   * @return value or {@code null} for none
   */
  public java.lang.Long getObjectId() {
    return objectId;
  }

  /**
   * ID of the object of this change log. The object could be a campaign, placement, ad, or other
   * type.
   * @param objectId objectId or {@code null} for none
   */
  public ChangeLog setObjectId(java.lang.Long objectId) {
    this.objectId = objectId;
    return this;
  }

  /**
   * Object type of the change log.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectType() {
    return objectType;
  }

  /**
   * Object type of the change log.
   * @param objectType objectType or {@code null} for none
   */
  public ChangeLog setObjectType(java.lang.String objectType) {
    this.objectType = objectType;
    return this;
  }

  /**
   * Old value of the object field.
   * @return value or {@code null} for none
   */
  public java.lang.String getOldValue() {
    return oldValue;
  }

  /**
   * Old value of the object field.
   * @param oldValue oldValue or {@code null} for none
   */
  public ChangeLog setOldValue(java.lang.String oldValue) {
    this.oldValue = oldValue;
    return this;
  }

  /**
   * Subaccount ID of the modified object.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSubaccountId() {
    return subaccountId;
  }

  /**
   * Subaccount ID of the modified object.
   * @param subaccountId subaccountId or {@code null} for none
   */
  public ChangeLog setSubaccountId(java.lang.Long subaccountId) {
    this.subaccountId = subaccountId;
    return this;
  }

  /**
   * Transaction ID of this change log. When a single API call results in many changes, each change
   * will have a separate ID in the change log but will share the same transactionId.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTransactionId() {
    return transactionId;
  }

  /**
   * Transaction ID of this change log. When a single API call results in many changes, each change
   * will have a separate ID in the change log but will share the same transactionId.
   * @param transactionId transactionId or {@code null} for none
   */
  public ChangeLog setTransactionId(java.lang.Long transactionId) {
    this.transactionId = transactionId;
    return this;
  }

  /**
   * ID of the user who modified the object.
   * @return value or {@code null} for none
   */
  public java.lang.Long getUserProfileId() {
    return userProfileId;
  }

  /**
   * ID of the user who modified the object.
   * @param userProfileId userProfileId or {@code null} for none
   */
  public ChangeLog setUserProfileId(java.lang.Long userProfileId) {
    this.userProfileId = userProfileId;
    return this;
  }

  /**
   * User profile name of the user who modified the object.
   * @return value or {@code null} for none
   */
  public java.lang.String getUserProfileName() {
    return userProfileName;
  }

  /**
   * User profile name of the user who modified the object.
   * @param userProfileName userProfileName or {@code null} for none
   */
  public ChangeLog setUserProfileName(java.lang.String userProfileName) {
    this.userProfileName = userProfileName;
    return this;
  }

  @Override
  public ChangeLog set(String fieldName, Object value) {
    return (ChangeLog) super.set(fieldName, value);
  }

  @Override
  public ChangeLog clone() {
    return (ChangeLog) super.clone();
  }

}
