/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Update Conversions Response.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ConversionsBatchUpdateResponse extends com.google.api.client.json.GenericJson {

  /**
   * Indicates that some or all conversions failed to update.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hasFailures;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#conversionsBatchUpdateResponse".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The update status of each conversion. Statuses are returned in the same order that conversions
   * are updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ConversionStatus> status;

  static {
    // hack to force ProGuard to consider ConversionStatus used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ConversionStatus.class);
  }

  /**
   * Indicates that some or all conversions failed to update.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHasFailures() {
    return hasFailures;
  }

  /**
   * Indicates that some or all conversions failed to update.
   * @param hasFailures hasFailures or {@code null} for none
   */
  public ConversionsBatchUpdateResponse setHasFailures(java.lang.Boolean hasFailures) {
    this.hasFailures = hasFailures;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#conversionsBatchUpdateResponse".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#conversionsBatchUpdateResponse".
   * @param kind kind or {@code null} for none
   */
  public ConversionsBatchUpdateResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The update status of each conversion. Statuses are returned in the same order that conversions
   * are updated.
   * @return value or {@code null} for none
   */
  public java.util.List<ConversionStatus> getStatus() {
    return status;
  }

  /**
   * The update status of each conversion. Statuses are returned in the same order that conversions
   * are updated.
   * @param status status or {@code null} for none
   */
  public ConversionsBatchUpdateResponse setStatus(java.util.List<ConversionStatus> status) {
    this.status = status;
    return this;
  }

  @Override
  public ConversionsBatchUpdateResponse set(String fieldName, Object value) {
    return (ConversionsBatchUpdateResponse) super.set(fieldName, value);
  }

  @Override
  public ConversionsBatchUpdateResponse clone() {
    return (ConversionsBatchUpdateResponse) super.clone();
  }

}
