/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains information about a country that can be targeted by ads.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Country extends com.google.api.client.json.GenericJson {

  /**
   * Country code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String countryCode;

  /**
   * DART ID of this country. This is the ID used for targeting and generating reports.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long dartId;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#country".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of this country.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Whether ad serving supports secure servers in this country.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean sslEnabled;

  /**
   * Country code.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountryCode() {
    return countryCode;
  }

  /**
   * Country code.
   * @param countryCode countryCode or {@code null} for none
   */
  public Country setCountryCode(java.lang.String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

  /**
   * DART ID of this country. This is the ID used for targeting and generating reports.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDartId() {
    return dartId;
  }

  /**
   * DART ID of this country. This is the ID used for targeting and generating reports.
   * @param dartId dartId or {@code null} for none
   */
  public Country setDartId(java.lang.Long dartId) {
    this.dartId = dartId;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#country".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#country".
   * @param kind kind or {@code null} for none
   */
  public Country setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of this country.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this country.
   * @param name name or {@code null} for none
   */
  public Country setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Whether ad serving supports secure servers in this country.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSslEnabled() {
    return sslEnabled;
  }

  /**
   * Whether ad serving supports secure servers in this country.
   * @param sslEnabled sslEnabled or {@code null} for none
   */
  public Country setSslEnabled(java.lang.Boolean sslEnabled) {
    this.sslEnabled = sslEnabled;
    return this;
  }

  @Override
  public Country set(String fieldName, Object value) {
    return (Country) super.set(fieldName, value);
  }

  @Override
  public Country clone() {
    return (Country) super.clone();
  }

}
