/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Creative optimization settings.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreativeOptimizationConfiguration extends com.google.api.client.json.GenericJson {

  /**
   * ID of this creative optimization config. This field is auto-generated when the campaign is
   * inserted or updated. It can be null for existing campaigns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Name of this creative optimization config. This is a required field and must be less than 129
   * characters long.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * List of optimization activities associated with this configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OptimizationActivity> optimizationActivitys;

  /**
   * Optimization model for this configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String optimizationModel;

  /**
   * ID of this creative optimization config. This field is auto-generated when the campaign is
   * inserted or updated. It can be null for existing campaigns.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * ID of this creative optimization config. This field is auto-generated when the campaign is
   * inserted or updated. It can be null for existing campaigns.
   * @param id id or {@code null} for none
   */
  public CreativeOptimizationConfiguration setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Name of this creative optimization config. This is a required field and must be less than 129
   * characters long.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this creative optimization config. This is a required field and must be less than 129
   * characters long.
   * @param name name or {@code null} for none
   */
  public CreativeOptimizationConfiguration setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * List of optimization activities associated with this configuration.
   * @return value or {@code null} for none
   */
  public java.util.List<OptimizationActivity> getOptimizationActivitys() {
    return optimizationActivitys;
  }

  /**
   * List of optimization activities associated with this configuration.
   * @param optimizationActivitys optimizationActivitys or {@code null} for none
   */
  public CreativeOptimizationConfiguration setOptimizationActivitys(java.util.List<OptimizationActivity> optimizationActivitys) {
    this.optimizationActivitys = optimizationActivitys;
    return this;
  }

  /**
   * Optimization model for this configuration.
   * @return value or {@code null} for none
   */
  public java.lang.String getOptimizationModel() {
    return optimizationModel;
  }

  /**
   * Optimization model for this configuration.
   * @param optimizationModel optimizationModel or {@code null} for none
   */
  public CreativeOptimizationConfiguration setOptimizationModel(java.lang.String optimizationModel) {
    this.optimizationModel = optimizationModel;
    return this;
  }

  @Override
  public CreativeOptimizationConfiguration set(String fieldName, Object value) {
    return (CreativeOptimizationConfiguration) super.set(fieldName, value);
  }

  @Override
  public CreativeOptimizationConfiguration clone() {
    return (CreativeOptimizationConfiguration) super.clone();
  }

}
