/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Represents a dimension filter.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DimensionFilter extends com.google.api.client.json.GenericJson {

  /**
   * The name of the dimension to filter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dimensionName;

  /**
   * The kind of resource this is, in this case dfareporting#dimensionFilter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The value of the dimension to filter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * The name of the dimension to filter.
   * @return value or {@code null} for none
   */
  public java.lang.String getDimensionName() {
    return dimensionName;
  }

  /**
   * The name of the dimension to filter.
   * @param dimensionName dimensionName or {@code null} for none
   */
  public DimensionFilter setDimensionName(java.lang.String dimensionName) {
    this.dimensionName = dimensionName;
    return this;
  }

  /**
   * The kind of resource this is, in this case dfareporting#dimensionFilter.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of resource this is, in this case dfareporting#dimensionFilter.
   * @param kind kind or {@code null} for none
   */
  public DimensionFilter setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The value of the dimension to filter.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * The value of the dimension to filter.
   * @param value value or {@code null} for none
   */
  public DimensionFilter setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public DimensionFilter set(String fieldName, Object value) {
    return (DimensionFilter) super.set(fieldName, value);
  }

  @Override
  public DimensionFilter clone() {
    return (DimensionFilter) super.clone();
  }

}
