/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains properties of a dynamic targeting key. Dynamic targeting keys are unique, user-friendly
 * labels, created at the advertiser level in DCM, that can be assigned to ads, creatives, and
 * placements and used for targeting with Studio dynamic creatives. Use these labels instead of
 * numeric Campaign Manager IDs (such as placement IDs) to save time and avoid errors in your
 * dynamic feeds.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DynamicTargetingKey extends com.google.api.client.json.GenericJson {

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#dynamicTargetingKey".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of this dynamic targeting key. This is a required field. Must be less than 256 characters
   * long and cannot contain commas. All characters are converted to lowercase.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * ID of the object of this dynamic targeting key. This is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long objectId;

  /**
   * Type of the object of this dynamic targeting key. This is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectType;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#dynamicTargetingKey".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#dynamicTargetingKey".
   * @param kind kind or {@code null} for none
   */
  public DynamicTargetingKey setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of this dynamic targeting key. This is a required field. Must be less than 256 characters
   * long and cannot contain commas. All characters are converted to lowercase.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this dynamic targeting key. This is a required field. Must be less than 256 characters
   * long and cannot contain commas. All characters are converted to lowercase.
   * @param name name or {@code null} for none
   */
  public DynamicTargetingKey setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * ID of the object of this dynamic targeting key. This is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getObjectId() {
    return objectId;
  }

  /**
   * ID of the object of this dynamic targeting key. This is a required field.
   * @param objectId objectId or {@code null} for none
   */
  public DynamicTargetingKey setObjectId(java.lang.Long objectId) {
    this.objectId = objectId;
    return this;
  }

  /**
   * Type of the object of this dynamic targeting key. This is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectType() {
    return objectType;
  }

  /**
   * Type of the object of this dynamic targeting key. This is a required field.
   * @param objectType objectType or {@code null} for none
   */
  public DynamicTargetingKey setObjectType(java.lang.String objectType) {
    this.objectType = objectType;
    return this;
  }

  @Override
  public DynamicTargetingKey set(String fieldName, Object value) {
    return (DynamicTargetingKey) super.set(fieldName, value);
  }

  @Override
  public DynamicTargetingKey clone() {
    return (DynamicTargetingKey) super.clone();
  }

}
