/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * A description of how user IDs are encrypted.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EncryptionInfo extends com.google.api.client.json.GenericJson {

  /**
   * The encryption entity ID. This should match the encryption configuration for ad serving or Data
   * Transfer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long encryptionEntityId;

  /**
   * The encryption entity type. This should match the encryption configuration for ad serving or
   * Data Transfer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String encryptionEntityType;

  /**
   * Describes whether the encrypted cookie was received from ad serving (the %m macro) or from Data
   * Transfer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String encryptionSource;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#encryptionInfo".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The encryption entity ID. This should match the encryption configuration for ad serving or Data
   * Transfer.
   * @return value or {@code null} for none
   */
  public java.lang.Long getEncryptionEntityId() {
    return encryptionEntityId;
  }

  /**
   * The encryption entity ID. This should match the encryption configuration for ad serving or Data
   * Transfer.
   * @param encryptionEntityId encryptionEntityId or {@code null} for none
   */
  public EncryptionInfo setEncryptionEntityId(java.lang.Long encryptionEntityId) {
    this.encryptionEntityId = encryptionEntityId;
    return this;
  }

  /**
   * The encryption entity type. This should match the encryption configuration for ad serving or
   * Data Transfer.
   * @return value or {@code null} for none
   */
  public java.lang.String getEncryptionEntityType() {
    return encryptionEntityType;
  }

  /**
   * The encryption entity type. This should match the encryption configuration for ad serving or
   * Data Transfer.
   * @param encryptionEntityType encryptionEntityType or {@code null} for none
   */
  public EncryptionInfo setEncryptionEntityType(java.lang.String encryptionEntityType) {
    this.encryptionEntityType = encryptionEntityType;
    return this;
  }

  /**
   * Describes whether the encrypted cookie was received from ad serving (the %m macro) or from Data
   * Transfer.
   * @return value or {@code null} for none
   */
  public java.lang.String getEncryptionSource() {
    return encryptionSource;
  }

  /**
   * Describes whether the encrypted cookie was received from ad serving (the %m macro) or from Data
   * Transfer.
   * @param encryptionSource encryptionSource or {@code null} for none
   */
  public EncryptionInfo setEncryptionSource(java.lang.String encryptionSource) {
    this.encryptionSource = encryptionSource;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#encryptionInfo".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#encryptionInfo".
   * @param kind kind or {@code null} for none
   */
  public EncryptionInfo setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public EncryptionInfo set(String fieldName, Object value) {
    return (EncryptionInfo) super.set(fieldName, value);
  }

  @Override
  public EncryptionInfo clone() {
    return (EncryptionInfo) super.clone();
  }

}
