/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains information about a metro region that can be targeted by ads.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Metro extends com.google.api.client.json.GenericJson {

  /**
   * Country code of the country to which this metro region belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String countryCode;

  /**
   * DART ID of the country to which this metro region belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long countryDartId;

  /**
   * DART ID of this metro region.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long dartId;

  /**
   * DMA ID of this metro region. This is the ID used for targeting and generating reports, and is
   * equivalent to metro_code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long dmaId;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#metro".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Metro code of this metro region. This is equivalent to dma_id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String metroCode;

  /**
   * Name of this metro region.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Country code of the country to which this metro region belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountryCode() {
    return countryCode;
  }

  /**
   * Country code of the country to which this metro region belongs.
   * @param countryCode countryCode or {@code null} for none
   */
  public Metro setCountryCode(java.lang.String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

  /**
   * DART ID of the country to which this metro region belongs.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCountryDartId() {
    return countryDartId;
  }

  /**
   * DART ID of the country to which this metro region belongs.
   * @param countryDartId countryDartId or {@code null} for none
   */
  public Metro setCountryDartId(java.lang.Long countryDartId) {
    this.countryDartId = countryDartId;
    return this;
  }

  /**
   * DART ID of this metro region.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDartId() {
    return dartId;
  }

  /**
   * DART ID of this metro region.
   * @param dartId dartId or {@code null} for none
   */
  public Metro setDartId(java.lang.Long dartId) {
    this.dartId = dartId;
    return this;
  }

  /**
   * DMA ID of this metro region. This is the ID used for targeting and generating reports, and is
   * equivalent to metro_code.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDmaId() {
    return dmaId;
  }

  /**
   * DMA ID of this metro region. This is the ID used for targeting and generating reports, and is
   * equivalent to metro_code.
   * @param dmaId dmaId or {@code null} for none
   */
  public Metro setDmaId(java.lang.Long dmaId) {
    this.dmaId = dmaId;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#metro".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#metro".
   * @param kind kind or {@code null} for none
   */
  public Metro setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Metro code of this metro region. This is equivalent to dma_id.
   * @return value or {@code null} for none
   */
  public java.lang.String getMetroCode() {
    return metroCode;
  }

  /**
   * Metro code of this metro region. This is equivalent to dma_id.
   * @param metroCode metroCode or {@code null} for none
   */
  public Metro setMetroCode(java.lang.String metroCode) {
    this.metroCode = metroCode;
    return this;
  }

  /**
   * Name of this metro region.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this metro region.
   * @param name name or {@code null} for none
   */
  public Metro setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public Metro set(String fieldName, Object value) {
    return (Metro) super.set(fieldName, value);
  }

  @Override
  public Metro clone() {
    return (Metro) super.clone();
  }

}
