/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains information about a mobile app. Used as a landing page deep link.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MobileApp extends com.google.api.client.json.GenericJson {

  /**
   * Mobile app directory.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String directory;

  /**
   * ID of this mobile app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#mobileApp".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Publisher name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String publisherName;

  /**
   * Title of this mobile app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * Mobile app directory.
   * @return value or {@code null} for none
   */
  public java.lang.String getDirectory() {
    return directory;
  }

  /**
   * Mobile app directory.
   * @param directory directory or {@code null} for none
   */
  public MobileApp setDirectory(java.lang.String directory) {
    this.directory = directory;
    return this;
  }

  /**
   * ID of this mobile app.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * ID of this mobile app.
   * @param id id or {@code null} for none
   */
  public MobileApp setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#mobileApp".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#mobileApp".
   * @param kind kind or {@code null} for none
   */
  public MobileApp setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Publisher name.
   * @return value or {@code null} for none
   */
  public java.lang.String getPublisherName() {
    return publisherName;
  }

  /**
   * Publisher name.
   * @param publisherName publisherName or {@code null} for none
   */
  public MobileApp setPublisherName(java.lang.String publisherName) {
    this.publisherName = publisherName;
    return this;
  }

  /**
   * Title of this mobile app.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * Title of this mobile app.
   * @param title title or {@code null} for none
   */
  public MobileApp setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public MobileApp set(String fieldName, Object value) {
    return (MobileApp) super.set(fieldName, value);
  }

  @Override
  public MobileApp clone() {
    return (MobileApp) super.clone();
  }

}
