/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Pricing Schedule
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PricingSchedule extends com.google.api.client.json.GenericJson {

  /**
   * Placement cap cost option.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String capCostOption;

  /**
   * Whether cap costs are ignored by ad serving.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean disregardOverdelivery;

  /**
   * Placement end date. This date must be later than, or the same day as, the placement start date,
   * but not later than the campaign end date. If, for example, you set 6/25/2015 as both the start
   * and end dates, the effective placement date is just that day only, 6/25/2015. The hours,
   * minutes, and seconds of the end date should not be set, as doing so will result in an error.
   * This field is required on insertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime endDate;

  /**
   * Whether this placement is flighted. If true, pricing periods will be computed automatically.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean flighted;

  /**
   * Floodlight activity ID associated with this placement. This field should be set when placement
   * pricing type is set to PRICING_TYPE_CPA.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long floodlightActivityId;

  /**
   * Pricing periods for this placement.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PricingSchedulePricingPeriod> pricingPeriods;

  /**
   * Placement pricing type. This field is required on insertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pricingType;

  /**
   * Placement start date. This date must be later than, or the same day as, the campaign start
   * date. The hours, minutes, and seconds of the start date should not be set, as doing so will
   * result in an error. This field is required on insertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime startDate;

  /**
   * Testing start date of this placement. The hours, minutes, and seconds of the start date should
   * not be set, as doing so will result in an error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime testingStartDate;

  /**
   * Placement cap cost option.
   * @return value or {@code null} for none
   */
  public java.lang.String getCapCostOption() {
    return capCostOption;
  }

  /**
   * Placement cap cost option.
   * @param capCostOption capCostOption or {@code null} for none
   */
  public PricingSchedule setCapCostOption(java.lang.String capCostOption) {
    this.capCostOption = capCostOption;
    return this;
  }

  /**
   * Whether cap costs are ignored by ad serving.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDisregardOverdelivery() {
    return disregardOverdelivery;
  }

  /**
   * Whether cap costs are ignored by ad serving.
   * @param disregardOverdelivery disregardOverdelivery or {@code null} for none
   */
  public PricingSchedule setDisregardOverdelivery(java.lang.Boolean disregardOverdelivery) {
    this.disregardOverdelivery = disregardOverdelivery;
    return this;
  }

  /**
   * Placement end date. This date must be later than, or the same day as, the placement start date,
   * but not later than the campaign end date. If, for example, you set 6/25/2015 as both the start
   * and end dates, the effective placement date is just that day only, 6/25/2015. The hours,
   * minutes, and seconds of the end date should not be set, as doing so will result in an error.
   * This field is required on insertion.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getEndDate() {
    return endDate;
  }

  /**
   * Placement end date. This date must be later than, or the same day as, the placement start date,
   * but not later than the campaign end date. If, for example, you set 6/25/2015 as both the start
   * and end dates, the effective placement date is just that day only, 6/25/2015. The hours,
   * minutes, and seconds of the end date should not be set, as doing so will result in an error.
   * This field is required on insertion.
   * @param endDate endDate or {@code null} for none
   */
  public PricingSchedule setEndDate(com.google.api.client.util.DateTime endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * Whether this placement is flighted. If true, pricing periods will be computed automatically.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFlighted() {
    return flighted;
  }

  /**
   * Whether this placement is flighted. If true, pricing periods will be computed automatically.
   * @param flighted flighted or {@code null} for none
   */
  public PricingSchedule setFlighted(java.lang.Boolean flighted) {
    this.flighted = flighted;
    return this;
  }

  /**
   * Floodlight activity ID associated with this placement. This field should be set when placement
   * pricing type is set to PRICING_TYPE_CPA.
   * @return value or {@code null} for none
   */
  public java.lang.Long getFloodlightActivityId() {
    return floodlightActivityId;
  }

  /**
   * Floodlight activity ID associated with this placement. This field should be set when placement
   * pricing type is set to PRICING_TYPE_CPA.
   * @param floodlightActivityId floodlightActivityId or {@code null} for none
   */
  public PricingSchedule setFloodlightActivityId(java.lang.Long floodlightActivityId) {
    this.floodlightActivityId = floodlightActivityId;
    return this;
  }

  /**
   * Pricing periods for this placement.
   * @return value or {@code null} for none
   */
  public java.util.List<PricingSchedulePricingPeriod> getPricingPeriods() {
    return pricingPeriods;
  }

  /**
   * Pricing periods for this placement.
   * @param pricingPeriods pricingPeriods or {@code null} for none
   */
  public PricingSchedule setPricingPeriods(java.util.List<PricingSchedulePricingPeriod> pricingPeriods) {
    this.pricingPeriods = pricingPeriods;
    return this;
  }

  /**
   * Placement pricing type. This field is required on insertion.
   * @return value or {@code null} for none
   */
  public java.lang.String getPricingType() {
    return pricingType;
  }

  /**
   * Placement pricing type. This field is required on insertion.
   * @param pricingType pricingType or {@code null} for none
   */
  public PricingSchedule setPricingType(java.lang.String pricingType) {
    this.pricingType = pricingType;
    return this;
  }

  /**
   * Placement start date. This date must be later than, or the same day as, the campaign start
   * date. The hours, minutes, and seconds of the start date should not be set, as doing so will
   * result in an error. This field is required on insertion.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getStartDate() {
    return startDate;
  }

  /**
   * Placement start date. This date must be later than, or the same day as, the campaign start
   * date. The hours, minutes, and seconds of the start date should not be set, as doing so will
   * result in an error. This field is required on insertion.
   * @param startDate startDate or {@code null} for none
   */
  public PricingSchedule setStartDate(com.google.api.client.util.DateTime startDate) {
    this.startDate = startDate;
    return this;
  }

  /**
   * Testing start date of this placement. The hours, minutes, and seconds of the start date should
   * not be set, as doing so will result in an error.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getTestingStartDate() {
    return testingStartDate;
  }

  /**
   * Testing start date of this placement. The hours, minutes, and seconds of the start date should
   * not be set, as doing so will result in an error.
   * @param testingStartDate testingStartDate or {@code null} for none
   */
  public PricingSchedule setTestingStartDate(com.google.api.client.util.DateTime testingStartDate) {
    this.testingStartDate = testingStartDate;
    return this;
  }

  @Override
  public PricingSchedule set(String fieldName, Object value) {
    return (PricingSchedule) super.set(fieldName, value);
  }

  @Override
  public PricingSchedule clone() {
    return (PricingSchedule) super.clone();
  }

}
