/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Represents a recipient.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Recipient extends com.google.api.client.json.GenericJson {

  /**
   * The delivery type for the recipient.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deliveryType;

  /**
   * The email address of the recipient.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String email;

  /**
   * The kind of resource this is, in this case dfareporting#recipient.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The delivery type for the recipient.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeliveryType() {
    return deliveryType;
  }

  /**
   * The delivery type for the recipient.
   * @param deliveryType deliveryType or {@code null} for none
   */
  public Recipient setDeliveryType(java.lang.String deliveryType) {
    this.deliveryType = deliveryType;
    return this;
  }

  /**
   * The email address of the recipient.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmail() {
    return email;
  }

  /**
   * The email address of the recipient.
   * @param email email or {@code null} for none
   */
  public Recipient setEmail(java.lang.String email) {
    this.email = email;
    return this;
  }

  /**
   * The kind of resource this is, in this case dfareporting#recipient.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of resource this is, in this case dfareporting#recipient.
   * @param kind kind or {@code null} for none
   */
  public Recipient setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public Recipient set(String fieldName, Object value) {
    return (Recipient) super.set(fieldName, value);
  }

  @Override
  public Recipient clone() {
    return (Recipient) super.clone();
  }

}
