/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Rich Media Exit Override.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RichMediaExitOverride extends com.google.api.client.json.GenericJson {

  /**
   * Click-through URL of this rich media exit override. Applicable if the enabled field is set to
   * true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ClickThroughUrl clickThroughUrl;

  /**
   * Whether to use the clickThroughUrl. If false, the creative-level exit will be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enabled;

  /**
   * ID for the override to refer to a specific exit in the creative.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long exitId;

  /**
   * Click-through URL of this rich media exit override. Applicable if the enabled field is set to
   * true.
   * @return value or {@code null} for none
   */
  public ClickThroughUrl getClickThroughUrl() {
    return clickThroughUrl;
  }

  /**
   * Click-through URL of this rich media exit override. Applicable if the enabled field is set to
   * true.
   * @param clickThroughUrl clickThroughUrl or {@code null} for none
   */
  public RichMediaExitOverride setClickThroughUrl(ClickThroughUrl clickThroughUrl) {
    this.clickThroughUrl = clickThroughUrl;
    return this;
  }

  /**
   * Whether to use the clickThroughUrl. If false, the creative-level exit will be used.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnabled() {
    return enabled;
  }

  /**
   * Whether to use the clickThroughUrl. If false, the creative-level exit will be used.
   * @param enabled enabled or {@code null} for none
   */
  public RichMediaExitOverride setEnabled(java.lang.Boolean enabled) {
    this.enabled = enabled;
    return this;
  }

  /**
   * ID for the override to refer to a specific exit in the creative.
   * @return value or {@code null} for none
   */
  public java.lang.Long getExitId() {
    return exitId;
  }

  /**
   * ID for the override to refer to a specific exit in the creative.
   * @param exitId exitId or {@code null} for none
   */
  public RichMediaExitOverride setExitId(java.lang.Long exitId) {
    this.exitId = exitId;
    return this;
  }

  @Override
  public RichMediaExitOverride set(String fieldName, Object value) {
    return (RichMediaExitOverride) super.set(fieldName, value);
  }

  @Override
  public RichMediaExitOverride clone() {
    return (RichMediaExitOverride) super.clone();
  }

}
