/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains properties of a targeting template. A targeting template encapsulates targeting
 * information which can be reused across multiple ads.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TargetingTemplate extends com.google.api.client.json.GenericJson {

  /**
   * Account ID of this targeting template. This field, if left unset, will be auto-generated on
   * insert and is read-only after insert.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long accountId;

  /**
   * Advertiser ID of this targeting template. This is a required field on insert and is read-only
   * after insert.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long advertiserId;

  /**
   * Dimension value for the ID of the advertiser. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionValue advertiserIdDimensionValue;

  /**
   * Time and day targeting criteria.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DayPartTargeting dayPartTargeting;

  /**
   * Geographical targeting criteria.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GeoTargeting geoTargeting;

  /**
   * ID of this targeting template. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Key-value targeting criteria.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private KeyValueTargetingExpression keyValueTargetingExpression;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#targetingTemplate".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Language targeting criteria.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LanguageTargeting languageTargeting;

  /**
   * Remarketing list targeting criteria.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ListTargetingExpression listTargetingExpression;

  /**
   * Name of this targeting template. This field is required. It must be less than 256 characters
   * long and unique within an advertiser.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Subaccount ID of this targeting template. This field, if left unset, will be auto-generated on
   * insert and is read-only after insert.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long subaccountId;

  /**
   * Technology platform targeting criteria.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TechnologyTargeting technologyTargeting;

  /**
   * Account ID of this targeting template. This field, if left unset, will be auto-generated on
   * insert and is read-only after insert.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAccountId() {
    return accountId;
  }

  /**
   * Account ID of this targeting template. This field, if left unset, will be auto-generated on
   * insert and is read-only after insert.
   * @param accountId accountId or {@code null} for none
   */
  public TargetingTemplate setAccountId(java.lang.Long accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Advertiser ID of this targeting template. This is a required field on insert and is read-only
   * after insert.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAdvertiserId() {
    return advertiserId;
  }

  /**
   * Advertiser ID of this targeting template. This is a required field on insert and is read-only
   * after insert.
   * @param advertiserId advertiserId or {@code null} for none
   */
  public TargetingTemplate setAdvertiserId(java.lang.Long advertiserId) {
    this.advertiserId = advertiserId;
    return this;
  }

  /**
   * Dimension value for the ID of the advertiser. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public DimensionValue getAdvertiserIdDimensionValue() {
    return advertiserIdDimensionValue;
  }

  /**
   * Dimension value for the ID of the advertiser. This is a read-only, auto-generated field.
   * @param advertiserIdDimensionValue advertiserIdDimensionValue or {@code null} for none
   */
  public TargetingTemplate setAdvertiserIdDimensionValue(DimensionValue advertiserIdDimensionValue) {
    this.advertiserIdDimensionValue = advertiserIdDimensionValue;
    return this;
  }

  /**
   * Time and day targeting criteria.
   * @return value or {@code null} for none
   */
  public DayPartTargeting getDayPartTargeting() {
    return dayPartTargeting;
  }

  /**
   * Time and day targeting criteria.
   * @param dayPartTargeting dayPartTargeting or {@code null} for none
   */
  public TargetingTemplate setDayPartTargeting(DayPartTargeting dayPartTargeting) {
    this.dayPartTargeting = dayPartTargeting;
    return this;
  }

  /**
   * Geographical targeting criteria.
   * @return value or {@code null} for none
   */
  public GeoTargeting getGeoTargeting() {
    return geoTargeting;
  }

  /**
   * Geographical targeting criteria.
   * @param geoTargeting geoTargeting or {@code null} for none
   */
  public TargetingTemplate setGeoTargeting(GeoTargeting geoTargeting) {
    this.geoTargeting = geoTargeting;
    return this;
  }

  /**
   * ID of this targeting template. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * ID of this targeting template. This is a read-only, auto-generated field.
   * @param id id or {@code null} for none
   */
  public TargetingTemplate setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Key-value targeting criteria.
   * @return value or {@code null} for none
   */
  public KeyValueTargetingExpression getKeyValueTargetingExpression() {
    return keyValueTargetingExpression;
  }

  /**
   * Key-value targeting criteria.
   * @param keyValueTargetingExpression keyValueTargetingExpression or {@code null} for none
   */
  public TargetingTemplate setKeyValueTargetingExpression(KeyValueTargetingExpression keyValueTargetingExpression) {
    this.keyValueTargetingExpression = keyValueTargetingExpression;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#targetingTemplate".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#targetingTemplate".
   * @param kind kind or {@code null} for none
   */
  public TargetingTemplate setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Language targeting criteria.
   * @return value or {@code null} for none
   */
  public LanguageTargeting getLanguageTargeting() {
    return languageTargeting;
  }

  /**
   * Language targeting criteria.
   * @param languageTargeting languageTargeting or {@code null} for none
   */
  public TargetingTemplate setLanguageTargeting(LanguageTargeting languageTargeting) {
    this.languageTargeting = languageTargeting;
    return this;
  }

  /**
   * Remarketing list targeting criteria.
   * @return value or {@code null} for none
   */
  public ListTargetingExpression getListTargetingExpression() {
    return listTargetingExpression;
  }

  /**
   * Remarketing list targeting criteria.
   * @param listTargetingExpression listTargetingExpression or {@code null} for none
   */
  public TargetingTemplate setListTargetingExpression(ListTargetingExpression listTargetingExpression) {
    this.listTargetingExpression = listTargetingExpression;
    return this;
  }

  /**
   * Name of this targeting template. This field is required. It must be less than 256 characters
   * long and unique within an advertiser.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this targeting template. This field is required. It must be less than 256 characters
   * long and unique within an advertiser.
   * @param name name or {@code null} for none
   */
  public TargetingTemplate setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Subaccount ID of this targeting template. This field, if left unset, will be auto-generated on
   * insert and is read-only after insert.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSubaccountId() {
    return subaccountId;
  }

  /**
   * Subaccount ID of this targeting template. This field, if left unset, will be auto-generated on
   * insert and is read-only after insert.
   * @param subaccountId subaccountId or {@code null} for none
   */
  public TargetingTemplate setSubaccountId(java.lang.Long subaccountId) {
    this.subaccountId = subaccountId;
    return this;
  }

  /**
   * Technology platform targeting criteria.
   * @return value or {@code null} for none
   */
  public TechnologyTargeting getTechnologyTargeting() {
    return technologyTargeting;
  }

  /**
   * Technology platform targeting criteria.
   * @param technologyTargeting technologyTargeting or {@code null} for none
   */
  public TargetingTemplate setTechnologyTargeting(TechnologyTargeting technologyTargeting) {
    this.technologyTargeting = technologyTargeting;
    return this;
  }

  @Override
  public TargetingTemplate set(String fieldName, Object value) {
    return (TargetingTemplate) super.set(fieldName, value);
  }

  @Override
  public TargetingTemplate clone() {
    return (TargetingTemplate) super.clone();
  }

}
