/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Account Permission List Response
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountPermissionsListResponse extends com.google.api.client.json.GenericJson {

  /**
   * Account permission collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AccountPermission> accountPermissions;

  static {
    // hack to force ProGuard to consider AccountPermission used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AccountPermission.class);
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#accountPermissionsListResponse".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Account permission collection.
   * @return value or {@code null} for none
   */
  public java.util.List<AccountPermission> getAccountPermissions() {
    return accountPermissions;
  }

  /**
   * Account permission collection.
   * @param accountPermissions accountPermissions or {@code null} for none
   */
  public AccountPermissionsListResponse setAccountPermissions(java.util.List<AccountPermission> accountPermissions) {
    this.accountPermissions = accountPermissions;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#accountPermissionsListResponse".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#accountPermissionsListResponse".
   * @param kind kind or {@code null} for none
   */
  public AccountPermissionsListResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public AccountPermissionsListResponse set(String fieldName, Object value) {
    return (AccountPermissionsListResponse) super.set(fieldName, value);
  }

  @Override
  public AccountPermissionsListResponse clone() {
    return (AccountPermissionsListResponse) super.clone();
  }

}
