/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Creative Click Tag.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ClickTag extends com.google.api.client.json.GenericJson {

  /**
   * Parameter value for the specified click tag. This field contains a click-through url.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreativeClickThroughUrl clickThroughUrl;

  /**
   * Advertiser event name associated with the click tag. This field is used by
   * DISPLAY_IMAGE_GALLERY and HTML5_BANNER creatives. Applicable to DISPLAY when the primary asset
   * type is not HTML_IMAGE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String eventName;

  /**
   * Parameter name for the specified click tag. For DISPLAY_IMAGE_GALLERY creative assets, this
   * field must match the value of the creative asset's creativeAssetId.name field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Parameter value for the specified click tag. This field contains a click-through url.
   * @return value or {@code null} for none
   */
  public CreativeClickThroughUrl getClickThroughUrl() {
    return clickThroughUrl;
  }

  /**
   * Parameter value for the specified click tag. This field contains a click-through url.
   * @param clickThroughUrl clickThroughUrl or {@code null} for none
   */
  public ClickTag setClickThroughUrl(CreativeClickThroughUrl clickThroughUrl) {
    this.clickThroughUrl = clickThroughUrl;
    return this;
  }

  /**
   * Advertiser event name associated with the click tag. This field is used by
   * DISPLAY_IMAGE_GALLERY and HTML5_BANNER creatives. Applicable to DISPLAY when the primary asset
   * type is not HTML_IMAGE.
   * @return value or {@code null} for none
   */
  public java.lang.String getEventName() {
    return eventName;
  }

  /**
   * Advertiser event name associated with the click tag. This field is used by
   * DISPLAY_IMAGE_GALLERY and HTML5_BANNER creatives. Applicable to DISPLAY when the primary asset
   * type is not HTML_IMAGE.
   * @param eventName eventName or {@code null} for none
   */
  public ClickTag setEventName(java.lang.String eventName) {
    this.eventName = eventName;
    return this;
  }

  /**
   * Parameter name for the specified click tag. For DISPLAY_IMAGE_GALLERY creative assets, this
   * field must match the value of the creative asset's creativeAssetId.name field.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Parameter name for the specified click tag. For DISPLAY_IMAGE_GALLERY creative assets, this
   * field must match the value of the creative asset's creativeAssetId.name field.
   * @param name name or {@code null} for none
   */
  public ClickTag setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public ClickTag set(String fieldName, Object value) {
    return (ClickTag) super.set(fieldName, value);
  }

  @Override
  public ClickTag clone() {
    return (ClickTag) super.clone();
  }

}
