/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Companion Settings
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CompanionSetting extends com.google.api.client.json.GenericJson {

  /**
   * Whether companions are disabled for this placement.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean companionsDisabled;

  /**
   * Whitelist of companion sizes to be served to this placement. Set this list to null or empty to
   * serve all companion sizes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Size> enabledSizes;

  /**
   * Whether to serve only static images as companions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean imageOnly;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#companionSetting".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Whether companions are disabled for this placement.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCompanionsDisabled() {
    return companionsDisabled;
  }

  /**
   * Whether companions are disabled for this placement.
   * @param companionsDisabled companionsDisabled or {@code null} for none
   */
  public CompanionSetting setCompanionsDisabled(java.lang.Boolean companionsDisabled) {
    this.companionsDisabled = companionsDisabled;
    return this;
  }

  /**
   * Whitelist of companion sizes to be served to this placement. Set this list to null or empty to
   * serve all companion sizes.
   * @return value or {@code null} for none
   */
  public java.util.List<Size> getEnabledSizes() {
    return enabledSizes;
  }

  /**
   * Whitelist of companion sizes to be served to this placement. Set this list to null or empty to
   * serve all companion sizes.
   * @param enabledSizes enabledSizes or {@code null} for none
   */
  public CompanionSetting setEnabledSizes(java.util.List<Size> enabledSizes) {
    this.enabledSizes = enabledSizes;
    return this;
  }

  /**
   * Whether to serve only static images as companions.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getImageOnly() {
    return imageOnly;
  }

  /**
   * Whether to serve only static images as companions.
   * @param imageOnly imageOnly or {@code null} for none
   */
  public CompanionSetting setImageOnly(java.lang.Boolean imageOnly) {
    this.imageOnly = imageOnly;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#companionSetting".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#companionSetting".
   * @param kind kind or {@code null} for none
   */
  public CompanionSetting setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public CompanionSetting set(String fieldName, Object value) {
    return (CompanionSetting) super.set(fieldName, value);
  }

  @Override
  public CompanionSetting clone() {
    return (CompanionSetting) super.clone();
  }

}
