/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * A Conversion represents when a user successfully performs a desired action after seeing an ad.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Conversion extends com.google.api.client.json.GenericJson {

  /**
   * Whether this particular request may come from a user under the age of 13, under COPPA
   * compliance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean childDirectedTreatment;

  /**
   * Custom floodlight variables.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CustomFloodlightVariable> customVariables;

  /**
   * The alphanumeric encrypted user ID. When set, encryptionInfo should also be specified. This
   * field is mutually exclusive with encryptedUserIdCandidates[], matchId, mobileDeviceId and
   * gclid. This or encryptedUserIdCandidates[] or matchId or mobileDeviceId or gclid is a required
   * field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String encryptedUserId;

  /**
   * A list of the alphanumeric encrypted user IDs. Any user ID with exposure prior to the
   * conversion timestamp will be used in the inserted conversion. If no such user ID is found then
   * the conversion will be rejected with INVALID_ARGUMENT error. When set, encryptionInfo should
   * also be specified. This field may only be used when calling batchinsert; it is not supported by
   * batchupdate. This field is mutually exclusive with encryptedUserId, matchId, mobileDeviceId and
   * gclid. This or encryptedUserId or matchId or mobileDeviceId or gclid is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> encryptedUserIdCandidates;

  /**
   * Floodlight Activity ID of this conversion. This is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long floodlightActivityId;

  /**
   * Floodlight Configuration ID of this conversion. This is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long floodlightConfigurationId;

  /**
   * The Google click ID. This field is mutually exclusive with encryptedUserId,
   * encryptedUserIdCandidates[], matchId and mobileDeviceId. This or encryptedUserId or
   * encryptedUserIdCandidates[] or matchId or mobileDeviceId is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gclid;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#conversion".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Whether Limit Ad Tracking is enabled. When set to true, the conversion will be used for
   * reporting but not targeting. This will prevent remarketing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean limitAdTracking;

  /**
   * The match ID field. A match ID is your own first-party identifier that has been synced with
   * Google using the match ID feature in Floodlight. This field is mutually exclusive with
   * encryptedUserId, encryptedUserIdCandidates[],mobileDeviceId and gclid. This or encryptedUserId
   * or encryptedUserIdCandidates[] or mobileDeviceId or gclid is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String matchId;

  /**
   * The mobile device ID. This field is mutually exclusive with encryptedUserId,
   * encryptedUserIdCandidates[], matchId and gclid. This or encryptedUserId or
   * encryptedUserIdCandidates[] or matchId or gclid is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mobileDeviceId;

  /**
   * Whether the conversion was for a non personalized ad.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean nonPersonalizedAd;

  /**
   * The ordinal of the conversion. Use this field to control how conversions of the same user and
   * day are de-duplicated. This is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ordinal;

  /**
   * The quantity of the conversion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long quantity;

  /**
   * The timestamp of conversion, in Unix epoch micros. This is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long timestampMicros;

  /**
   * Whether this particular request may come from a user under the age of 16 (may differ by
   * country), under compliance with the European Union's General Data Protection Regulation (GDPR).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean treatmentForUnderage;

  /**
   * The value of the conversion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double value;

  /**
   * Whether this particular request may come from a user under the age of 13, under COPPA
   * compliance.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getChildDirectedTreatment() {
    return childDirectedTreatment;
  }

  /**
   * Whether this particular request may come from a user under the age of 13, under COPPA
   * compliance.
   * @param childDirectedTreatment childDirectedTreatment or {@code null} for none
   */
  public Conversion setChildDirectedTreatment(java.lang.Boolean childDirectedTreatment) {
    this.childDirectedTreatment = childDirectedTreatment;
    return this;
  }

  /**
   * Custom floodlight variables.
   * @return value or {@code null} for none
   */
  public java.util.List<CustomFloodlightVariable> getCustomVariables() {
    return customVariables;
  }

  /**
   * Custom floodlight variables.
   * @param customVariables customVariables or {@code null} for none
   */
  public Conversion setCustomVariables(java.util.List<CustomFloodlightVariable> customVariables) {
    this.customVariables = customVariables;
    return this;
  }

  /**
   * The alphanumeric encrypted user ID. When set, encryptionInfo should also be specified. This
   * field is mutually exclusive with encryptedUserIdCandidates[], matchId, mobileDeviceId and
   * gclid. This or encryptedUserIdCandidates[] or matchId or mobileDeviceId or gclid is a required
   * field.
   * @return value or {@code null} for none
   */
  public java.lang.String getEncryptedUserId() {
    return encryptedUserId;
  }

  /**
   * The alphanumeric encrypted user ID. When set, encryptionInfo should also be specified. This
   * field is mutually exclusive with encryptedUserIdCandidates[], matchId, mobileDeviceId and
   * gclid. This or encryptedUserIdCandidates[] or matchId or mobileDeviceId or gclid is a required
   * field.
   * @param encryptedUserId encryptedUserId or {@code null} for none
   */
  public Conversion setEncryptedUserId(java.lang.String encryptedUserId) {
    this.encryptedUserId = encryptedUserId;
    return this;
  }

  /**
   * A list of the alphanumeric encrypted user IDs. Any user ID with exposure prior to the
   * conversion timestamp will be used in the inserted conversion. If no such user ID is found then
   * the conversion will be rejected with INVALID_ARGUMENT error. When set, encryptionInfo should
   * also be specified. This field may only be used when calling batchinsert; it is not supported by
   * batchupdate. This field is mutually exclusive with encryptedUserId, matchId, mobileDeviceId and
   * gclid. This or encryptedUserId or matchId or mobileDeviceId or gclid is a required field.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getEncryptedUserIdCandidates() {
    return encryptedUserIdCandidates;
  }

  /**
   * A list of the alphanumeric encrypted user IDs. Any user ID with exposure prior to the
   * conversion timestamp will be used in the inserted conversion. If no such user ID is found then
   * the conversion will be rejected with INVALID_ARGUMENT error. When set, encryptionInfo should
   * also be specified. This field may only be used when calling batchinsert; it is not supported by
   * batchupdate. This field is mutually exclusive with encryptedUserId, matchId, mobileDeviceId and
   * gclid. This or encryptedUserId or matchId or mobileDeviceId or gclid is a required field.
   * @param encryptedUserIdCandidates encryptedUserIdCandidates or {@code null} for none
   */
  public Conversion setEncryptedUserIdCandidates(java.util.List<java.lang.String> encryptedUserIdCandidates) {
    this.encryptedUserIdCandidates = encryptedUserIdCandidates;
    return this;
  }

  /**
   * Floodlight Activity ID of this conversion. This is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getFloodlightActivityId() {
    return floodlightActivityId;
  }

  /**
   * Floodlight Activity ID of this conversion. This is a required field.
   * @param floodlightActivityId floodlightActivityId or {@code null} for none
   */
  public Conversion setFloodlightActivityId(java.lang.Long floodlightActivityId) {
    this.floodlightActivityId = floodlightActivityId;
    return this;
  }

  /**
   * Floodlight Configuration ID of this conversion. This is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getFloodlightConfigurationId() {
    return floodlightConfigurationId;
  }

  /**
   * Floodlight Configuration ID of this conversion. This is a required field.
   * @param floodlightConfigurationId floodlightConfigurationId or {@code null} for none
   */
  public Conversion setFloodlightConfigurationId(java.lang.Long floodlightConfigurationId) {
    this.floodlightConfigurationId = floodlightConfigurationId;
    return this;
  }

  /**
   * The Google click ID. This field is mutually exclusive with encryptedUserId,
   * encryptedUserIdCandidates[], matchId and mobileDeviceId. This or encryptedUserId or
   * encryptedUserIdCandidates[] or matchId or mobileDeviceId is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.String getGclid() {
    return gclid;
  }

  /**
   * The Google click ID. This field is mutually exclusive with encryptedUserId,
   * encryptedUserIdCandidates[], matchId and mobileDeviceId. This or encryptedUserId or
   * encryptedUserIdCandidates[] or matchId or mobileDeviceId is a required field.
   * @param gclid gclid or {@code null} for none
   */
  public Conversion setGclid(java.lang.String gclid) {
    this.gclid = gclid;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#conversion".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#conversion".
   * @param kind kind or {@code null} for none
   */
  public Conversion setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Whether Limit Ad Tracking is enabled. When set to true, the conversion will be used for
   * reporting but not targeting. This will prevent remarketing.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getLimitAdTracking() {
    return limitAdTracking;
  }

  /**
   * Whether Limit Ad Tracking is enabled. When set to true, the conversion will be used for
   * reporting but not targeting. This will prevent remarketing.
   * @param limitAdTracking limitAdTracking or {@code null} for none
   */
  public Conversion setLimitAdTracking(java.lang.Boolean limitAdTracking) {
    this.limitAdTracking = limitAdTracking;
    return this;
  }

  /**
   * The match ID field. A match ID is your own first-party identifier that has been synced with
   * Google using the match ID feature in Floodlight. This field is mutually exclusive with
   * encryptedUserId, encryptedUserIdCandidates[],mobileDeviceId and gclid. This or encryptedUserId
   * or encryptedUserIdCandidates[] or mobileDeviceId or gclid is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.String getMatchId() {
    return matchId;
  }

  /**
   * The match ID field. A match ID is your own first-party identifier that has been synced with
   * Google using the match ID feature in Floodlight. This field is mutually exclusive with
   * encryptedUserId, encryptedUserIdCandidates[],mobileDeviceId and gclid. This or encryptedUserId
   * or encryptedUserIdCandidates[] or mobileDeviceId or gclid is a required field.
   * @param matchId matchId or {@code null} for none
   */
  public Conversion setMatchId(java.lang.String matchId) {
    this.matchId = matchId;
    return this;
  }

  /**
   * The mobile device ID. This field is mutually exclusive with encryptedUserId,
   * encryptedUserIdCandidates[], matchId and gclid. This or encryptedUserId or
   * encryptedUserIdCandidates[] or matchId or gclid is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.String getMobileDeviceId() {
    return mobileDeviceId;
  }

  /**
   * The mobile device ID. This field is mutually exclusive with encryptedUserId,
   * encryptedUserIdCandidates[], matchId and gclid. This or encryptedUserId or
   * encryptedUserIdCandidates[] or matchId or gclid is a required field.
   * @param mobileDeviceId mobileDeviceId or {@code null} for none
   */
  public Conversion setMobileDeviceId(java.lang.String mobileDeviceId) {
    this.mobileDeviceId = mobileDeviceId;
    return this;
  }

  /**
   * Whether the conversion was for a non personalized ad.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getNonPersonalizedAd() {
    return nonPersonalizedAd;
  }

  /**
   * Whether the conversion was for a non personalized ad.
   * @param nonPersonalizedAd nonPersonalizedAd or {@code null} for none
   */
  public Conversion setNonPersonalizedAd(java.lang.Boolean nonPersonalizedAd) {
    this.nonPersonalizedAd = nonPersonalizedAd;
    return this;
  }

  /**
   * The ordinal of the conversion. Use this field to control how conversions of the same user and
   * day are de-duplicated. This is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.String getOrdinal() {
    return ordinal;
  }

  /**
   * The ordinal of the conversion. Use this field to control how conversions of the same user and
   * day are de-duplicated. This is a required field.
   * @param ordinal ordinal or {@code null} for none
   */
  public Conversion setOrdinal(java.lang.String ordinal) {
    this.ordinal = ordinal;
    return this;
  }

  /**
   * The quantity of the conversion.
   * @return value or {@code null} for none
   */
  public java.lang.Long getQuantity() {
    return quantity;
  }

  /**
   * The quantity of the conversion.
   * @param quantity quantity or {@code null} for none
   */
  public Conversion setQuantity(java.lang.Long quantity) {
    this.quantity = quantity;
    return this;
  }

  /**
   * The timestamp of conversion, in Unix epoch micros. This is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTimestampMicros() {
    return timestampMicros;
  }

  /**
   * The timestamp of conversion, in Unix epoch micros. This is a required field.
   * @param timestampMicros timestampMicros or {@code null} for none
   */
  public Conversion setTimestampMicros(java.lang.Long timestampMicros) {
    this.timestampMicros = timestampMicros;
    return this;
  }

  /**
   * Whether this particular request may come from a user under the age of 16 (may differ by
   * country), under compliance with the European Union's General Data Protection Regulation (GDPR).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getTreatmentForUnderage() {
    return treatmentForUnderage;
  }

  /**
   * Whether this particular request may come from a user under the age of 16 (may differ by
   * country), under compliance with the European Union's General Data Protection Regulation (GDPR).
   * @param treatmentForUnderage treatmentForUnderage or {@code null} for none
   */
  public Conversion setTreatmentForUnderage(java.lang.Boolean treatmentForUnderage) {
    this.treatmentForUnderage = treatmentForUnderage;
    return this;
  }

  /**
   * The value of the conversion.
   * @return value or {@code null} for none
   */
  public java.lang.Double getValue() {
    return value;
  }

  /**
   * The value of the conversion.
   * @param value value or {@code null} for none
   */
  public Conversion setValue(java.lang.Double value) {
    this.value = value;
    return this;
  }

  @Override
  public Conversion set(String fieldName, Object value) {
    return (Conversion) super.set(fieldName, value);
  }

  @Override
  public Conversion clone() {
    return (Conversion) super.clone();
  }

}
