/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Creative Asset.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreativeAsset extends com.google.api.client.json.GenericJson {

  /**
   * Whether ActionScript3 is enabled for the flash asset. This is a read-only field. Applicable to
   * the following creative type: FLASH_INPAGE. Applicable to DISPLAY when the primary asset type is
   * not HTML_IMAGE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean actionScript3;

  /**
   * Whether the video or audio asset is active. This is a read-only field for
   * VPAID_NON_LINEAR_VIDEO assets. Applicable to the following creative types: INSTREAM_AUDIO,
   * INSTREAM_VIDEO and all VPAID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean active;

  /**
   * Additional sizes associated with this creative asset. HTML5 asset generated by compatible
   * software such as GWD will be able to support more sizes this creative asset can render.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Size> additionalSizes;

  /**
   * Possible alignments for an asset. This is a read-only field. Applicable to the following
   * creative types: RICH_MEDIA_DISPLAY_MULTI_FLOATING_INTERSTITIAL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String alignment;

  /**
   * Artwork type of rich media creative. This is a read-only field. Applicable to the following
   * creative types: all RICH_MEDIA.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String artworkType;

  /**
   * Identifier of this asset. This is the same identifier returned during creative asset insert
   * operation. This is a required field. Applicable to all but the following creative types: all
   * REDIRECT and TRACKING_TEXT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreativeAssetId assetIdentifier;

  /**
   * Audio stream bit rate in kbps. This is a read-only field. Applicable to the following creative
   * types: INSTREAM_AUDIO, INSTREAM_VIDEO and all VPAID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer audioBitRate;

  /**
   * Audio sample bit rate in hertz. This is a read-only field. Applicable to the following creative
   * types: INSTREAM_AUDIO, INSTREAM_VIDEO and all VPAID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer audioSampleRate;

  /**
   * Exit event configured for the backup image. Applicable to the following creative types: all
   * RICH_MEDIA.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreativeCustomEvent backupImageExit;

  /**
   * Detected bit-rate for audio or video asset. This is a read-only field. Applicable to the
   * following creative types: INSTREAM_AUDIO, INSTREAM_VIDEO and all VPAID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer bitRate;

  /**
   * Rich media child asset type. This is a read-only field. Applicable to the following creative
   * types: all VPAID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String childAssetType;

  /**
   * Size of an asset when collapsed. This is a read-only field. Applicable to the following
   * creative types: all RICH_MEDIA and all VPAID. Additionally, applicable to assets whose
   * displayType is ASSET_DISPLAY_TYPE_EXPANDING or ASSET_DISPLAY_TYPE_PEEL_DOWN.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Size collapsedSize;

  /**
   * List of companion creatives assigned to an in-stream video creative asset. Acceptable values
   * include IDs of existing flash and image creatives. Applicable to INSTREAM_VIDEO creative type
   * with dynamicAssetSelection set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> companionCreativeIds;

  /**
   * Custom start time in seconds for making the asset visible. Applicable to the following creative
   * types: all RICH_MEDIA. Value must be greater than or equal to 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer customStartTimeValue;

  /**
   * List of feature dependencies for the creative asset that are detected by Campaign Manager.
   * Feature dependencies are features that a browser must be able to support in order to render
   * your HTML5 creative correctly. This is a read-only, auto-generated field. Applicable to the
   * following creative types: HTML5_BANNER. Applicable to DISPLAY when the primary asset type is
   * not HTML_IMAGE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> detectedFeatures;

  /**
   * Type of rich media asset. This is a read-only field. Applicable to the following creative
   * types: all RICH_MEDIA.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayType;

  /**
   * Duration in seconds for which an asset will be displayed. Applicable to the following creative
   * types: INSTREAM_AUDIO, INSTREAM_VIDEO and VPAID_LINEAR_VIDEO. Value must be greater than or
   * equal to 1.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer duration;

  /**
   * Duration type for which an asset will be displayed. Applicable to the following creative types:
   * all RICH_MEDIA.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String durationType;

  /**
   * Detected expanded dimension for video asset. This is a read-only field. Applicable to the
   * following creative types: INSTREAM_VIDEO and all VPAID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Size expandedDimension;

  /**
   * File size associated with this creative asset. This is a read-only field. Applicable to all but
   * the following creative types: all REDIRECT and TRACKING_TEXT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long fileSize;

  /**
   * Flash version of the asset. This is a read-only field. Applicable to the following creative
   * types: FLASH_INPAGE, all RICH_MEDIA, and all VPAID. Applicable to DISPLAY when the primary
   * asset type is not HTML_IMAGE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer flashVersion;

  /**
   * Video frame rate for video asset in frames per second. This is a read-only field. Applicable to
   * the following creative types: INSTREAM_VIDEO and all VPAID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float frameRate;

  /**
   * Whether to hide Flash objects flag for an asset. Applicable to the following creative types:
   * all RICH_MEDIA.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hideFlashObjects;

  /**
   * Whether to hide selection boxes flag for an asset. Applicable to the following creative types:
   * all RICH_MEDIA.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hideSelectionBoxes;

  /**
   * Whether the asset is horizontally locked. This is a read-only field. Applicable to the
   * following creative types: all RICH_MEDIA.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean horizontallyLocked;

  /**
   * Numeric ID of this creative asset. This is a required field and should not be modified.
   * Applicable to all but the following creative types: all REDIRECT and TRACKING_TEXT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Dimension value for the ID of the asset. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionValue idDimensionValue;

  /**
   * Detected duration for audio or video asset. This is a read-only field. Applicable to the
   * following creative types: INSTREAM_AUDIO, INSTREAM_VIDEO and all VPAID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float mediaDuration;

  /**
   * Detected MIME type for audio or video asset. This is a read-only field. Applicable to the
   * following creative types: INSTREAM_AUDIO, INSTREAM_VIDEO and all VPAID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mimeType;

  /**
   * Offset position for an asset in collapsed mode. This is a read-only field. Applicable to the
   * following creative types: all RICH_MEDIA and all VPAID. Additionally, only applicable to assets
   * whose displayType is ASSET_DISPLAY_TYPE_EXPANDING or ASSET_DISPLAY_TYPE_PEEL_DOWN.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OffsetPosition offset;

  /**
   * Orientation of video asset. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String orientation;

  /**
   * Whether the backup asset is original or changed by the user in Campaign Manager. Applicable to
   * the following creative types: all RICH_MEDIA.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean originalBackup;

  /**
   * Whether this asset is used as a polite load asset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean politeLoad;

  /**
   * Offset position for an asset. Applicable to the following creative types: all RICH_MEDIA.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OffsetPosition position;

  /**
   * Offset left unit for an asset. This is a read-only field. Applicable to the following creative
   * types: all RICH_MEDIA.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String positionLeftUnit;

  /**
   * Offset top unit for an asset. This is a read-only field if the asset displayType is
   * ASSET_DISPLAY_TYPE_OVERLAY. Applicable to the following creative types: all RICH_MEDIA.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String positionTopUnit;

  /**
   * Progressive URL for video asset. This is a read-only field. Applicable to the following
   * creative types: INSTREAM_VIDEO and all VPAID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String progressiveServingUrl;

  /**
   * Whether the asset pushes down other content. Applicable to the following creative types: all
   * RICH_MEDIA. Additionally, only applicable when the asset offsets are 0, the collapsedSize.width
   * matches size.width, and the collapsedSize.height is less than size.height.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean pushdown;

  /**
   * Pushdown duration in seconds for an asset. Applicable to the following creative types: all
   * RICH_MEDIA.Additionally, only applicable when the asset pushdown field is true, the offsets are
   * 0, the collapsedSize.width matches size.width, and the collapsedSize.height is less than
   * size.height. Acceptable values are 0 to 9.99, inclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float pushdownDuration;

  /**
   * Role of the asset in relation to creative. Applicable to all but the following creative types:
   * all REDIRECT and TRACKING_TEXT. This is a required field. PRIMARY applies to DISPLAY,
   * FLASH_INPAGE, HTML5_BANNER, IMAGE, DISPLAY_IMAGE_GALLERY, all RICH_MEDIA (which may contain
   * multiple primary assets), and all VPAID creatives. BACKUP_IMAGE applies to FLASH_INPAGE,
   * HTML5_BANNER, all RICH_MEDIA, and all VPAID creatives. Applicable to DISPLAY when the primary
   * asset type is not HTML_IMAGE. ADDITIONAL_IMAGE and ADDITIONAL_FLASH apply to FLASH_INPAGE
   * creatives. OTHER refers to assets from sources other than Campaign Manager, such as Studio
   * uploaded assets, applicable to all RICH_MEDIA and all VPAID creatives. PARENT_VIDEO refers to
   * videos uploaded by the user in Campaign Manager and is applicable to INSTREAM_VIDEO and
   * VPAID_LINEAR_VIDEO creatives. TRANSCODED_VIDEO refers to videos transcoded by Campaign Manager
   * from PARENT_VIDEO assets and is applicable to INSTREAM_VIDEO and VPAID_LINEAR_VIDEO creatives.
   * ALTERNATE_VIDEO refers to the Campaign Manager representation of child asset videos from
   * Studio, and is applicable to VPAID_LINEAR_VIDEO creatives. These cannot be added or removed
   * within Campaign Manager. For VPAID_LINEAR_VIDEO creatives, PARENT_VIDEO, TRANSCODED_VIDEO and
   * ALTERNATE_VIDEO assets that are marked active serve as backup in case the VPAID creative cannot
   * be served. Only PARENT_VIDEO assets can be added or removed for an INSTREAM_VIDEO or
   * VPAID_LINEAR_VIDEO creative. PARENT_AUDIO refers to audios uploaded by the user in Campaign
   * Manager and is applicable to INSTREAM_AUDIO creatives. TRANSCODED_AUDIO refers to audios
   * transcoded by Campaign Manager from PARENT_AUDIO assets and is applicable to INSTREAM_AUDIO
   * creatives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String role;

  /**
   * Size associated with this creative asset. This is a required field when applicable; however for
   * IMAGE and FLASH_INPAGE, creatives if left blank, this field will be automatically set using the
   * actual size of the associated image asset. Applicable to the following creative types:
   * DISPLAY_IMAGE_GALLERY, FLASH_INPAGE, HTML5_BANNER, IMAGE, and all RICH_MEDIA. Applicable to
   * DISPLAY when the primary asset type is not HTML_IMAGE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Size size;

  /**
   * Whether the asset is SSL-compliant. This is a read-only field. Applicable to all but the
   * following creative types: all REDIRECT and TRACKING_TEXT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean sslCompliant;

  /**
   * Initial wait time type before making the asset visible. Applicable to the following creative
   * types: all RICH_MEDIA.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String startTimeType;

  /**
   * Streaming URL for video asset. This is a read-only field. Applicable to the following creative
   * types: INSTREAM_VIDEO and all VPAID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String streamingServingUrl;

  /**
   * Whether the asset is transparent. Applicable to the following creative types: all RICH_MEDIA.
   * Additionally, only applicable to HTML5 assets.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean transparency;

  /**
   * Whether the asset is vertically locked. This is a read-only field. Applicable to the following
   * creative types: all RICH_MEDIA.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean verticallyLocked;

  /**
   * Window mode options for flash assets. Applicable to the following creative types: FLASH_INPAGE,
   * RICH_MEDIA_DISPLAY_EXPANDING, RICH_MEDIA_IM_EXPAND, RICH_MEDIA_DISPLAY_BANNER, and
   * RICH_MEDIA_INPAGE_FLOATING.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String windowMode;

  /**
   * zIndex value of an asset. Applicable to the following creative types: all
   * RICH_MEDIA.Additionally, only applicable to assets whose displayType is NOT one of the
   * following types: ASSET_DISPLAY_TYPE_INPAGE or ASSET_DISPLAY_TYPE_OVERLAY. Acceptable values are
   * -999999999 to 999999999, inclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer zIndex;

  /**
   * File name of zip file. This is a read-only field. Applicable to the following creative types:
   * HTML5_BANNER.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zipFilename;

  /**
   * Size of zip file. This is a read-only field. Applicable to the following creative types:
   * HTML5_BANNER.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zipFilesize;

  /**
   * Whether ActionScript3 is enabled for the flash asset. This is a read-only field. Applicable to
   * the following creative type: FLASH_INPAGE. Applicable to DISPLAY when the primary asset type is
   * not HTML_IMAGE.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getActionScript3() {
    return actionScript3;
  }

  /**
   * Whether ActionScript3 is enabled for the flash asset. This is a read-only field. Applicable to
   * the following creative type: FLASH_INPAGE. Applicable to DISPLAY when the primary asset type is
   * not HTML_IMAGE.
   * @param actionScript3 actionScript3 or {@code null} for none
   */
  public CreativeAsset setActionScript3(java.lang.Boolean actionScript3) {
    this.actionScript3 = actionScript3;
    return this;
  }

  /**
   * Whether the video or audio asset is active. This is a read-only field for
   * VPAID_NON_LINEAR_VIDEO assets. Applicable to the following creative types: INSTREAM_AUDIO,
   * INSTREAM_VIDEO and all VPAID.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getActive() {
    return active;
  }

  /**
   * Whether the video or audio asset is active. This is a read-only field for
   * VPAID_NON_LINEAR_VIDEO assets. Applicable to the following creative types: INSTREAM_AUDIO,
   * INSTREAM_VIDEO and all VPAID.
   * @param active active or {@code null} for none
   */
  public CreativeAsset setActive(java.lang.Boolean active) {
    this.active = active;
    return this;
  }

  /**
   * Additional sizes associated with this creative asset. HTML5 asset generated by compatible
   * software such as GWD will be able to support more sizes this creative asset can render.
   * @return value or {@code null} for none
   */
  public java.util.List<Size> getAdditionalSizes() {
    return additionalSizes;
  }

  /**
   * Additional sizes associated with this creative asset. HTML5 asset generated by compatible
   * software such as GWD will be able to support more sizes this creative asset can render.
   * @param additionalSizes additionalSizes or {@code null} for none
   */
  public CreativeAsset setAdditionalSizes(java.util.List<Size> additionalSizes) {
    this.additionalSizes = additionalSizes;
    return this;
  }

  /**
   * Possible alignments for an asset. This is a read-only field. Applicable to the following
   * creative types: RICH_MEDIA_DISPLAY_MULTI_FLOATING_INTERSTITIAL.
   * @return value or {@code null} for none
   */
  public java.lang.String getAlignment() {
    return alignment;
  }

  /**
   * Possible alignments for an asset. This is a read-only field. Applicable to the following
   * creative types: RICH_MEDIA_DISPLAY_MULTI_FLOATING_INTERSTITIAL.
   * @param alignment alignment or {@code null} for none
   */
  public CreativeAsset setAlignment(java.lang.String alignment) {
    this.alignment = alignment;
    return this;
  }

  /**
   * Artwork type of rich media creative. This is a read-only field. Applicable to the following
   * creative types: all RICH_MEDIA.
   * @return value or {@code null} for none
   */
  public java.lang.String getArtworkType() {
    return artworkType;
  }

  /**
   * Artwork type of rich media creative. This is a read-only field. Applicable to the following
   * creative types: all RICH_MEDIA.
   * @param artworkType artworkType or {@code null} for none
   */
  public CreativeAsset setArtworkType(java.lang.String artworkType) {
    this.artworkType = artworkType;
    return this;
  }

  /**
   * Identifier of this asset. This is the same identifier returned during creative asset insert
   * operation. This is a required field. Applicable to all but the following creative types: all
   * REDIRECT and TRACKING_TEXT.
   * @return value or {@code null} for none
   */
  public CreativeAssetId getAssetIdentifier() {
    return assetIdentifier;
  }

  /**
   * Identifier of this asset. This is the same identifier returned during creative asset insert
   * operation. This is a required field. Applicable to all but the following creative types: all
   * REDIRECT and TRACKING_TEXT.
   * @param assetIdentifier assetIdentifier or {@code null} for none
   */
  public CreativeAsset setAssetIdentifier(CreativeAssetId assetIdentifier) {
    this.assetIdentifier = assetIdentifier;
    return this;
  }

  /**
   * Audio stream bit rate in kbps. This is a read-only field. Applicable to the following creative
   * types: INSTREAM_AUDIO, INSTREAM_VIDEO and all VPAID.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getAudioBitRate() {
    return audioBitRate;
  }

  /**
   * Audio stream bit rate in kbps. This is a read-only field. Applicable to the following creative
   * types: INSTREAM_AUDIO, INSTREAM_VIDEO and all VPAID.
   * @param audioBitRate audioBitRate or {@code null} for none
   */
  public CreativeAsset setAudioBitRate(java.lang.Integer audioBitRate) {
    this.audioBitRate = audioBitRate;
    return this;
  }

  /**
   * Audio sample bit rate in hertz. This is a read-only field. Applicable to the following creative
   * types: INSTREAM_AUDIO, INSTREAM_VIDEO and all VPAID.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getAudioSampleRate() {
    return audioSampleRate;
  }

  /**
   * Audio sample bit rate in hertz. This is a read-only field. Applicable to the following creative
   * types: INSTREAM_AUDIO, INSTREAM_VIDEO and all VPAID.
   * @param audioSampleRate audioSampleRate or {@code null} for none
   */
  public CreativeAsset setAudioSampleRate(java.lang.Integer audioSampleRate) {
    this.audioSampleRate = audioSampleRate;
    return this;
  }

  /**
   * Exit event configured for the backup image. Applicable to the following creative types: all
   * RICH_MEDIA.
   * @return value or {@code null} for none
   */
  public CreativeCustomEvent getBackupImageExit() {
    return backupImageExit;
  }

  /**
   * Exit event configured for the backup image. Applicable to the following creative types: all
   * RICH_MEDIA.
   * @param backupImageExit backupImageExit or {@code null} for none
   */
  public CreativeAsset setBackupImageExit(CreativeCustomEvent backupImageExit) {
    this.backupImageExit = backupImageExit;
    return this;
  }

  /**
   * Detected bit-rate for audio or video asset. This is a read-only field. Applicable to the
   * following creative types: INSTREAM_AUDIO, INSTREAM_VIDEO and all VPAID.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getBitRate() {
    return bitRate;
  }

  /**
   * Detected bit-rate for audio or video asset. This is a read-only field. Applicable to the
   * following creative types: INSTREAM_AUDIO, INSTREAM_VIDEO and all VPAID.
   * @param bitRate bitRate or {@code null} for none
   */
  public CreativeAsset setBitRate(java.lang.Integer bitRate) {
    this.bitRate = bitRate;
    return this;
  }

  /**
   * Rich media child asset type. This is a read-only field. Applicable to the following creative
   * types: all VPAID.
   * @return value or {@code null} for none
   */
  public java.lang.String getChildAssetType() {
    return childAssetType;
  }

  /**
   * Rich media child asset type. This is a read-only field. Applicable to the following creative
   * types: all VPAID.
   * @param childAssetType childAssetType or {@code null} for none
   */
  public CreativeAsset setChildAssetType(java.lang.String childAssetType) {
    this.childAssetType = childAssetType;
    return this;
  }

  /**
   * Size of an asset when collapsed. This is a read-only field. Applicable to the following
   * creative types: all RICH_MEDIA and all VPAID. Additionally, applicable to assets whose
   * displayType is ASSET_DISPLAY_TYPE_EXPANDING or ASSET_DISPLAY_TYPE_PEEL_DOWN.
   * @return value or {@code null} for none
   */
  public Size getCollapsedSize() {
    return collapsedSize;
  }

  /**
   * Size of an asset when collapsed. This is a read-only field. Applicable to the following
   * creative types: all RICH_MEDIA and all VPAID. Additionally, applicable to assets whose
   * displayType is ASSET_DISPLAY_TYPE_EXPANDING or ASSET_DISPLAY_TYPE_PEEL_DOWN.
   * @param collapsedSize collapsedSize or {@code null} for none
   */
  public CreativeAsset setCollapsedSize(Size collapsedSize) {
    this.collapsedSize = collapsedSize;
    return this;
  }

  /**
   * List of companion creatives assigned to an in-stream video creative asset. Acceptable values
   * include IDs of existing flash and image creatives. Applicable to INSTREAM_VIDEO creative type
   * with dynamicAssetSelection set to true.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getCompanionCreativeIds() {
    return companionCreativeIds;
  }

  /**
   * List of companion creatives assigned to an in-stream video creative asset. Acceptable values
   * include IDs of existing flash and image creatives. Applicable to INSTREAM_VIDEO creative type
   * with dynamicAssetSelection set to true.
   * @param companionCreativeIds companionCreativeIds or {@code null} for none
   */
  public CreativeAsset setCompanionCreativeIds(java.util.List<java.lang.Long> companionCreativeIds) {
    this.companionCreativeIds = companionCreativeIds;
    return this;
  }

  /**
   * Custom start time in seconds for making the asset visible. Applicable to the following creative
   * types: all RICH_MEDIA. Value must be greater than or equal to 0.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCustomStartTimeValue() {
    return customStartTimeValue;
  }

  /**
   * Custom start time in seconds for making the asset visible. Applicable to the following creative
   * types: all RICH_MEDIA. Value must be greater than or equal to 0.
   * @param customStartTimeValue customStartTimeValue or {@code null} for none
   */
  public CreativeAsset setCustomStartTimeValue(java.lang.Integer customStartTimeValue) {
    this.customStartTimeValue = customStartTimeValue;
    return this;
  }

  /**
   * List of feature dependencies for the creative asset that are detected by Campaign Manager.
   * Feature dependencies are features that a browser must be able to support in order to render
   * your HTML5 creative correctly. This is a read-only, auto-generated field. Applicable to the
   * following creative types: HTML5_BANNER. Applicable to DISPLAY when the primary asset type is
   * not HTML_IMAGE.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDetectedFeatures() {
    return detectedFeatures;
  }

  /**
   * List of feature dependencies for the creative asset that are detected by Campaign Manager.
   * Feature dependencies are features that a browser must be able to support in order to render
   * your HTML5 creative correctly. This is a read-only, auto-generated field. Applicable to the
   * following creative types: HTML5_BANNER. Applicable to DISPLAY when the primary asset type is
   * not HTML_IMAGE.
   * @param detectedFeatures detectedFeatures or {@code null} for none
   */
  public CreativeAsset setDetectedFeatures(java.util.List<java.lang.String> detectedFeatures) {
    this.detectedFeatures = detectedFeatures;
    return this;
  }

  /**
   * Type of rich media asset. This is a read-only field. Applicable to the following creative
   * types: all RICH_MEDIA.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayType() {
    return displayType;
  }

  /**
   * Type of rich media asset. This is a read-only field. Applicable to the following creative
   * types: all RICH_MEDIA.
   * @param displayType displayType or {@code null} for none
   */
  public CreativeAsset setDisplayType(java.lang.String displayType) {
    this.displayType = displayType;
    return this;
  }

  /**
   * Duration in seconds for which an asset will be displayed. Applicable to the following creative
   * types: INSTREAM_AUDIO, INSTREAM_VIDEO and VPAID_LINEAR_VIDEO. Value must be greater than or
   * equal to 1.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getDuration() {
    return duration;
  }

  /**
   * Duration in seconds for which an asset will be displayed. Applicable to the following creative
   * types: INSTREAM_AUDIO, INSTREAM_VIDEO and VPAID_LINEAR_VIDEO. Value must be greater than or
   * equal to 1.
   * @param duration duration or {@code null} for none
   */
  public CreativeAsset setDuration(java.lang.Integer duration) {
    this.duration = duration;
    return this;
  }

  /**
   * Duration type for which an asset will be displayed. Applicable to the following creative types:
   * all RICH_MEDIA.
   * @return value or {@code null} for none
   */
  public java.lang.String getDurationType() {
    return durationType;
  }

  /**
   * Duration type for which an asset will be displayed. Applicable to the following creative types:
   * all RICH_MEDIA.
   * @param durationType durationType or {@code null} for none
   */
  public CreativeAsset setDurationType(java.lang.String durationType) {
    this.durationType = durationType;
    return this;
  }

  /**
   * Detected expanded dimension for video asset. This is a read-only field. Applicable to the
   * following creative types: INSTREAM_VIDEO and all VPAID.
   * @return value or {@code null} for none
   */
  public Size getExpandedDimension() {
    return expandedDimension;
  }

  /**
   * Detected expanded dimension for video asset. This is a read-only field. Applicable to the
   * following creative types: INSTREAM_VIDEO and all VPAID.
   * @param expandedDimension expandedDimension or {@code null} for none
   */
  public CreativeAsset setExpandedDimension(Size expandedDimension) {
    this.expandedDimension = expandedDimension;
    return this;
  }

  /**
   * File size associated with this creative asset. This is a read-only field. Applicable to all but
   * the following creative types: all REDIRECT and TRACKING_TEXT.
   * @return value or {@code null} for none
   */
  public java.lang.Long getFileSize() {
    return fileSize;
  }

  /**
   * File size associated with this creative asset. This is a read-only field. Applicable to all but
   * the following creative types: all REDIRECT and TRACKING_TEXT.
   * @param fileSize fileSize or {@code null} for none
   */
  public CreativeAsset setFileSize(java.lang.Long fileSize) {
    this.fileSize = fileSize;
    return this;
  }

  /**
   * Flash version of the asset. This is a read-only field. Applicable to the following creative
   * types: FLASH_INPAGE, all RICH_MEDIA, and all VPAID. Applicable to DISPLAY when the primary
   * asset type is not HTML_IMAGE.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getFlashVersion() {
    return flashVersion;
  }

  /**
   * Flash version of the asset. This is a read-only field. Applicable to the following creative
   * types: FLASH_INPAGE, all RICH_MEDIA, and all VPAID. Applicable to DISPLAY when the primary
   * asset type is not HTML_IMAGE.
   * @param flashVersion flashVersion or {@code null} for none
   */
  public CreativeAsset setFlashVersion(java.lang.Integer flashVersion) {
    this.flashVersion = flashVersion;
    return this;
  }

  /**
   * Video frame rate for video asset in frames per second. This is a read-only field. Applicable to
   * the following creative types: INSTREAM_VIDEO and all VPAID.
   * @return value or {@code null} for none
   */
  public java.lang.Float getFrameRate() {
    return frameRate;
  }

  /**
   * Video frame rate for video asset in frames per second. This is a read-only field. Applicable to
   * the following creative types: INSTREAM_VIDEO and all VPAID.
   * @param frameRate frameRate or {@code null} for none
   */
  public CreativeAsset setFrameRate(java.lang.Float frameRate) {
    this.frameRate = frameRate;
    return this;
  }

  /**
   * Whether to hide Flash objects flag for an asset. Applicable to the following creative types:
   * all RICH_MEDIA.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHideFlashObjects() {
    return hideFlashObjects;
  }

  /**
   * Whether to hide Flash objects flag for an asset. Applicable to the following creative types:
   * all RICH_MEDIA.
   * @param hideFlashObjects hideFlashObjects or {@code null} for none
   */
  public CreativeAsset setHideFlashObjects(java.lang.Boolean hideFlashObjects) {
    this.hideFlashObjects = hideFlashObjects;
    return this;
  }

  /**
   * Whether to hide selection boxes flag for an asset. Applicable to the following creative types:
   * all RICH_MEDIA.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHideSelectionBoxes() {
    return hideSelectionBoxes;
  }

  /**
   * Whether to hide selection boxes flag for an asset. Applicable to the following creative types:
   * all RICH_MEDIA.
   * @param hideSelectionBoxes hideSelectionBoxes or {@code null} for none
   */
  public CreativeAsset setHideSelectionBoxes(java.lang.Boolean hideSelectionBoxes) {
    this.hideSelectionBoxes = hideSelectionBoxes;
    return this;
  }

  /**
   * Whether the asset is horizontally locked. This is a read-only field. Applicable to the
   * following creative types: all RICH_MEDIA.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHorizontallyLocked() {
    return horizontallyLocked;
  }

  /**
   * Whether the asset is horizontally locked. This is a read-only field. Applicable to the
   * following creative types: all RICH_MEDIA.
   * @param horizontallyLocked horizontallyLocked or {@code null} for none
   */
  public CreativeAsset setHorizontallyLocked(java.lang.Boolean horizontallyLocked) {
    this.horizontallyLocked = horizontallyLocked;
    return this;
  }

  /**
   * Numeric ID of this creative asset. This is a required field and should not be modified.
   * Applicable to all but the following creative types: all REDIRECT and TRACKING_TEXT.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * Numeric ID of this creative asset. This is a required field and should not be modified.
   * Applicable to all but the following creative types: all REDIRECT and TRACKING_TEXT.
   * @param id id or {@code null} for none
   */
  public CreativeAsset setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Dimension value for the ID of the asset. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public DimensionValue getIdDimensionValue() {
    return idDimensionValue;
  }

  /**
   * Dimension value for the ID of the asset. This is a read-only, auto-generated field.
   * @param idDimensionValue idDimensionValue or {@code null} for none
   */
  public CreativeAsset setIdDimensionValue(DimensionValue idDimensionValue) {
    this.idDimensionValue = idDimensionValue;
    return this;
  }

  /**
   * Detected duration for audio or video asset. This is a read-only field. Applicable to the
   * following creative types: INSTREAM_AUDIO, INSTREAM_VIDEO and all VPAID.
   * @return value or {@code null} for none
   */
  public java.lang.Float getMediaDuration() {
    return mediaDuration;
  }

  /**
   * Detected duration for audio or video asset. This is a read-only field. Applicable to the
   * following creative types: INSTREAM_AUDIO, INSTREAM_VIDEO and all VPAID.
   * @param mediaDuration mediaDuration or {@code null} for none
   */
  public CreativeAsset setMediaDuration(java.lang.Float mediaDuration) {
    this.mediaDuration = mediaDuration;
    return this;
  }

  /**
   * Detected MIME type for audio or video asset. This is a read-only field. Applicable to the
   * following creative types: INSTREAM_AUDIO, INSTREAM_VIDEO and all VPAID.
   * @return value or {@code null} for none
   */
  public java.lang.String getMimeType() {
    return mimeType;
  }

  /**
   * Detected MIME type for audio or video asset. This is a read-only field. Applicable to the
   * following creative types: INSTREAM_AUDIO, INSTREAM_VIDEO and all VPAID.
   * @param mimeType mimeType or {@code null} for none
   */
  public CreativeAsset setMimeType(java.lang.String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

  /**
   * Offset position for an asset in collapsed mode. This is a read-only field. Applicable to the
   * following creative types: all RICH_MEDIA and all VPAID. Additionally, only applicable to assets
   * whose displayType is ASSET_DISPLAY_TYPE_EXPANDING or ASSET_DISPLAY_TYPE_PEEL_DOWN.
   * @return value or {@code null} for none
   */
  public OffsetPosition getOffset() {
    return offset;
  }

  /**
   * Offset position for an asset in collapsed mode. This is a read-only field. Applicable to the
   * following creative types: all RICH_MEDIA and all VPAID. Additionally, only applicable to assets
   * whose displayType is ASSET_DISPLAY_TYPE_EXPANDING or ASSET_DISPLAY_TYPE_PEEL_DOWN.
   * @param offset offset or {@code null} for none
   */
  public CreativeAsset setOffset(OffsetPosition offset) {
    this.offset = offset;
    return this;
  }

  /**
   * Orientation of video asset. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public java.lang.String getOrientation() {
    return orientation;
  }

  /**
   * Orientation of video asset. This is a read-only, auto-generated field.
   * @param orientation orientation or {@code null} for none
   */
  public CreativeAsset setOrientation(java.lang.String orientation) {
    this.orientation = orientation;
    return this;
  }

  /**
   * Whether the backup asset is original or changed by the user in Campaign Manager. Applicable to
   * the following creative types: all RICH_MEDIA.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getOriginalBackup() {
    return originalBackup;
  }

  /**
   * Whether the backup asset is original or changed by the user in Campaign Manager. Applicable to
   * the following creative types: all RICH_MEDIA.
   * @param originalBackup originalBackup or {@code null} for none
   */
  public CreativeAsset setOriginalBackup(java.lang.Boolean originalBackup) {
    this.originalBackup = originalBackup;
    return this;
  }

  /**
   * Whether this asset is used as a polite load asset.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPoliteLoad() {
    return politeLoad;
  }

  /**
   * Whether this asset is used as a polite load asset.
   * @param politeLoad politeLoad or {@code null} for none
   */
  public CreativeAsset setPoliteLoad(java.lang.Boolean politeLoad) {
    this.politeLoad = politeLoad;
    return this;
  }

  /**
   * Offset position for an asset. Applicable to the following creative types: all RICH_MEDIA.
   * @return value or {@code null} for none
   */
  public OffsetPosition getPosition() {
    return position;
  }

  /**
   * Offset position for an asset. Applicable to the following creative types: all RICH_MEDIA.
   * @param position position or {@code null} for none
   */
  public CreativeAsset setPosition(OffsetPosition position) {
    this.position = position;
    return this;
  }

  /**
   * Offset left unit for an asset. This is a read-only field. Applicable to the following creative
   * types: all RICH_MEDIA.
   * @return value or {@code null} for none
   */
  public java.lang.String getPositionLeftUnit() {
    return positionLeftUnit;
  }

  /**
   * Offset left unit for an asset. This is a read-only field. Applicable to the following creative
   * types: all RICH_MEDIA.
   * @param positionLeftUnit positionLeftUnit or {@code null} for none
   */
  public CreativeAsset setPositionLeftUnit(java.lang.String positionLeftUnit) {
    this.positionLeftUnit = positionLeftUnit;
    return this;
  }

  /**
   * Offset top unit for an asset. This is a read-only field if the asset displayType is
   * ASSET_DISPLAY_TYPE_OVERLAY. Applicable to the following creative types: all RICH_MEDIA.
   * @return value or {@code null} for none
   */
  public java.lang.String getPositionTopUnit() {
    return positionTopUnit;
  }

  /**
   * Offset top unit for an asset. This is a read-only field if the asset displayType is
   * ASSET_DISPLAY_TYPE_OVERLAY. Applicable to the following creative types: all RICH_MEDIA.
   * @param positionTopUnit positionTopUnit or {@code null} for none
   */
  public CreativeAsset setPositionTopUnit(java.lang.String positionTopUnit) {
    this.positionTopUnit = positionTopUnit;
    return this;
  }

  /**
   * Progressive URL for video asset. This is a read-only field. Applicable to the following
   * creative types: INSTREAM_VIDEO and all VPAID.
   * @return value or {@code null} for none
   */
  public java.lang.String getProgressiveServingUrl() {
    return progressiveServingUrl;
  }

  /**
   * Progressive URL for video asset. This is a read-only field. Applicable to the following
   * creative types: INSTREAM_VIDEO and all VPAID.
   * @param progressiveServingUrl progressiveServingUrl or {@code null} for none
   */
  public CreativeAsset setProgressiveServingUrl(java.lang.String progressiveServingUrl) {
    this.progressiveServingUrl = progressiveServingUrl;
    return this;
  }

  /**
   * Whether the asset pushes down other content. Applicable to the following creative types: all
   * RICH_MEDIA. Additionally, only applicable when the asset offsets are 0, the collapsedSize.width
   * matches size.width, and the collapsedSize.height is less than size.height.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPushdown() {
    return pushdown;
  }

  /**
   * Whether the asset pushes down other content. Applicable to the following creative types: all
   * RICH_MEDIA. Additionally, only applicable when the asset offsets are 0, the collapsedSize.width
   * matches size.width, and the collapsedSize.height is less than size.height.
   * @param pushdown pushdown or {@code null} for none
   */
  public CreativeAsset setPushdown(java.lang.Boolean pushdown) {
    this.pushdown = pushdown;
    return this;
  }

  /**
   * Pushdown duration in seconds for an asset. Applicable to the following creative types: all
   * RICH_MEDIA.Additionally, only applicable when the asset pushdown field is true, the offsets are
   * 0, the collapsedSize.width matches size.width, and the collapsedSize.height is less than
   * size.height. Acceptable values are 0 to 9.99, inclusive.
   * @return value or {@code null} for none
   */
  public java.lang.Float getPushdownDuration() {
    return pushdownDuration;
  }

  /**
   * Pushdown duration in seconds for an asset. Applicable to the following creative types: all
   * RICH_MEDIA.Additionally, only applicable when the asset pushdown field is true, the offsets are
   * 0, the collapsedSize.width matches size.width, and the collapsedSize.height is less than
   * size.height. Acceptable values are 0 to 9.99, inclusive.
   * @param pushdownDuration pushdownDuration or {@code null} for none
   */
  public CreativeAsset setPushdownDuration(java.lang.Float pushdownDuration) {
    this.pushdownDuration = pushdownDuration;
    return this;
  }

  /**
   * Role of the asset in relation to creative. Applicable to all but the following creative types:
   * all REDIRECT and TRACKING_TEXT. This is a required field. PRIMARY applies to DISPLAY,
   * FLASH_INPAGE, HTML5_BANNER, IMAGE, DISPLAY_IMAGE_GALLERY, all RICH_MEDIA (which may contain
   * multiple primary assets), and all VPAID creatives. BACKUP_IMAGE applies to FLASH_INPAGE,
   * HTML5_BANNER, all RICH_MEDIA, and all VPAID creatives. Applicable to DISPLAY when the primary
   * asset type is not HTML_IMAGE. ADDITIONAL_IMAGE and ADDITIONAL_FLASH apply to FLASH_INPAGE
   * creatives. OTHER refers to assets from sources other than Campaign Manager, such as Studio
   * uploaded assets, applicable to all RICH_MEDIA and all VPAID creatives. PARENT_VIDEO refers to
   * videos uploaded by the user in Campaign Manager and is applicable to INSTREAM_VIDEO and
   * VPAID_LINEAR_VIDEO creatives. TRANSCODED_VIDEO refers to videos transcoded by Campaign Manager
   * from PARENT_VIDEO assets and is applicable to INSTREAM_VIDEO and VPAID_LINEAR_VIDEO creatives.
   * ALTERNATE_VIDEO refers to the Campaign Manager representation of child asset videos from
   * Studio, and is applicable to VPAID_LINEAR_VIDEO creatives. These cannot be added or removed
   * within Campaign Manager. For VPAID_LINEAR_VIDEO creatives, PARENT_VIDEO, TRANSCODED_VIDEO and
   * ALTERNATE_VIDEO assets that are marked active serve as backup in case the VPAID creative cannot
   * be served. Only PARENT_VIDEO assets can be added or removed for an INSTREAM_VIDEO or
   * VPAID_LINEAR_VIDEO creative. PARENT_AUDIO refers to audios uploaded by the user in Campaign
   * Manager and is applicable to INSTREAM_AUDIO creatives. TRANSCODED_AUDIO refers to audios
   * transcoded by Campaign Manager from PARENT_AUDIO assets and is applicable to INSTREAM_AUDIO
   * creatives.
   * @return value or {@code null} for none
   */
  public java.lang.String getRole() {
    return role;
  }

  /**
   * Role of the asset in relation to creative. Applicable to all but the following creative types:
   * all REDIRECT and TRACKING_TEXT. This is a required field. PRIMARY applies to DISPLAY,
   * FLASH_INPAGE, HTML5_BANNER, IMAGE, DISPLAY_IMAGE_GALLERY, all RICH_MEDIA (which may contain
   * multiple primary assets), and all VPAID creatives. BACKUP_IMAGE applies to FLASH_INPAGE,
   * HTML5_BANNER, all RICH_MEDIA, and all VPAID creatives. Applicable to DISPLAY when the primary
   * asset type is not HTML_IMAGE. ADDITIONAL_IMAGE and ADDITIONAL_FLASH apply to FLASH_INPAGE
   * creatives. OTHER refers to assets from sources other than Campaign Manager, such as Studio
   * uploaded assets, applicable to all RICH_MEDIA and all VPAID creatives. PARENT_VIDEO refers to
   * videos uploaded by the user in Campaign Manager and is applicable to INSTREAM_VIDEO and
   * VPAID_LINEAR_VIDEO creatives. TRANSCODED_VIDEO refers to videos transcoded by Campaign Manager
   * from PARENT_VIDEO assets and is applicable to INSTREAM_VIDEO and VPAID_LINEAR_VIDEO creatives.
   * ALTERNATE_VIDEO refers to the Campaign Manager representation of child asset videos from
   * Studio, and is applicable to VPAID_LINEAR_VIDEO creatives. These cannot be added or removed
   * within Campaign Manager. For VPAID_LINEAR_VIDEO creatives, PARENT_VIDEO, TRANSCODED_VIDEO and
   * ALTERNATE_VIDEO assets that are marked active serve as backup in case the VPAID creative cannot
   * be served. Only PARENT_VIDEO assets can be added or removed for an INSTREAM_VIDEO or
   * VPAID_LINEAR_VIDEO creative. PARENT_AUDIO refers to audios uploaded by the user in Campaign
   * Manager and is applicable to INSTREAM_AUDIO creatives. TRANSCODED_AUDIO refers to audios
   * transcoded by Campaign Manager from PARENT_AUDIO assets and is applicable to INSTREAM_AUDIO
   * creatives.
   * @param role role or {@code null} for none
   */
  public CreativeAsset setRole(java.lang.String role) {
    this.role = role;
    return this;
  }

  /**
   * Size associated with this creative asset. This is a required field when applicable; however for
   * IMAGE and FLASH_INPAGE, creatives if left blank, this field will be automatically set using the
   * actual size of the associated image asset. Applicable to the following creative types:
   * DISPLAY_IMAGE_GALLERY, FLASH_INPAGE, HTML5_BANNER, IMAGE, and all RICH_MEDIA. Applicable to
   * DISPLAY when the primary asset type is not HTML_IMAGE.
   * @return value or {@code null} for none
   */
  public Size getSize() {
    return size;
  }

  /**
   * Size associated with this creative asset. This is a required field when applicable; however for
   * IMAGE and FLASH_INPAGE, creatives if left blank, this field will be automatically set using the
   * actual size of the associated image asset. Applicable to the following creative types:
   * DISPLAY_IMAGE_GALLERY, FLASH_INPAGE, HTML5_BANNER, IMAGE, and all RICH_MEDIA. Applicable to
   * DISPLAY when the primary asset type is not HTML_IMAGE.
   * @param size size or {@code null} for none
   */
  public CreativeAsset setSize(Size size) {
    this.size = size;
    return this;
  }

  /**
   * Whether the asset is SSL-compliant. This is a read-only field. Applicable to all but the
   * following creative types: all REDIRECT and TRACKING_TEXT.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSslCompliant() {
    return sslCompliant;
  }

  /**
   * Whether the asset is SSL-compliant. This is a read-only field. Applicable to all but the
   * following creative types: all REDIRECT and TRACKING_TEXT.
   * @param sslCompliant sslCompliant or {@code null} for none
   */
  public CreativeAsset setSslCompliant(java.lang.Boolean sslCompliant) {
    this.sslCompliant = sslCompliant;
    return this;
  }

  /**
   * Initial wait time type before making the asset visible. Applicable to the following creative
   * types: all RICH_MEDIA.
   * @return value or {@code null} for none
   */
  public java.lang.String getStartTimeType() {
    return startTimeType;
  }

  /**
   * Initial wait time type before making the asset visible. Applicable to the following creative
   * types: all RICH_MEDIA.
   * @param startTimeType startTimeType or {@code null} for none
   */
  public CreativeAsset setStartTimeType(java.lang.String startTimeType) {
    this.startTimeType = startTimeType;
    return this;
  }

  /**
   * Streaming URL for video asset. This is a read-only field. Applicable to the following creative
   * types: INSTREAM_VIDEO and all VPAID.
   * @return value or {@code null} for none
   */
  public java.lang.String getStreamingServingUrl() {
    return streamingServingUrl;
  }

  /**
   * Streaming URL for video asset. This is a read-only field. Applicable to the following creative
   * types: INSTREAM_VIDEO and all VPAID.
   * @param streamingServingUrl streamingServingUrl or {@code null} for none
   */
  public CreativeAsset setStreamingServingUrl(java.lang.String streamingServingUrl) {
    this.streamingServingUrl = streamingServingUrl;
    return this;
  }

  /**
   * Whether the asset is transparent. Applicable to the following creative types: all RICH_MEDIA.
   * Additionally, only applicable to HTML5 assets.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getTransparency() {
    return transparency;
  }

  /**
   * Whether the asset is transparent. Applicable to the following creative types: all RICH_MEDIA.
   * Additionally, only applicable to HTML5 assets.
   * @param transparency transparency or {@code null} for none
   */
  public CreativeAsset setTransparency(java.lang.Boolean transparency) {
    this.transparency = transparency;
    return this;
  }

  /**
   * Whether the asset is vertically locked. This is a read-only field. Applicable to the following
   * creative types: all RICH_MEDIA.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getVerticallyLocked() {
    return verticallyLocked;
  }

  /**
   * Whether the asset is vertically locked. This is a read-only field. Applicable to the following
   * creative types: all RICH_MEDIA.
   * @param verticallyLocked verticallyLocked or {@code null} for none
   */
  public CreativeAsset setVerticallyLocked(java.lang.Boolean verticallyLocked) {
    this.verticallyLocked = verticallyLocked;
    return this;
  }

  /**
   * Window mode options for flash assets. Applicable to the following creative types: FLASH_INPAGE,
   * RICH_MEDIA_DISPLAY_EXPANDING, RICH_MEDIA_IM_EXPAND, RICH_MEDIA_DISPLAY_BANNER, and
   * RICH_MEDIA_INPAGE_FLOATING.
   * @return value or {@code null} for none
   */
  public java.lang.String getWindowMode() {
    return windowMode;
  }

  /**
   * Window mode options for flash assets. Applicable to the following creative types: FLASH_INPAGE,
   * RICH_MEDIA_DISPLAY_EXPANDING, RICH_MEDIA_IM_EXPAND, RICH_MEDIA_DISPLAY_BANNER, and
   * RICH_MEDIA_INPAGE_FLOATING.
   * @param windowMode windowMode or {@code null} for none
   */
  public CreativeAsset setWindowMode(java.lang.String windowMode) {
    this.windowMode = windowMode;
    return this;
  }

  /**
   * zIndex value of an asset. Applicable to the following creative types: all
   * RICH_MEDIA.Additionally, only applicable to assets whose displayType is NOT one of the
   * following types: ASSET_DISPLAY_TYPE_INPAGE or ASSET_DISPLAY_TYPE_OVERLAY. Acceptable values are
   * -999999999 to 999999999, inclusive.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getZIndex() {
    return zIndex;
  }

  /**
   * zIndex value of an asset. Applicable to the following creative types: all
   * RICH_MEDIA.Additionally, only applicable to assets whose displayType is NOT one of the
   * following types: ASSET_DISPLAY_TYPE_INPAGE or ASSET_DISPLAY_TYPE_OVERLAY. Acceptable values are
   * -999999999 to 999999999, inclusive.
   * @param zIndex zIndex or {@code null} for none
   */
  public CreativeAsset setZIndex(java.lang.Integer zIndex) {
    this.zIndex = zIndex;
    return this;
  }

  /**
   * File name of zip file. This is a read-only field. Applicable to the following creative types:
   * HTML5_BANNER.
   * @return value or {@code null} for none
   */
  public java.lang.String getZipFilename() {
    return zipFilename;
  }

  /**
   * File name of zip file. This is a read-only field. Applicable to the following creative types:
   * HTML5_BANNER.
   * @param zipFilename zipFilename or {@code null} for none
   */
  public CreativeAsset setZipFilename(java.lang.String zipFilename) {
    this.zipFilename = zipFilename;
    return this;
  }

  /**
   * Size of zip file. This is a read-only field. Applicable to the following creative types:
   * HTML5_BANNER.
   * @return value or {@code null} for none
   */
  public java.lang.String getZipFilesize() {
    return zipFilesize;
  }

  /**
   * Size of zip file. This is a read-only field. Applicable to the following creative types:
   * HTML5_BANNER.
   * @param zipFilesize zipFilesize or {@code null} for none
   */
  public CreativeAsset setZipFilesize(java.lang.String zipFilesize) {
    this.zipFilesize = zipFilesize;
    return this;
  }

  @Override
  public CreativeAsset set(String fieldName, Object value) {
    return (CreativeAsset) super.set(fieldName, value);
  }

  @Override
  public CreativeAsset clone() {
    return (CreativeAsset) super.clone();
  }

}
