/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Creative Asset ID.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreativeAssetId extends com.google.api.client.json.GenericJson {

  /**
   * Name of the creative asset. This is a required field while inserting an asset. After insertion,
   * this assetIdentifier is used to identify the uploaded asset. Characters in the name must be
   * alphanumeric or one of the following: ".-_ ". Spaces are allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Type of asset to upload. This is a required field. FLASH and IMAGE are no longer supported for
   * new uploads. All image assets should use HTML_IMAGE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Name of the creative asset. This is a required field while inserting an asset. After insertion,
   * this assetIdentifier is used to identify the uploaded asset. Characters in the name must be
   * alphanumeric or one of the following: ".-_ ". Spaces are allowed.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the creative asset. This is a required field while inserting an asset. After insertion,
   * this assetIdentifier is used to identify the uploaded asset. Characters in the name must be
   * alphanumeric or one of the following: ".-_ ". Spaces are allowed.
   * @param name name or {@code null} for none
   */
  public CreativeAssetId setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Type of asset to upload. This is a required field. FLASH and IMAGE are no longer supported for
   * new uploads. All image assets should use HTML_IMAGE.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Type of asset to upload. This is a required field. FLASH and IMAGE are no longer supported for
   * new uploads. All image assets should use HTML_IMAGE.
   * @param type type or {@code null} for none
   */
  public CreativeAssetId setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public CreativeAssetId set(String fieldName, Object value) {
    return (CreativeAssetId) super.set(fieldName, value);
  }

  @Override
  public CreativeAssetId clone() {
    return (CreativeAssetId) super.clone();
  }

}
