/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * CreativeAssets contains properties of a creative asset file which will be uploaded or has already
 * been uploaded. Refer to the creative sample code for how to upload assets and insert a creative.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreativeAssetMetadata extends com.google.api.client.json.GenericJson {

  /**
   * ID of the creative asset. This is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreativeAssetId assetIdentifier;

  /**
   * List of detected click tags for assets. This is a read-only auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ClickTag> clickTags;

  static {
    // hack to force ProGuard to consider ClickTag used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ClickTag.class);
  }

  /**
   * List of feature dependencies for the creative asset that are detected by Campaign Manager.
   * Feature dependencies are features that a browser must be able to support in order to render
   * your HTML5 creative correctly. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> detectedFeatures;

  /**
   * Numeric ID of the asset. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Dimension value for the numeric ID of the asset. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionValue idDimensionValue;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#creativeAssetMetadata".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Rules validated during code generation that generated a warning. This is a read-only, auto-
   * generated field.
   *
   * Possible values are: - "ADMOB_REFERENCED" - "ASSET_FORMAT_UNSUPPORTED_DCM" - "ASSET_INVALID" -
   * "CLICK_TAG_HARD_CODED" - "CLICK_TAG_INVALID" - "CLICK_TAG_IN_GWD" - "CLICK_TAG_MISSING" -
   * "CLICK_TAG_MORE_THAN_ONE" - "CLICK_TAG_NON_TOP_LEVEL" - "COMPONENT_UNSUPPORTED_DCM" -
   * "ENABLER_UNSUPPORTED_METHOD_DCM" - "EXTERNAL_FILE_REFERENCED" - "FILE_DETAIL_EMPTY" -
   * "FILE_TYPE_INVALID" - "GWD_PROPERTIES_INVALID" - "HTML5_FEATURE_UNSUPPORTED" -
   * "LINKED_FILE_NOT_FOUND" - "MAX_FLASH_VERSION_11" - "MRAID_REFERENCED" - "NOT_SSL_COMPLIANT" -
   * "ORPHANED_ASSET" - "PRIMARY_HTML_MISSING" - "SVG_INVALID" - "ZIP_INVALID"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> warnedValidationRules;

  /**
   * ID of the creative asset. This is a required field.
   * @return value or {@code null} for none
   */
  public CreativeAssetId getAssetIdentifier() {
    return assetIdentifier;
  }

  /**
   * ID of the creative asset. This is a required field.
   * @param assetIdentifier assetIdentifier or {@code null} for none
   */
  public CreativeAssetMetadata setAssetIdentifier(CreativeAssetId assetIdentifier) {
    this.assetIdentifier = assetIdentifier;
    return this;
  }

  /**
   * List of detected click tags for assets. This is a read-only auto-generated field.
   * @return value or {@code null} for none
   */
  public java.util.List<ClickTag> getClickTags() {
    return clickTags;
  }

  /**
   * List of detected click tags for assets. This is a read-only auto-generated field.
   * @param clickTags clickTags or {@code null} for none
   */
  public CreativeAssetMetadata setClickTags(java.util.List<ClickTag> clickTags) {
    this.clickTags = clickTags;
    return this;
  }

  /**
   * List of feature dependencies for the creative asset that are detected by Campaign Manager.
   * Feature dependencies are features that a browser must be able to support in order to render
   * your HTML5 creative correctly. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDetectedFeatures() {
    return detectedFeatures;
  }

  /**
   * List of feature dependencies for the creative asset that are detected by Campaign Manager.
   * Feature dependencies are features that a browser must be able to support in order to render
   * your HTML5 creative correctly. This is a read-only, auto-generated field.
   * @param detectedFeatures detectedFeatures or {@code null} for none
   */
  public CreativeAssetMetadata setDetectedFeatures(java.util.List<java.lang.String> detectedFeatures) {
    this.detectedFeatures = detectedFeatures;
    return this;
  }

  /**
   * Numeric ID of the asset. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * Numeric ID of the asset. This is a read-only, auto-generated field.
   * @param id id or {@code null} for none
   */
  public CreativeAssetMetadata setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Dimension value for the numeric ID of the asset. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public DimensionValue getIdDimensionValue() {
    return idDimensionValue;
  }

  /**
   * Dimension value for the numeric ID of the asset. This is a read-only, auto-generated field.
   * @param idDimensionValue idDimensionValue or {@code null} for none
   */
  public CreativeAssetMetadata setIdDimensionValue(DimensionValue idDimensionValue) {
    this.idDimensionValue = idDimensionValue;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#creativeAssetMetadata".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#creativeAssetMetadata".
   * @param kind kind or {@code null} for none
   */
  public CreativeAssetMetadata setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Rules validated during code generation that generated a warning. This is a read-only, auto-
   * generated field.
   *
   * Possible values are: - "ADMOB_REFERENCED" - "ASSET_FORMAT_UNSUPPORTED_DCM" - "ASSET_INVALID" -
   * "CLICK_TAG_HARD_CODED" - "CLICK_TAG_INVALID" - "CLICK_TAG_IN_GWD" - "CLICK_TAG_MISSING" -
   * "CLICK_TAG_MORE_THAN_ONE" - "CLICK_TAG_NON_TOP_LEVEL" - "COMPONENT_UNSUPPORTED_DCM" -
   * "ENABLER_UNSUPPORTED_METHOD_DCM" - "EXTERNAL_FILE_REFERENCED" - "FILE_DETAIL_EMPTY" -
   * "FILE_TYPE_INVALID" - "GWD_PROPERTIES_INVALID" - "HTML5_FEATURE_UNSUPPORTED" -
   * "LINKED_FILE_NOT_FOUND" - "MAX_FLASH_VERSION_11" - "MRAID_REFERENCED" - "NOT_SSL_COMPLIANT" -
   * "ORPHANED_ASSET" - "PRIMARY_HTML_MISSING" - "SVG_INVALID" - "ZIP_INVALID"
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getWarnedValidationRules() {
    return warnedValidationRules;
  }

  /**
   * Rules validated during code generation that generated a warning. This is a read-only, auto-
   * generated field.
   *
   * Possible values are: - "ADMOB_REFERENCED" - "ASSET_FORMAT_UNSUPPORTED_DCM" - "ASSET_INVALID" -
   * "CLICK_TAG_HARD_CODED" - "CLICK_TAG_INVALID" - "CLICK_TAG_IN_GWD" - "CLICK_TAG_MISSING" -
   * "CLICK_TAG_MORE_THAN_ONE" - "CLICK_TAG_NON_TOP_LEVEL" - "COMPONENT_UNSUPPORTED_DCM" -
   * "ENABLER_UNSUPPORTED_METHOD_DCM" - "EXTERNAL_FILE_REFERENCED" - "FILE_DETAIL_EMPTY" -
   * "FILE_TYPE_INVALID" - "GWD_PROPERTIES_INVALID" - "HTML5_FEATURE_UNSUPPORTED" -
   * "LINKED_FILE_NOT_FOUND" - "MAX_FLASH_VERSION_11" - "MRAID_REFERENCED" - "NOT_SSL_COMPLIANT" -
   * "ORPHANED_ASSET" - "PRIMARY_HTML_MISSING" - "SVG_INVALID" - "ZIP_INVALID"
   * @param warnedValidationRules warnedValidationRules or {@code null} for none
   */
  public CreativeAssetMetadata setWarnedValidationRules(java.util.List<java.lang.String> warnedValidationRules) {
    this.warnedValidationRules = warnedValidationRules;
    return this;
  }

  @Override
  public CreativeAssetMetadata set(String fieldName, Object value) {
    return (CreativeAssetMetadata) super.set(fieldName, value);
  }

  @Override
  public CreativeAssetMetadata clone() {
    return (CreativeAssetMetadata) super.clone();
  }

}
