/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Creative Assignment.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreativeAssignment extends com.google.api.client.json.GenericJson {

  /**
   * Whether this creative assignment is active. When true, the creative will be included in the
   * ad's rotation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean active;

  /**
   * Whether applicable event tags should fire when this creative assignment is rendered. If this
   * value is unset when the ad is inserted or updated, it will default to true for all creative
   * types EXCEPT for INTERNAL_REDIRECT, INTERSTITIAL_INTERNAL_REDIRECT, and INSTREAM_VIDEO.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean applyEventTags;

  /**
   * Click-through URL of the creative assignment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ClickThroughUrl clickThroughUrl;

  /**
   * Companion creative overrides for this creative assignment. Applicable to video ads.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CompanionClickThroughOverride> companionCreativeOverrides;

  static {
    // hack to force ProGuard to consider CompanionClickThroughOverride used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(CompanionClickThroughOverride.class);
  }

  /**
   * Creative group assignments for this creative assignment. Only one assignment per creative group
   * number is allowed for a maximum of two assignments.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CreativeGroupAssignment> creativeGroupAssignments;

  /**
   * ID of the creative to be assigned. This is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long creativeId;

  /**
   * Dimension value for the ID of the creative. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionValue creativeIdDimensionValue;

  /**
   * Date and time that the assigned creative should stop serving. Must be later than the start
   * time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime endTime;

  /**
   * Rich media exit overrides for this creative assignment. Applicable when the creative type is
   * any of the following:  - DISPLAY - RICH_MEDIA_INPAGE - RICH_MEDIA_INPAGE_FLOATING -
   * RICH_MEDIA_IM_EXPAND - RICH_MEDIA_EXPANDING - RICH_MEDIA_INTERSTITIAL_FLOAT -
   * RICH_MEDIA_MOBILE_IN_APP - RICH_MEDIA_MULTI_FLOATING - RICH_MEDIA_PEEL_DOWN - VPAID_LINEAR -
   * VPAID_NON_LINEAR
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<RichMediaExitOverride> richMediaExitOverrides;

  /**
   * Sequence number of the creative assignment, applicable when the rotation type is
   * CREATIVE_ROTATION_TYPE_SEQUENTIAL. Acceptable values are 1 to 65535, inclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer sequence;

  /**
   * Whether the creative to be assigned is SSL-compliant. This is a read-only field that is auto-
   * generated when the ad is inserted or updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean sslCompliant;

  /**
   * Date and time that the assigned creative should start serving.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime startTime;

  /**
   * Weight of the creative assignment, applicable when the rotation type is
   * CREATIVE_ROTATION_TYPE_RANDOM. Value must be greater than or equal to 1.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer weight;

  /**
   * Whether this creative assignment is active. When true, the creative will be included in the
   * ad's rotation.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getActive() {
    return active;
  }

  /**
   * Whether this creative assignment is active. When true, the creative will be included in the
   * ad's rotation.
   * @param active active or {@code null} for none
   */
  public CreativeAssignment setActive(java.lang.Boolean active) {
    this.active = active;
    return this;
  }

  /**
   * Whether applicable event tags should fire when this creative assignment is rendered. If this
   * value is unset when the ad is inserted or updated, it will default to true for all creative
   * types EXCEPT for INTERNAL_REDIRECT, INTERSTITIAL_INTERNAL_REDIRECT, and INSTREAM_VIDEO.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getApplyEventTags() {
    return applyEventTags;
  }

  /**
   * Whether applicable event tags should fire when this creative assignment is rendered. If this
   * value is unset when the ad is inserted or updated, it will default to true for all creative
   * types EXCEPT for INTERNAL_REDIRECT, INTERSTITIAL_INTERNAL_REDIRECT, and INSTREAM_VIDEO.
   * @param applyEventTags applyEventTags or {@code null} for none
   */
  public CreativeAssignment setApplyEventTags(java.lang.Boolean applyEventTags) {
    this.applyEventTags = applyEventTags;
    return this;
  }

  /**
   * Click-through URL of the creative assignment.
   * @return value or {@code null} for none
   */
  public ClickThroughUrl getClickThroughUrl() {
    return clickThroughUrl;
  }

  /**
   * Click-through URL of the creative assignment.
   * @param clickThroughUrl clickThroughUrl or {@code null} for none
   */
  public CreativeAssignment setClickThroughUrl(ClickThroughUrl clickThroughUrl) {
    this.clickThroughUrl = clickThroughUrl;
    return this;
  }

  /**
   * Companion creative overrides for this creative assignment. Applicable to video ads.
   * @return value or {@code null} for none
   */
  public java.util.List<CompanionClickThroughOverride> getCompanionCreativeOverrides() {
    return companionCreativeOverrides;
  }

  /**
   * Companion creative overrides for this creative assignment. Applicable to video ads.
   * @param companionCreativeOverrides companionCreativeOverrides or {@code null} for none
   */
  public CreativeAssignment setCompanionCreativeOverrides(java.util.List<CompanionClickThroughOverride> companionCreativeOverrides) {
    this.companionCreativeOverrides = companionCreativeOverrides;
    return this;
  }

  /**
   * Creative group assignments for this creative assignment. Only one assignment per creative group
   * number is allowed for a maximum of two assignments.
   * @return value or {@code null} for none
   */
  public java.util.List<CreativeGroupAssignment> getCreativeGroupAssignments() {
    return creativeGroupAssignments;
  }

  /**
   * Creative group assignments for this creative assignment. Only one assignment per creative group
   * number is allowed for a maximum of two assignments.
   * @param creativeGroupAssignments creativeGroupAssignments or {@code null} for none
   */
  public CreativeAssignment setCreativeGroupAssignments(java.util.List<CreativeGroupAssignment> creativeGroupAssignments) {
    this.creativeGroupAssignments = creativeGroupAssignments;
    return this;
  }

  /**
   * ID of the creative to be assigned. This is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCreativeId() {
    return creativeId;
  }

  /**
   * ID of the creative to be assigned. This is a required field.
   * @param creativeId creativeId or {@code null} for none
   */
  public CreativeAssignment setCreativeId(java.lang.Long creativeId) {
    this.creativeId = creativeId;
    return this;
  }

  /**
   * Dimension value for the ID of the creative. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public DimensionValue getCreativeIdDimensionValue() {
    return creativeIdDimensionValue;
  }

  /**
   * Dimension value for the ID of the creative. This is a read-only, auto-generated field.
   * @param creativeIdDimensionValue creativeIdDimensionValue or {@code null} for none
   */
  public CreativeAssignment setCreativeIdDimensionValue(DimensionValue creativeIdDimensionValue) {
    this.creativeIdDimensionValue = creativeIdDimensionValue;
    return this;
  }

  /**
   * Date and time that the assigned creative should stop serving. Must be later than the start
   * time.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getEndTime() {
    return endTime;
  }

  /**
   * Date and time that the assigned creative should stop serving. Must be later than the start
   * time.
   * @param endTime endTime or {@code null} for none
   */
  public CreativeAssignment setEndTime(com.google.api.client.util.DateTime endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * Rich media exit overrides for this creative assignment. Applicable when the creative type is
   * any of the following:  - DISPLAY - RICH_MEDIA_INPAGE - RICH_MEDIA_INPAGE_FLOATING -
   * RICH_MEDIA_IM_EXPAND - RICH_MEDIA_EXPANDING - RICH_MEDIA_INTERSTITIAL_FLOAT -
   * RICH_MEDIA_MOBILE_IN_APP - RICH_MEDIA_MULTI_FLOATING - RICH_MEDIA_PEEL_DOWN - VPAID_LINEAR -
   * VPAID_NON_LINEAR
   * @return value or {@code null} for none
   */
  public java.util.List<RichMediaExitOverride> getRichMediaExitOverrides() {
    return richMediaExitOverrides;
  }

  /**
   * Rich media exit overrides for this creative assignment. Applicable when the creative type is
   * any of the following:  - DISPLAY - RICH_MEDIA_INPAGE - RICH_MEDIA_INPAGE_FLOATING -
   * RICH_MEDIA_IM_EXPAND - RICH_MEDIA_EXPANDING - RICH_MEDIA_INTERSTITIAL_FLOAT -
   * RICH_MEDIA_MOBILE_IN_APP - RICH_MEDIA_MULTI_FLOATING - RICH_MEDIA_PEEL_DOWN - VPAID_LINEAR -
   * VPAID_NON_LINEAR
   * @param richMediaExitOverrides richMediaExitOverrides or {@code null} for none
   */
  public CreativeAssignment setRichMediaExitOverrides(java.util.List<RichMediaExitOverride> richMediaExitOverrides) {
    this.richMediaExitOverrides = richMediaExitOverrides;
    return this;
  }

  /**
   * Sequence number of the creative assignment, applicable when the rotation type is
   * CREATIVE_ROTATION_TYPE_SEQUENTIAL. Acceptable values are 1 to 65535, inclusive.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSequence() {
    return sequence;
  }

  /**
   * Sequence number of the creative assignment, applicable when the rotation type is
   * CREATIVE_ROTATION_TYPE_SEQUENTIAL. Acceptable values are 1 to 65535, inclusive.
   * @param sequence sequence or {@code null} for none
   */
  public CreativeAssignment setSequence(java.lang.Integer sequence) {
    this.sequence = sequence;
    return this;
  }

  /**
   * Whether the creative to be assigned is SSL-compliant. This is a read-only field that is auto-
   * generated when the ad is inserted or updated.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSslCompliant() {
    return sslCompliant;
  }

  /**
   * Whether the creative to be assigned is SSL-compliant. This is a read-only field that is auto-
   * generated when the ad is inserted or updated.
   * @param sslCompliant sslCompliant or {@code null} for none
   */
  public CreativeAssignment setSslCompliant(java.lang.Boolean sslCompliant) {
    this.sslCompliant = sslCompliant;
    return this;
  }

  /**
   * Date and time that the assigned creative should start serving.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getStartTime() {
    return startTime;
  }

  /**
   * Date and time that the assigned creative should start serving.
   * @param startTime startTime or {@code null} for none
   */
  public CreativeAssignment setStartTime(com.google.api.client.util.DateTime startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * Weight of the creative assignment, applicable when the rotation type is
   * CREATIVE_ROTATION_TYPE_RANDOM. Value must be greater than or equal to 1.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getWeight() {
    return weight;
  }

  /**
   * Weight of the creative assignment, applicable when the rotation type is
   * CREATIVE_ROTATION_TYPE_RANDOM. Value must be greater than or equal to 1.
   * @param weight weight or {@code null} for none
   */
  public CreativeAssignment setWeight(java.lang.Integer weight) {
    this.weight = weight;
    return this;
  }

  @Override
  public CreativeAssignment set(String fieldName, Object value) {
    return (CreativeAssignment) super.set(fieldName, value);
  }

  @Override
  public CreativeAssignment clone() {
    return (CreativeAssignment) super.clone();
  }

}
