/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Experimental feature (no support provided) A custom event represents a third party impression, a
 * third party click, an annotation on a first party impression, or an annotation on a first party
 * click.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CustomEvent extends com.google.api.client.json.GenericJson {

  /**
   * Annotate a click event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CustomEventClickAnnotation annotateClickEvent;

  /**
   * Custom variables associated with the event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CustomVariable> customVariables;

  /**
   * The type of event. If INSERT, the fields in insertEvent need to be populated. If
   * ANNOTATE_CLICK, the fields in annotateClickEvent need to be populated. A custom event cannot
   * have both insertEvent and annotateClickEvent populated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String eventType;

  /**
   * Floodlight configuration ID of the advertiser the event is linked to. This is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long floodlightConfigurationId;

  /**
   * Insert custom event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CustomEventInsert insertEvent;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#customEvent".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The ordinal of this custom event. This is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ordinal;

  /**
   * The timestamp of this custom event, in Unix epoch micros. This is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long timestampMicros;

  /**
   * Annotate a click event.
   * @return value or {@code null} for none
   */
  public CustomEventClickAnnotation getAnnotateClickEvent() {
    return annotateClickEvent;
  }

  /**
   * Annotate a click event.
   * @param annotateClickEvent annotateClickEvent or {@code null} for none
   */
  public CustomEvent setAnnotateClickEvent(CustomEventClickAnnotation annotateClickEvent) {
    this.annotateClickEvent = annotateClickEvent;
    return this;
  }

  /**
   * Custom variables associated with the event.
   * @return value or {@code null} for none
   */
  public java.util.List<CustomVariable> getCustomVariables() {
    return customVariables;
  }

  /**
   * Custom variables associated with the event.
   * @param customVariables customVariables or {@code null} for none
   */
  public CustomEvent setCustomVariables(java.util.List<CustomVariable> customVariables) {
    this.customVariables = customVariables;
    return this;
  }

  /**
   * The type of event. If INSERT, the fields in insertEvent need to be populated. If
   * ANNOTATE_CLICK, the fields in annotateClickEvent need to be populated. A custom event cannot
   * have both insertEvent and annotateClickEvent populated.
   * @return value or {@code null} for none
   */
  public java.lang.String getEventType() {
    return eventType;
  }

  /**
   * The type of event. If INSERT, the fields in insertEvent need to be populated. If
   * ANNOTATE_CLICK, the fields in annotateClickEvent need to be populated. A custom event cannot
   * have both insertEvent and annotateClickEvent populated.
   * @param eventType eventType or {@code null} for none
   */
  public CustomEvent setEventType(java.lang.String eventType) {
    this.eventType = eventType;
    return this;
  }

  /**
   * Floodlight configuration ID of the advertiser the event is linked to. This is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getFloodlightConfigurationId() {
    return floodlightConfigurationId;
  }

  /**
   * Floodlight configuration ID of the advertiser the event is linked to. This is a required field.
   * @param floodlightConfigurationId floodlightConfigurationId or {@code null} for none
   */
  public CustomEvent setFloodlightConfigurationId(java.lang.Long floodlightConfigurationId) {
    this.floodlightConfigurationId = floodlightConfigurationId;
    return this;
  }

  /**
   * Insert custom event.
   * @return value or {@code null} for none
   */
  public CustomEventInsert getInsertEvent() {
    return insertEvent;
  }

  /**
   * Insert custom event.
   * @param insertEvent insertEvent or {@code null} for none
   */
  public CustomEvent setInsertEvent(CustomEventInsert insertEvent) {
    this.insertEvent = insertEvent;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#customEvent".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dfareporting#customEvent".
   * @param kind kind or {@code null} for none
   */
  public CustomEvent setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The ordinal of this custom event. This is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.String getOrdinal() {
    return ordinal;
  }

  /**
   * The ordinal of this custom event. This is a required field.
   * @param ordinal ordinal or {@code null} for none
   */
  public CustomEvent setOrdinal(java.lang.String ordinal) {
    this.ordinal = ordinal;
    return this;
  }

  /**
   * The timestamp of this custom event, in Unix epoch micros. This is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTimestampMicros() {
    return timestampMicros;
  }

  /**
   * The timestamp of this custom event, in Unix epoch micros. This is a required field.
   * @param timestampMicros timestampMicros or {@code null} for none
   */
  public CustomEvent setTimestampMicros(java.lang.Long timestampMicros) {
    this.timestampMicros = timestampMicros;
    return this;
  }

  @Override
  public CustomEvent set(String fieldName, Object value) {
    return (CustomEvent) super.set(fieldName, value);
  }

  @Override
  public CustomEvent clone() {
    return (CustomEvent) super.clone();
  }

}
