/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Custom event to be inserted.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CustomEventInsert extends com.google.api.client.json.GenericJson {

  /**
   * Campaign Manager dimensions associated with the event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CampaignManagerIds cmDimensions;

  /**
   * DV360 dimensions associated with the event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DV3Ids dv3Dimensions;

  /**
   * The type of event to insert.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String insertEventType;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#customEventInsert".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The match ID field. A match ID is your own first-party identifier that has been synced with
   * Google using the match ID feature in Floodlight. This field is mutually exclusive with
   * mobileDeviceId, and at least one of the two fields is required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String matchId;

  /**
   * The mobile device ID. This field is mutually exclusive with matchId, and at least one of the
   * two fields is required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mobileDeviceId;

  /**
   * Campaign Manager dimensions associated with the event.
   * @return value or {@code null} for none
   */
  public CampaignManagerIds getCmDimensions() {
    return cmDimensions;
  }

  /**
   * Campaign Manager dimensions associated with the event.
   * @param cmDimensions cmDimensions or {@code null} for none
   */
  public CustomEventInsert setCmDimensions(CampaignManagerIds cmDimensions) {
    this.cmDimensions = cmDimensions;
    return this;
  }

  /**
   * DV360 dimensions associated with the event.
   * @return value or {@code null} for none
   */
  public DV3Ids getDv3Dimensions() {
    return dv3Dimensions;
  }

  /**
   * DV360 dimensions associated with the event.
   * @param dv3Dimensions dv3Dimensions or {@code null} for none
   */
  public CustomEventInsert setDv3Dimensions(DV3Ids dv3Dimensions) {
    this.dv3Dimensions = dv3Dimensions;
    return this;
  }

  /**
   * The type of event to insert.
   * @return value or {@code null} for none
   */
  public java.lang.String getInsertEventType() {
    return insertEventType;
  }

  /**
   * The type of event to insert.
   * @param insertEventType insertEventType or {@code null} for none
   */
  public CustomEventInsert setInsertEventType(java.lang.String insertEventType) {
    this.insertEventType = insertEventType;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#customEventInsert".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#customEventInsert".
   * @param kind kind or {@code null} for none
   */
  public CustomEventInsert setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The match ID field. A match ID is your own first-party identifier that has been synced with
   * Google using the match ID feature in Floodlight. This field is mutually exclusive with
   * mobileDeviceId, and at least one of the two fields is required.
   * @return value or {@code null} for none
   */
  public java.lang.String getMatchId() {
    return matchId;
  }

  /**
   * The match ID field. A match ID is your own first-party identifier that has been synced with
   * Google using the match ID feature in Floodlight. This field is mutually exclusive with
   * mobileDeviceId, and at least one of the two fields is required.
   * @param matchId matchId or {@code null} for none
   */
  public CustomEventInsert setMatchId(java.lang.String matchId) {
    this.matchId = matchId;
    return this;
  }

  /**
   * The mobile device ID. This field is mutually exclusive with matchId, and at least one of the
   * two fields is required.
   * @return value or {@code null} for none
   */
  public java.lang.String getMobileDeviceId() {
    return mobileDeviceId;
  }

  /**
   * The mobile device ID. This field is mutually exclusive with matchId, and at least one of the
   * two fields is required.
   * @param mobileDeviceId mobileDeviceId or {@code null} for none
   */
  public CustomEventInsert setMobileDeviceId(java.lang.String mobileDeviceId) {
    this.mobileDeviceId = mobileDeviceId;
    return this;
  }

  @Override
  public CustomEventInsert set(String fieldName, Object value) {
    return (CustomEventInsert) super.set(fieldName, value);
  }

  @Override
  public CustomEventInsert clone() {
    return (CustomEventInsert) super.clone();
  }

}
