/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * The original custom event that was inserted and whether there were any errors.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CustomEventStatus extends com.google.api.client.json.GenericJson {

  /**
   * The original custom event that was inserted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CustomEvent customEvent;

  /**
   * A list of errors related to this custom event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CustomEventError> errors;

  static {
    // hack to force ProGuard to consider CustomEventError used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(CustomEventError.class);
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#customEventStatus".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The original custom event that was inserted.
   * @return value or {@code null} for none
   */
  public CustomEvent getCustomEvent() {
    return customEvent;
  }

  /**
   * The original custom event that was inserted.
   * @param customEvent customEvent or {@code null} for none
   */
  public CustomEventStatus setCustomEvent(CustomEvent customEvent) {
    this.customEvent = customEvent;
    return this;
  }

  /**
   * A list of errors related to this custom event.
   * @return value or {@code null} for none
   */
  public java.util.List<CustomEventError> getErrors() {
    return errors;
  }

  /**
   * A list of errors related to this custom event.
   * @param errors errors or {@code null} for none
   */
  public CustomEventStatus setErrors(java.util.List<CustomEventError> errors) {
    this.errors = errors;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#customEventStatus".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#customEventStatus".
   * @param kind kind or {@code null} for none
   */
  public CustomEventStatus setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public CustomEventStatus set(String fieldName, Object value) {
    return (CustomEventStatus) super.set(fieldName, value);
  }

  @Override
  public CustomEventStatus clone() {
    return (CustomEventStatus) super.clone();
  }

}
