/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Custom Viewability Metric
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CustomViewabilityMetric extends com.google.api.client.json.GenericJson {

  /**
   * Configuration of the custom viewability metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CustomViewabilityMetricConfiguration configuration;

  /**
   * ID of the custom viewability metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Name of the custom viewability metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Configuration of the custom viewability metric.
   * @return value or {@code null} for none
   */
  public CustomViewabilityMetricConfiguration getConfiguration() {
    return configuration;
  }

  /**
   * Configuration of the custom viewability metric.
   * @param configuration configuration or {@code null} for none
   */
  public CustomViewabilityMetric setConfiguration(CustomViewabilityMetricConfiguration configuration) {
    this.configuration = configuration;
    return this;
  }

  /**
   * ID of the custom viewability metric.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * ID of the custom viewability metric.
   * @param id id or {@code null} for none
   */
  public CustomViewabilityMetric setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Name of the custom viewability metric.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the custom viewability metric.
   * @param name name or {@code null} for none
   */
  public CustomViewabilityMetric setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public CustomViewabilityMetric set(String fieldName, Object value) {
    return (CustomViewabilityMetric) super.set(fieldName, value);
  }

  @Override
  public CustomViewabilityMetric clone() {
    return (CustomViewabilityMetric) super.clone();
  }

}
