/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-27 at 03:57:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dfareporting.model;

/**
 * Contains properties of a Floodlight configuration.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the DCM/DFA Reporting And Trafficking API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FloodlightConfiguration extends com.google.api.client.json.GenericJson {

  /**
   * Account ID of this floodlight configuration. This is a read-only field that can be left blank.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long accountId;

  /**
   * Advertiser ID of the parent advertiser of this floodlight configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long advertiserId;

  /**
   * Dimension value for the ID of the advertiser. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionValue advertiserIdDimensionValue;

  /**
   * Whether advertiser data is shared with Google Analytics.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean analyticsDataSharingEnabled;

  /**
   * Custom Viewability metric for the floodlight configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CustomViewabilityMetric customViewabilityMetric;

  /**
   * Whether the exposure-to-conversion report is enabled. This report shows detailed pathway
   * information on up to 10 of the most recent ad exposures seen by a user before converting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean exposureToConversionEnabled;

  /**
   * Day that will be counted as the first day of the week in reports. This is a required field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String firstDayOfWeek;

  /**
   * ID of this floodlight configuration. This is a read-only, auto-generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * Dimension value for the ID of this floodlight configuration. This is a read-only, auto-
   * generated field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionValue idDimensionValue;

  /**
   * Whether in-app attribution tracking is enabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean inAppAttributionTrackingEnabled;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#floodlightConfiguration".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Lookback window settings for this floodlight configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LookbackConfiguration lookbackConfiguration;

  /**
   * Types of attribution options for natural search conversions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String naturalSearchConversionAttributionOption;

  /**
   * Settings for Campaign Manager Omniture integration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OmnitureSettings omnitureSettings;

  /**
   * Subaccount ID of this floodlight configuration. This is a read-only field that can be left
   * blank.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long subaccountId;

  /**
   * Configuration settings for dynamic and image floodlight tags.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TagSettings tagSettings;

  /**
   * List of third-party authentication tokens enabled for this configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ThirdPartyAuthenticationToken> thirdPartyAuthenticationTokens;

  /**
   * List of user defined variables enabled for this configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<UserDefinedVariableConfiguration> userDefinedVariableConfigurations;

  /**
   * Account ID of this floodlight configuration. This is a read-only field that can be left blank.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAccountId() {
    return accountId;
  }

  /**
   * Account ID of this floodlight configuration. This is a read-only field that can be left blank.
   * @param accountId accountId or {@code null} for none
   */
  public FloodlightConfiguration setAccountId(java.lang.Long accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Advertiser ID of the parent advertiser of this floodlight configuration.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAdvertiserId() {
    return advertiserId;
  }

  /**
   * Advertiser ID of the parent advertiser of this floodlight configuration.
   * @param advertiserId advertiserId or {@code null} for none
   */
  public FloodlightConfiguration setAdvertiserId(java.lang.Long advertiserId) {
    this.advertiserId = advertiserId;
    return this;
  }

  /**
   * Dimension value for the ID of the advertiser. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public DimensionValue getAdvertiserIdDimensionValue() {
    return advertiserIdDimensionValue;
  }

  /**
   * Dimension value for the ID of the advertiser. This is a read-only, auto-generated field.
   * @param advertiserIdDimensionValue advertiserIdDimensionValue or {@code null} for none
   */
  public FloodlightConfiguration setAdvertiserIdDimensionValue(DimensionValue advertiserIdDimensionValue) {
    this.advertiserIdDimensionValue = advertiserIdDimensionValue;
    return this;
  }

  /**
   * Whether advertiser data is shared with Google Analytics.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAnalyticsDataSharingEnabled() {
    return analyticsDataSharingEnabled;
  }

  /**
   * Whether advertiser data is shared with Google Analytics.
   * @param analyticsDataSharingEnabled analyticsDataSharingEnabled or {@code null} for none
   */
  public FloodlightConfiguration setAnalyticsDataSharingEnabled(java.lang.Boolean analyticsDataSharingEnabled) {
    this.analyticsDataSharingEnabled = analyticsDataSharingEnabled;
    return this;
  }

  /**
   * Custom Viewability metric for the floodlight configuration.
   * @return value or {@code null} for none
   */
  public CustomViewabilityMetric getCustomViewabilityMetric() {
    return customViewabilityMetric;
  }

  /**
   * Custom Viewability metric for the floodlight configuration.
   * @param customViewabilityMetric customViewabilityMetric or {@code null} for none
   */
  public FloodlightConfiguration setCustomViewabilityMetric(CustomViewabilityMetric customViewabilityMetric) {
    this.customViewabilityMetric = customViewabilityMetric;
    return this;
  }

  /**
   * Whether the exposure-to-conversion report is enabled. This report shows detailed pathway
   * information on up to 10 of the most recent ad exposures seen by a user before converting.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getExposureToConversionEnabled() {
    return exposureToConversionEnabled;
  }

  /**
   * Whether the exposure-to-conversion report is enabled. This report shows detailed pathway
   * information on up to 10 of the most recent ad exposures seen by a user before converting.
   * @param exposureToConversionEnabled exposureToConversionEnabled or {@code null} for none
   */
  public FloodlightConfiguration setExposureToConversionEnabled(java.lang.Boolean exposureToConversionEnabled) {
    this.exposureToConversionEnabled = exposureToConversionEnabled;
    return this;
  }

  /**
   * Day that will be counted as the first day of the week in reports. This is a required field.
   * @return value or {@code null} for none
   */
  public java.lang.String getFirstDayOfWeek() {
    return firstDayOfWeek;
  }

  /**
   * Day that will be counted as the first day of the week in reports. This is a required field.
   * @param firstDayOfWeek firstDayOfWeek or {@code null} for none
   */
  public FloodlightConfiguration setFirstDayOfWeek(java.lang.String firstDayOfWeek) {
    this.firstDayOfWeek = firstDayOfWeek;
    return this;
  }

  /**
   * ID of this floodlight configuration. This is a read-only, auto-generated field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * ID of this floodlight configuration. This is a read-only, auto-generated field.
   * @param id id or {@code null} for none
   */
  public FloodlightConfiguration setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * Dimension value for the ID of this floodlight configuration. This is a read-only, auto-
   * generated field.
   * @return value or {@code null} for none
   */
  public DimensionValue getIdDimensionValue() {
    return idDimensionValue;
  }

  /**
   * Dimension value for the ID of this floodlight configuration. This is a read-only, auto-
   * generated field.
   * @param idDimensionValue idDimensionValue or {@code null} for none
   */
  public FloodlightConfiguration setIdDimensionValue(DimensionValue idDimensionValue) {
    this.idDimensionValue = idDimensionValue;
    return this;
  }

  /**
   * Whether in-app attribution tracking is enabled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getInAppAttributionTrackingEnabled() {
    return inAppAttributionTrackingEnabled;
  }

  /**
   * Whether in-app attribution tracking is enabled.
   * @param inAppAttributionTrackingEnabled inAppAttributionTrackingEnabled or {@code null} for none
   */
  public FloodlightConfiguration setInAppAttributionTrackingEnabled(java.lang.Boolean inAppAttributionTrackingEnabled) {
    this.inAppAttributionTrackingEnabled = inAppAttributionTrackingEnabled;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#floodlightConfiguration".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#floodlightConfiguration".
   * @param kind kind or {@code null} for none
   */
  public FloodlightConfiguration setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Lookback window settings for this floodlight configuration.
   * @return value or {@code null} for none
   */
  public LookbackConfiguration getLookbackConfiguration() {
    return lookbackConfiguration;
  }

  /**
   * Lookback window settings for this floodlight configuration.
   * @param lookbackConfiguration lookbackConfiguration or {@code null} for none
   */
  public FloodlightConfiguration setLookbackConfiguration(LookbackConfiguration lookbackConfiguration) {
    this.lookbackConfiguration = lookbackConfiguration;
    return this;
  }

  /**
   * Types of attribution options for natural search conversions.
   * @return value or {@code null} for none
   */
  public java.lang.String getNaturalSearchConversionAttributionOption() {
    return naturalSearchConversionAttributionOption;
  }

  /**
   * Types of attribution options for natural search conversions.
   * @param naturalSearchConversionAttributionOption naturalSearchConversionAttributionOption or {@code null} for none
   */
  public FloodlightConfiguration setNaturalSearchConversionAttributionOption(java.lang.String naturalSearchConversionAttributionOption) {
    this.naturalSearchConversionAttributionOption = naturalSearchConversionAttributionOption;
    return this;
  }

  /**
   * Settings for Campaign Manager Omniture integration.
   * @return value or {@code null} for none
   */
  public OmnitureSettings getOmnitureSettings() {
    return omnitureSettings;
  }

  /**
   * Settings for Campaign Manager Omniture integration.
   * @param omnitureSettings omnitureSettings or {@code null} for none
   */
  public FloodlightConfiguration setOmnitureSettings(OmnitureSettings omnitureSettings) {
    this.omnitureSettings = omnitureSettings;
    return this;
  }

  /**
   * Subaccount ID of this floodlight configuration. This is a read-only field that can be left
   * blank.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSubaccountId() {
    return subaccountId;
  }

  /**
   * Subaccount ID of this floodlight configuration. This is a read-only field that can be left
   * blank.
   * @param subaccountId subaccountId or {@code null} for none
   */
  public FloodlightConfiguration setSubaccountId(java.lang.Long subaccountId) {
    this.subaccountId = subaccountId;
    return this;
  }

  /**
   * Configuration settings for dynamic and image floodlight tags.
   * @return value or {@code null} for none
   */
  public TagSettings getTagSettings() {
    return tagSettings;
  }

  /**
   * Configuration settings for dynamic and image floodlight tags.
   * @param tagSettings tagSettings or {@code null} for none
   */
  public FloodlightConfiguration setTagSettings(TagSettings tagSettings) {
    this.tagSettings = tagSettings;
    return this;
  }

  /**
   * List of third-party authentication tokens enabled for this configuration.
   * @return value or {@code null} for none
   */
  public java.util.List<ThirdPartyAuthenticationToken> getThirdPartyAuthenticationTokens() {
    return thirdPartyAuthenticationTokens;
  }

  /**
   * List of third-party authentication tokens enabled for this configuration.
   * @param thirdPartyAuthenticationTokens thirdPartyAuthenticationTokens or {@code null} for none
   */
  public FloodlightConfiguration setThirdPartyAuthenticationTokens(java.util.List<ThirdPartyAuthenticationToken> thirdPartyAuthenticationTokens) {
    this.thirdPartyAuthenticationTokens = thirdPartyAuthenticationTokens;
    return this;
  }

  /**
   * List of user defined variables enabled for this configuration.
   * @return value or {@code null} for none
   */
  public java.util.List<UserDefinedVariableConfiguration> getUserDefinedVariableConfigurations() {
    return userDefinedVariableConfigurations;
  }

  /**
   * List of user defined variables enabled for this configuration.
   * @param userDefinedVariableConfigurations userDefinedVariableConfigurations or {@code null} for none
   */
  public FloodlightConfiguration setUserDefinedVariableConfigurations(java.util.List<UserDefinedVariableConfiguration> userDefinedVariableConfigurations) {
    this.userDefinedVariableConfigurations = userDefinedVariableConfigurations;
    return this;
  }

  @Override
  public FloodlightConfiguration set(String fieldName, Object value) {
    return (FloodlightConfiguration) super.set(fieldName, value);
  }

  @Override
  public FloodlightConfiguration clone() {
    return (FloodlightConfiguration) super.clone();
  }

}
